/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static Activator instance;
    public static final String CONTEXT_TYPE_RPG_FIXED = "miworkplace.ui.editor.contextType.rpg.fixed";
    public static final String CONTEXT_TYPE_RPG_FREE = "miworkplace.ui.editor.contextType.rpg.free";
    public static final String CONTEXT_TYPE_ILEDOCS = "miworkplace.ui.editor.contextType.iledocs";
    public static final String CONTEXT_TYPE_DEFAULT = "miworkplace.ui.editor.contextType.default";
    private ImageRegistry imageRegistry;
    private TemplateStore templateStore = null;
    private ContextTypeRegistry contextTypeRegistry = null;
    private PreferenceStore preferenceStore;
    private PreferenceStore syntaxHighlightPrefStore;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.preferenceStore != null) {
            this.preferenceStore.save();
        }
        instance = null;
        context = null;
    }

    private TemplateStore buildTemplateStore() throws IOException {
        TemplateStore templateStore = new TemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), "miworkplace.ui.editor.templates");
        templateStore.load();
        return templateStore;
    }

    private IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            Bundle bundle = Platform.getBundle((String)"miworkplace.ui.editor");
            IPath bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
            File prefStoreFile = bundleStateLocation.append("preference-store.pref").toFile();
            try {
                if (!prefStoreFile.exists()) {
                    prefStoreFile.createNewFile();
                }
                this.preferenceStore = new PreferenceStore(prefStoreFile.getAbsolutePath());
                this.preferenceStore.load();
            }
            catch (IOException iOException) {}
        }
        return this.preferenceStore;
    }

    public ContextTypeRegistry buildContextTypeRegistry() {
        ContextTypeRegistry contextTypeReg = new ContextTypeRegistry();
        contextTypeReg.addContextType(this.buildTemplateContextType(CONTEXT_TYPE_RPG_FREE, "RPG free format"));
        contextTypeReg.addContextType(this.buildTemplateContextType(CONTEXT_TYPE_RPG_FIXED, "RPG fixed format"));
        contextTypeReg.addContextType(this.buildTemplateContextType(CONTEXT_TYPE_ILEDOCS, "ILEDocs"));
        contextTypeReg.addContextType(this.buildTemplateContextType(CONTEXT_TYPE_DEFAULT, "Default"));
        return contextTypeReg;
    }

    public TemplateContextType buildTemplateContextType(String id, String name) {
        TemplateContextType ct = new TemplateContextType(id, name);
        ct.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        ct.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        ct.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        ct.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        return ct;
    }

    private ImageRegistry buildImageRegistry() {
        ImageRegistry imageRegistry = new ImageRegistry();
        imageRegistry.put(Images.iledocs.name(), new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/icons/iledocs.gif")));
        imageRegistry.put(Images.template.name(), new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/icons/template.gif")));
        imageRegistry.put(Images.bif.name(), new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/icons/opcode.gif")));
        return imageRegistry;
    }

    public static Activator getDefault() {
        return instance;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.buildImageRegistry();
        }
        return this.imageRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            try {
                this.templateStore = this.buildTemplateStore();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.templateStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            this.contextTypeRegistry = this.buildContextTypeRegistry();
        }
        return this.contextTypeRegistry;
    }

    public PreferenceStore getSyntaxHighlightingPreferenceStore() {
        if (this.syntaxHighlightPrefStore == null) {
            this.syntaxHighlightPrefStore = new PreferenceStore();
            try {
                URL resource = this.context.getBundle().getResource("miworkplace/ui/editor/text/syntax_highlighting.properties");
                if (resource != null) {
                    this.syntaxHighlightPrefStore.load(resource.openStream());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load properties for syntax highlighting.", ioe);
            }
            catch (NullPointerException npe) {
                throw new RuntimeException("No opcode properties in properties file.", npe);
            }
        }
        return this.syntaxHighlightPrefStore;
    }

    public static enum Images {
        iledocs,
        template,
        prototype,
        bif;

    }
}

