/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PrinterAvailableAction;
import com.ibm.as400.vaccess.PrinterHoldAction;
import com.ibm.as400.vaccess.PrinterPropertiesPane;
import com.ibm.as400.vaccess.PrinterReleaseAction;
import com.ibm.as400.vaccess.PrinterStartAction;
import com.ibm.as400.vaccess.PrinterStopAction;
import com.ibm.as400.vaccess.PrinterUnavailableAction;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPrinterOutput;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VPrinter
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final Object OUTPUTQUEUE_PROPERTY = "Output queue";
    public static final Object PRINTER_PROPERTY = "Printer";
    public static final Object STATUS_PROPERTY = "Status";
    private static String description_ = ResourceLoader.getPrintText("AS400_PRINTER");
    private static Icon icon16_ = ResourceLoader.getIcon("VPrinter16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VPrinter32.gif", description_);
    private static final int supportedVRM_ = 262400;
    private static boolean requestNotSupportedFired_ = false;
    private Printer printer_;
    private transient VNode parent_;
    private transient VPrinterOutput printerOutput_;
    private transient VAction[] actions_;
    private transient PrinterPropertiesPane propertiesPane_;
    private transient boolean systemNotSupported_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    private transient VObjectListener_ objectListener_;
    private static final int HOLD_ACTION = 0;
    private static final int RELEASE_ACTION = 1;
    private static final int START_ACTION = 2;
    private static final int STOP_ACTION = 3;
    private static final int AVAILABLE_ACTION = 4;
    private static final int UNAVAILABLE_ACTION = 5;
    private static final int LAST_ACTION = 5;
    private static String activeReaderText_ = null;
    private static String activeText_;
    private static String activeWriterText_;
    private static String afterAllFilesPrintText_;
    private static String afterCurFilePrintsText_;
    private static String allText_;
    private static String as36DisabledText_;
    private static String as36EnabledText_;
    private static String automaticText_;
    private static String availableText_;
    private static String availablePendingText_;
    private static String beingServicedText_;
    private static String connectPendingText_;
    private static String damagedText_;
    private static String deviceDefaultText_;
    private static String diagnosticModeText_;
    private static String endedText_;
    private static String failedReaderText_;
    private static String failedText_;
    private static String failedWriterText_;
    private static String fileDefaultText_;
    private static String formsText_;
    private static String heldText_;
    private static String holdPendingText_;
    private static String lockedText_;
    private static String messageWaitingText_;
    private static String noText_;
    private static String onJobQueueText_;
    private static String onlyFirstFileText_;
    private static String poweredOffText_;
    private static String poweredOffNotAvailText_;
    private static String printingText_;
    private static String recoveryCancelledText_;
    private static String recoveryPendingText_;
    private static String releasedText_;
    private static String signonDisplayText_;
    private static String standardText_;
    private static String startedText_;
    private static String stopPendingText_;
    private static String stoppedText_;
    private static String unavailableText_;
    private static String unavailablePendingText_;
    private static String unknownText_;
    private static String unusableText_;
    private static String variedOffText_;
    private static String variedOnText_;
    private static String varyOffPendingText_;
    private static String varyOnPendingText_;
    private static String waitingForOutQText_;
    private static String waitingForPrinterText_;
    private static String waitingOnMessageText_;
    private static String waitingOnJobQueueQSPL_;
    private static String yesText_;
    static final int OVERALLSTATUS_UNAVAILABLE = 1;
    static final int OVERALLSTATUS_POWEREDOFFNOTAVAILALBE = 2;
    static final int OVERALLSTATUS_STOPPED = 3;
    static final int OVERALLSTATUS_MESSAGEWAITING = 4;
    static final int OVERALLSTATUS_HELD = 5;
    static final int OVERALLSTATUS_STOPPENDING = 6;
    static final int OVERALLSTATUS_HOLDPENDING = 7;
    static final int OVERALLSTATUS_WAITINGFORPRINTER = 8;
    static final int OVERALLSTATUS_WAITINGTOSTART = 9;
    static final int OVERALLSTATUS_PRINTING = 10;
    static final int OVERALLSTATUS_WAITINGFOROUTQ = 11;
    static final int OVERALLSTATUS_CONNECTPENDING = 12;
    static final int OVERALLSTATUS_POWEREDOFF = 13;
    static final int OVERALLSTATUS_UNUSABLE = 14;
    static final int OVERALLSTATUS_BEINGSERVICED = 15;
    static final int OVERALLSTATUS_UNKNOWN = 999;
    static final int DEVICESTATUS_VARIEDOFF = 0;
    static final int DEVICESTATUS_AS36DISABLED = 5;
    static final int DEVICESTATUS_VARYOFFPENDING = 10;
    static final int DEVICESTATUS_VARYONPENDING = 20;
    static final int DEVICESTATUS_VARIEDON = 30;
    static final int DEVICESTATUS_CONNECTPENDING = 40;
    static final int DEVICESTATUS_SIGNONDISPLAY = 50;
    static final int DEVICESTATUS_ACTIVE = 60;
    static final int DEVICESTATUS_AS36ENABLED = 62;
    static final int DEVICESTATUS_ACTIVEREADER = 63;
    static final int DEVICESTATUS_ACTIVEWRITER = 66;
    static final int DEVICESTATUS_HELD = 70;
    static final int DEVICESTATUS_POWEREDOFF = 75;
    static final int DEVICESTATUS_RECOVERYPENDING = 80;
    static final int DEVICESTATUS_RECOVERYCANCELLED = 90;
    static final int DEVICESTATUS_FAILED = 100;
    static final int DEVICESTATUS_FAILED_READER = 103;
    static final int DEVICESTATUS_FAILED_WRITER = 106;
    static final int DEVICESTATUS_DIAGNOSTICMODE = 110;
    static final int DEVICESTATUS_DAMAGED = 111;
    static final int DEVICESTATUS_LOCKED = 112;
    static final int DEVICESTATUS_UNKNOWN = 113;
    static final int DRAWERSEP_FILE = -1;
    static final int DRAWERSEP_DEVD = -2;
    static final String ENDString_ = "END";
    static final String HELDString_ = "HELD";
    static final String HLDString_ = "HLD";
    static final String JOBQString_ = "JOBQ";
    static final String MSGWString_ = "MSGW";
    static final String RELEASEDString_ = "RELEASED";
    static final String STRString_ = "STR";
    static final String splatAFPDSString_ = "*AFPDS";
    static final String splatALLString_ = "*ALL";
    static final String splatCURRENTString_ = "*CURRENT";
    static final String splatFILEString_ = "*FILE";
    static final String splatFILEENDString_ = "*FILEEND";
    static final String splatFIRSTString_ = "*FIRST";
    static final String splatFORMSString_ = "*FORMS";
    static final String splatIPDSString_ = "*IPDS";
    static final String splatNORDYFString_ = "*NORDYF";
    static final String splatNOString_ = "*NO";
    static final String splatSCSString_ = "*SCS";
    static final String splatSTDString_ = "*STD";
    static final String splatUSERASCIIString_ = "*USERASCII";
    static final String splatWTRString_ = "*WTR";
    static final String splatYESString_ = "*YES";
    static final String ASCIIString_ = "ASCII";
    static final String AFPDSString_ = "AFPDS";
    static final String IPDSString_ = "IPDS";
    static final String SCSString_ = "SCS";

    public VPrinter() {
        this.printer_ = null;
        this.systemNotSupported_ = false;
        this.errorEventSupport_ = null;
        this.printer_ = new Printer();
        this.parent_ = null;
        this.printerOutput_ = new VPrinterOutput(true);
        this.initializeTransient();
    }

    public VPrinter(Printer printer) {
        block4: {
            this.printer_ = null;
            this.systemNotSupported_ = false;
            this.errorEventSupport_ = null;
            this.errorEventSupport_ = null;
            if (printer == null) {
                throw new NullPointerException("printer");
            }
            this.printer_ = printer;
            try {
                AS400 aS400 = this.printer_.getSystem();
                int n = aS400.getVRM();
                if (n < 262400) {
                    this.systemNotSupported_ = true;
                }
            }
            catch (Exception exception) {
                if (this.errorEventSupport_ == null) break block4;
                this.errorEventSupport_.fireError(exception);
            }
        }
        this.parent_ = null;
        this.printerOutput_ = new VPrinterOutput(printer.getSystem(), true);
        this.initializeTransient();
    }

    public VPrinter(VNode vNode, Printer printer) {
        block5: {
            this.printer_ = null;
            this.systemNotSupported_ = false;
            this.errorEventSupport_ = null;
            this.errorEventSupport_ = null;
            if (vNode == null) {
                throw new NullPointerException("parent");
            }
            if (printer == null) {
                throw new NullPointerException("printer");
            }
            this.printer_ = printer;
            try {
                AS400 aS400 = this.printer_.getSystem();
                int n = aS400.getVRM();
                if (n < 262400) {
                    this.systemNotSupported_ = true;
                }
            }
            catch (Exception exception) {
                if (this.errorEventSupport_ == null) break block5;
                this.errorEventSupport_.fireError(exception);
            }
        }
        this.parent_ = vNode;
        this.printerOutput_ = new VPrinterOutput(printer.getSystem(), true);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    public VAction[] getActions() {
        this.reloadActions();
        return this.actions_;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int n) {
        return this.printerOutput_.getDetailsChildAt(n);
    }

    public int getDetailsChildCount() {
        return this.printerOutput_.getDetailsChildCount();
    }

    public TableColumnModel getDetailsColumnModel() {
        return this.printerOutput_.getDetailsColumnModel();
    }

    public int getDetailsIndex(VObject vObject) {
        return this.printerOutput_.getDetailsIndex(vObject);
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public Printer getPrinter() {
        return this.printer_;
    }

    String getPrinterAttribute(int n) {
        this.loadStrings();
        if (this.systemNotSupported_ && requestNotSupportedFired_) {
            switch (n) {
                case 12: 
                case 44: 
                case 48: 
                case 62: 
                case 67: 
                case 75: 
                case 90: 
                case 104: 
                case 105: 
                case 116: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 187: 
                case 190: 
                case 191: 
                case 193: 
                case 197: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: {
                    return "";
                }
            }
        }
        try {
            switch (n) {
                case 10: 
                case 12: {
                    String string = this.printer_.getStringAttribute(n);
                    if (string == null) {
                        return "";
                    }
                    if ((string = string.trim()).compareTo(splatYESString_) == 0) {
                        return yesText_;
                    }
                    if (string.compareTo(splatNOString_) == 0) {
                        return noText_;
                    }
                    return "";
                }
                case 190: {
                    String string = this.printer_.getStringAttribute(n);
                    if (string == null) {
                        return "";
                    }
                    if ((string = string.trim()).compareTo(splatFILEString_) == 0) {
                        return fileDefaultText_;
                    }
                    if (string.compareTo(splatFIRSTString_) == 0) {
                        return onlyFirstFileText_;
                    }
                    if (string.compareTo(splatWTRString_) == 0) {
                        return automaticText_;
                    }
                    return "";
                }
                case 191: {
                    String string = this.printer_.getStringAttribute(n);
                    if (string == null) {
                        return "";
                    }
                    if ((string = string.trim()).compareTo(splatNORDYFString_) == 0) {
                        return afterCurFilePrintsText_;
                    }
                    if (string.compareTo(splatFILEENDString_) == 0) {
                        return afterAllFilesPrintText_;
                    }
                    return "";
                }
                case 199: {
                    Integer n2 = this.printer_.getIntegerAttribute(n);
                    if (n2 == null) {
                        return "";
                    }
                    switch (n2) {
                        case 0: {
                            return unavailableText_;
                        }
                        case 5: {
                            return as36DisabledText_;
                        }
                        case 10: {
                            return unavailablePendingText_;
                        }
                        case 20: {
                            return availablePendingText_;
                        }
                        case 30: {
                            return availableText_;
                        }
                        case 40: {
                            return connectPendingText_;
                        }
                        case 50: {
                            return signonDisplayText_;
                        }
                        case 60: {
                            return activeText_;
                        }
                        case 62: {
                            return as36EnabledText_;
                        }
                        case 63: {
                            return activeReaderText_;
                        }
                        case 66: {
                            return activeWriterText_;
                        }
                        case 70: {
                            return heldText_;
                        }
                        case 75: {
                            return poweredOffText_;
                        }
                        case 80: {
                            return recoveryPendingText_;
                        }
                        case 90: {
                            return recoveryCancelledText_;
                        }
                        case 100: {
                            return unusableText_;
                        }
                        case 103: {
                            return failedReaderText_;
                        }
                        case 106: {
                            return failedWriterText_;
                        }
                        case 110: {
                            return beingServicedText_;
                        }
                        case 111: {
                            return damagedText_;
                        }
                        case 112: {
                            return lockedText_;
                        }
                        case 113: {
                            return unknownText_;
                        }
                    }
                    return "";
                }
                case 42: {
                    Integer n3 = this.printer_.getIntegerAttribute(n);
                    if (n3 == null) {
                        return "";
                    }
                    switch (n3) {
                        case -1: {
                            return fileDefaultText_;
                        }
                        case -2: {
                            return deviceDefaultText_;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            return n3.toString();
                        }
                    }
                    return "";
                }
                case 44: {
                    Integer n4 = this.printer_.getIntegerAttribute(n);
                    if (n4 == null) {
                        return "";
                    }
                    if (n4 == -1) {
                        return fileDefaultText_;
                    }
                    return n4.toString();
                }
                case 48: {
                    String string = this.printer_.getStringAttribute(n);
                    if (string == null) {
                        return "";
                    }
                    if ((string = string.trim()).compareTo(splatALLString_) == 0) {
                        return allText_;
                    }
                    if (string.compareTo(splatFORMSString_) == 0) {
                        return formsText_;
                    }
                    if (string.compareTo(splatSTDString_) == 0) {
                        return standardText_;
                    }
                    return "";
                }
                case 75: {
                    String string = this.printer_.getStringAttribute(n);
                    if (string == null) {
                        return "";
                    }
                    if ((string = string.trim()).compareTo(RELEASEDString_) == 0) {
                        return releasedText_;
                    }
                    if (string.compareTo(HELDString_) == 0) {
                        return heldText_;
                    }
                    return "";
                }
                case 200: {
                    Integer n5 = this.printer_.getIntegerAttribute(n);
                    if (n5 == null) {
                        return "";
                    }
                    switch (n5) {
                        case 1: {
                            return unavailableText_;
                        }
                        case 2: {
                            return poweredOffNotAvailText_;
                        }
                        case 3: {
                            return stoppedText_;
                        }
                        case 4: {
                            return messageWaitingText_;
                        }
                        case 5: {
                            return heldText_;
                        }
                        case 6: {
                            return stopPendingText_;
                        }
                        case 7: {
                            return holdPendingText_;
                        }
                        case 8: {
                            return waitingForPrinterText_;
                        }
                        case 9: {
                            return waitingOnJobQueueQSPL_;
                        }
                        case 10: {
                            return printingText_;
                        }
                        case 11: {
                            return waitingForOutQText_;
                        }
                        case 12: {
                            return connectPendingText_;
                        }
                        case 13: {
                            return poweredOffText_;
                        }
                        case 14: {
                            return unusableText_;
                        }
                        case 15: {
                            return beingServicedText_;
                        }
                        case 999: {
                            return unknownText_;
                        }
                    }
                    return "";
                }
                case 40: 
                case 90: {
                    String string = this.printer_.getStringAttribute(n);
                    if (string == null) {
                        return "";
                    }
                    if ((string = string.trim()).compareTo(splatAFPDSString_) == 0) {
                        return AFPDSString_;
                    }
                    if (string.compareTo(splatIPDSString_) == 0) {
                        return IPDSString_;
                    }
                    if (string.compareTo(splatSCSString_) == 0) {
                        return SCSString_;
                    }
                    if (string.compareTo(splatUSERASCIIString_) == 0) {
                        return ASCIIString_;
                    }
                    return string;
                }
                case 120: {
                    String string = this.printer_.getStringAttribute(n);
                    if (string == null) {
                        return "";
                    }
                    if ((string = string.trim()).compareTo(splatYESString_) == 0) {
                        return yesText_;
                    }
                    if (string.compareTo(splatNOString_) == 0) {
                        return noText_;
                    }
                    if (string.compareTo(splatNORDYFString_) == 0) {
                        return afterCurFilePrintsText_;
                    }
                    if (string.compareTo(splatFILEENDString_) == 0) {
                        return afterAllFilesPrintText_;
                    }
                    return "";
                }
                case 123: {
                    String string = this.printer_.getStringAttribute(n);
                    if (string == null) {
                        return "";
                    }
                    if ((string = string.trim()).compareTo(ENDString_) == 0) {
                        return endedText_;
                    }
                    if (string.compareTo(HLDString_) == 0) {
                        return heldText_;
                    }
                    if (string.compareTo(JOBQString_) == 0) {
                        return onJobQueueText_;
                    }
                    if (string.compareTo(MSGWString_) == 0) {
                        return waitingOnMessageText_;
                    }
                    if (string.compareTo(STRString_) == 0) {
                        return startedText_;
                    }
                    return "";
                }
            }
            String string = this.printer_.getStringAttribute(n);
            if (string == null) {
                return "";
            }
            return string.trim();
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "VPrinter::getPrinterDeviceStatus failed getting attribute");
            }
            if (this.systemNotSupported_) {
                if (!requestNotSupportedFired_) {
                    this.errorEventSupport_.fireError(requestNotSupportedException);
                    requestNotSupportedFired_ = true;
                }
            } else {
                this.errorEventSupport_.fireError(requestNotSupportedException);
            }
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "VPrinter::getPrinterAttribute failed getting attribute ", n);
            }
            this.errorEventSupport_.fireError(exception);
        }
        return "";
    }

    int getPrinterDeviceStatus() {
        if (this.systemNotSupported_ && requestNotSupportedFired_) {
            return 113;
        }
        try {
            Integer n = this.printer_.getIntegerAttribute(199);
            if (n != null) {
                return n;
            }
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "VPrinter::getPrinterDeviceStatus failed getting attribute");
            }
            if (this.systemNotSupported_) {
                if (!requestNotSupportedFired_) {
                    this.errorEventSupport_.fireError(requestNotSupportedException);
                    requestNotSupportedFired_ = true;
                }
            } else {
                this.errorEventSupport_.fireError(requestNotSupportedException);
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        return 113;
    }

    String getPrinterOutputQueue() {
        if (this.systemNotSupported_ && requestNotSupportedFired_) {
            return "";
        }
        try {
            QSYSObjectPathName qSYSObjectPathName;
            String string = this.printer_.getStringAttribute(-6);
            if (string != null && (qSYSObjectPathName = new QSYSObjectPathName(string)) != null && (string = qSYSObjectPathName.getObjectName()) != null) {
                return string.trim();
            }
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "VPrinter::getPrinterOutputQueue failed getting attribute");
            }
            if (this.systemNotSupported_) {
                if (!requestNotSupportedFired_) {
                    this.errorEventSupport_.fireError(requestNotSupportedException);
                    requestNotSupportedFired_ = true;
                }
            } else {
                this.errorEventSupport_.fireError(requestNotSupportedException);
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        return "";
    }

    String getPrinterOutputQueueLib() {
        if (this.systemNotSupported_ && requestNotSupportedFired_) {
            return "";
        }
        try {
            QSYSObjectPathName qSYSObjectPathName;
            String string = this.printer_.getStringAttribute(-6);
            if (string != null && (qSYSObjectPathName = new QSYSObjectPathName(string)) != null && (string = qSYSObjectPathName.getLibraryName()) != null) {
                return string.trim();
            }
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "VPrinter::getPrinterOutputQueueLib failed getting attribute ");
            }
            if (this.systemNotSupported_) {
                if (!requestNotSupportedFired_) {
                    this.errorEventSupport_.fireError(requestNotSupportedException);
                    requestNotSupportedFired_ = true;
                }
            } else {
                this.errorEventSupport_.fireError(requestNotSupportedException);
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        return "";
    }

    int getPrinterOverallStatus() {
        if (this.systemNotSupported_ && requestNotSupportedFired_) {
            return 999;
        }
        try {
            Integer n = this.printer_.getIntegerAttribute(200);
            if (n != null) {
                return n;
            }
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "VPrinter::getPrinterOverallStatus failed getting attribute ");
            }
            if (this.systemNotSupported_) {
                if (!requestNotSupportedFired_) {
                    this.errorEventSupport_.fireError(requestNotSupportedException);
                    requestNotSupportedFired_ = true;
                }
            } else {
                this.errorEventSupport_.fireError(requestNotSupportedException);
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        return 999;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        try {
            if (object == PRINTER_PROPERTY) {
                return this;
            }
            if (object == STATUS_PROPERTY) {
                return this.getPrinterAttribute(200);
            }
            if (object == DESCRIPTION_PROPERTY) {
                return this.getPrinterAttribute(109);
            }
            if (object == OUTPUTQUEUE_PROPERTY) {
                return this.getPrinterOutputQueue();
            }
            return null;
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
            return null;
        }
    }

    public String getText() {
        return this.printer_.getName();
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return true;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.objectListener_ = new VObjectListener_();
        this.printerOutput_.addErrorListener(this.errorEventSupport_);
        this.printerOutput_.addVObjectListener(this.objectEventSupport_);
        this.printerOutput_.addWorkingListener(this.workingEventSupport_);
        this.printerOutput_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.printerOutput_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.actions_ = new VAction[6];
        this.actions_[0] = new PrinterHoldAction(this, this.printer_);
        this.actions_[1] = new PrinterReleaseAction(this, this.printer_);
        this.actions_[2] = new PrinterStartAction(this, this.printer_);
        this.actions_[3] = new PrinterStopAction(this, this.printer_);
        this.actions_[4] = new PrinterAvailableAction(this, this.printer_);
        this.actions_[5] = new PrinterUnavailableAction(this, this.printer_);
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectEventSupport_);
            this.actions_[i].addVObjectListener(this.objectListener_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        try {
            String string;
            this.printerOutput_.setUserFilter(splatCURRENTString_);
            this.printerOutput_.setFormTypeFilter(splatALLString_);
            this.printerOutput_.setUserDataFilter(splatALLString_);
            if (this.printer_ != null && !this.systemNotSupported_ && (string = this.printer_.getStringAttribute(-6)) != null) {
                string = string.toUpperCase();
                this.printerOutput_.setQueueFilter(string);
            }
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "VPrinter::getPrinterOutputQueueLib failed getting attribute ");
            }
            if (this.systemNotSupported_) {
                if (!requestNotSupportedFired_) {
                    this.errorEventSupport_.fireError(requestNotSupportedException);
                }
            } else {
                this.errorEventSupport_.fireError(requestNotSupportedException);
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.propertiesPane_ = new PrinterPropertiesPane(this, this.printerOutput_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public void load() {
        try {
            String string;
            if (this.printerOutput_.getQueueFilter().equals("") && (string = this.printer_.getStringAttribute(-6)) != null) {
                string = string.toUpperCase();
                this.printerOutput_.setQueueFilter(string);
            }
            if (!this.printerOutput_.getQueueFilter().equals("")) {
                this.printer_.update();
                this.printerOutput_.load();
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
    }

    private synchronized void loadStrings() {
        if (activeReaderText_ == null) {
            try {
                activeReaderText_ = ResourceLoader.getPrintText("ACTIVE_READER");
                activeText_ = ResourceLoader.getPrintText("ACTIVE");
                activeWriterText_ = ResourceLoader.getPrintText("ACTIVE_WRITER");
                afterAllFilesPrintText_ = ResourceLoader.getPrintText("AFTER_ALL_FILES_PRINT");
                afterCurFilePrintsText_ = ResourceLoader.getPrintText("AFTER_CURRENT_FILE_PRINTS");
                allText_ = ResourceLoader.getPrintText("ALL");
                as36DisabledText_ = ResourceLoader.getPrintText("AS36_DISABLED");
                as36EnabledText_ = ResourceLoader.getPrintText("AS36_ENABLED");
                automaticText_ = ResourceLoader.getPrintText("AUTOMATIC");
                availableText_ = ResourceLoader.getPrintText("AVAILABLE");
                availablePendingText_ = ResourceLoader.getPrintText("AVAILABLE_PENDING");
                beingServicedText_ = ResourceLoader.getPrintText("BEING_SERVICED");
                connectPendingText_ = ResourceLoader.getPrintText("CONNECT_PENDING");
                damagedText_ = ResourceLoader.getPrintText("DAMAGED");
                deviceDefaultText_ = ResourceLoader.getPrintText("DEVICE_DEFAULT");
                diagnosticModeText_ = ResourceLoader.getPrintText("DIAGNOSTIC_MODE");
                endedText_ = ResourceLoader.getPrintText("ENDED");
                failedReaderText_ = ResourceLoader.getPrintText("FAILED_READER");
                failedText_ = ResourceLoader.getPrintText("FAILED");
                failedWriterText_ = ResourceLoader.getPrintText("FAILED_WRITER");
                fileDefaultText_ = ResourceLoader.getPrintText("FILE_DEFAULT");
                formsText_ = ResourceLoader.getPrintText("FORMS");
                heldText_ = ResourceLoader.getPrintText(HELDString_);
                holdPendingText_ = ResourceLoader.getPrintText("HOLD_PENDING");
                lockedText_ = ResourceLoader.getPrintText("LOCKED");
                messageWaitingText_ = ResourceLoader.getPrintText("MESSAGE_WAITING");
                noText_ = ResourceLoader.getPrintText("NO");
                onJobQueueText_ = ResourceLoader.getPrintText("ON_JOB_QUEUE");
                onlyFirstFileText_ = ResourceLoader.getPrintText("FILE_FORM_ALIGNMENT");
                poweredOffText_ = ResourceLoader.getPrintText("POWERED_OFF");
                poweredOffNotAvailText_ = ResourceLoader.getPrintText("POWERED_OFF_NOT_AVAILABLE");
                printingText_ = ResourceLoader.getPrintText("PRINTING");
                recoveryCancelledText_ = ResourceLoader.getPrintText("RECOVERY_CANCELLED");
                recoveryPendingText_ = ResourceLoader.getPrintText("RECOVERY_PENDING");
                releasedText_ = ResourceLoader.getPrintText(RELEASEDString_);
                signonDisplayText_ = ResourceLoader.getPrintText("SIGNON_DISPLAY");
                standardText_ = ResourceLoader.getPrintText("STANDARD");
                startedText_ = ResourceLoader.getPrintText("STARTED");
                stopPendingText_ = ResourceLoader.getPrintText("STOP_PENDING");
                stoppedText_ = ResourceLoader.getPrintText("STOPPED");
                unavailableText_ = ResourceLoader.getPrintText("UNAVAILABLE");
                unavailablePendingText_ = ResourceLoader.getPrintText("UNAVAILABLE_PENDING");
                unknownText_ = ResourceLoader.getPrintText("UNKNOWN");
                unusableText_ = ResourceLoader.getPrintText("UNUSABLE");
                variedOffText_ = ResourceLoader.getPrintText("VARIED_OFF");
                variedOnText_ = ResourceLoader.getPrintText("VARIED_ON");
                varyOffPendingText_ = ResourceLoader.getPrintText("VARY_OFF_PENDING");
                varyOnPendingText_ = ResourceLoader.getPrintText("VARY_ON_PENDING");
                waitingForOutQText_ = ResourceLoader.getPrintText("WAITING_FOR_OUTQ");
                waitingForPrinterText_ = ResourceLoader.getPrintText("WAITING_FOR_PRINTER");
                waitingOnMessageText_ = ResourceLoader.getPrintText("WAITING_ON_MESSAGE");
                waitingOnJobQueueQSPL_ = ResourceLoader.getPrintText("WAITING_ON_JOB_QUEUE_QSPL");
                yesText_ = ResourceLoader.getPrintText("YES");
            }
            catch (Exception exception) {
                this.errorEventSupport_.fireError(exception);
            }
        }
    }

    private void reloadActions() {
        if (this.systemNotSupported_) {
            this.actions_[0].setEnabled(false);
            this.actions_[1].setEnabled(false);
            this.actions_[2].setEnabled(false);
            this.actions_[3].setEnabled(false);
            this.actions_[4].setEnabled(false);
            this.actions_[5].setEnabled(false);
            return;
        }
        try {
            int n = this.getPrinterDeviceStatus();
            if (n == 30 || n == 60 || n == 66 || n == 70) {
                this.actions_[4].setEnabled(false);
                this.actions_[5].setEnabled(true);
                String string = this.printer_.getStringAttribute(123);
                if (string == null) {
                    this.actions_[0].setEnabled(false);
                    this.actions_[1].setEnabled(false);
                    this.actions_[2].setEnabled(true);
                    this.actions_[3].setEnabled(false);
                } else if ((string = string.trim()).equals(ENDString_)) {
                    this.actions_[0].setEnabled(false);
                    this.actions_[1].setEnabled(false);
                    this.actions_[2].setEnabled(true);
                    this.actions_[3].setEnabled(false);
                } else {
                    this.actions_[2].setEnabled(false);
                    this.actions_[3].setEnabled(true);
                    if (string.equals(HLDString_)) {
                        this.actions_[0].setEnabled(false);
                        this.actions_[1].setEnabled(true);
                    } else {
                        this.actions_[0].setEnabled(true);
                        this.actions_[1].setEnabled(false);
                    }
                }
            } else {
                this.actions_[0].setEnabled(false);
                this.actions_[1].setEnabled(false);
                this.actions_[2].setEnabled(false);
                this.actions_[3].setEnabled(false);
                this.actions_[4].setEnabled(true);
                this.actions_[5].setEnabled(false);
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setPrinter(Printer printer) throws PropertyVetoException {
        try {
            this.printer_ = printer;
            AS400 aS400 = this.printer_.getSystem();
            int n = aS400.getVRM();
            if (n < 262400) {
                this.systemNotSupported_ = true;
            }
            if (this.printerOutput_ == null) {
                this.printerOutput_ = new VPrinterOutput(printer.getSystem());
            } else {
                this.printerOutput_.setSystem(printer.getSystem());
            }
            String string = this.printer_.getStringAttribute(-6);
            if (string != null) {
                string = string.toUpperCase();
                this.printerOutput_.setQueueFilter(string);
            }
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "VPrinter::setPrinter failed getting attribute");
            }
            this.errorEventSupport_.fireError(requestNotSupportedException);
            requestNotSupportedFired_ = true;
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
        this.printerOutput_.sortDetailsChildren(objectArray, blArray);
    }

    public String toString() {
        return this.printer_.getName();
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        public void objectChanged(VObjectEvent vObjectEvent) {
            VPrinter.this.reloadActions();
        }

        public void objectCreated(VObjectEvent vObjectEvent) {
        }

        public void objectDeleted(VObjectEvent vObjectEvent) {
        }
    }
}

