/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.RPrinter;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ResourcePool;
import com.ibm.as400.resource.SystemResourceList;
import java.beans.PropertyVetoException;

public class RPrinterList
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRESENTATION_KEY_ = "PRINTER_LIST";
    private static final String ICON_BASE_NAME_ = "RPrinterList";
    private static PresentationLoader presentationLoader_;
    private static ResourceMetaDataTable selections_;
    public static final String PRINTER_NAMES = "PRINTER_NAMES";
    public static final String OUTPUT_QUEUES = "OUTPUT_QUEUES";
    private static ProgramMap openListAttributeMap_;
    private static final String openListProgramName_ = "qgyrprtl";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RPrinterList";
    private static ProgramCallDocument staticDocument_;
    private static final String formatName_ = "prtl0200";
    private static final String deviceNameDataName_ = ".receiverVariable.deviceName";

    public RPrinterList() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RPrinter.attributes_, selections_, null, openListProgramName_, formatName_, null);
    }

    public RPrinterList(AS400 aS400) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void establishConnection() throws ResourceException {
        super.establishConnection();
        this.setDocument((ProgramCallDocument)staticDocument_.clone());
    }

    void setOpenParameters(ProgramCallDocument programCallDocument) throws PcmlException, ResourceException {
        super.setOpenParameters(programCallDocument);
        Object object = this.getSelectionValue(PRINTER_NAMES);
        String[] stringArray = object == null ? new String[]{} : (object instanceof String ? new String[]{(String)object} : (String[])object);
        programCallDocument.setIntValue("qgyrprtl.filterInformation.numberOfPrinterNames", stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            programCallDocument.setValue("qgyrprtl.filterInformation.printerName", new int[]{i}, stringArray[i].toUpperCase());
        }
        Object object2 = this.getSelectionValue(OUTPUT_QUEUES);
        String[] stringArray2 = object2 == null ? new String[]{} : (object2 instanceof String ? new String[]{(String)object2} : (String[])object2);
        programCallDocument.setIntValue("qgyrprtl.filterInformation.numberOfOutputQueues", stringArray2.length);
        int n = 0;
        while (n < stringArray2.length) {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(stringArray2[n].toUpperCase());
            programCallDocument.setValue("qgyrprtl.filterInformation.outputQueue.objectName", new int[]{n}, qSYSObjectPathName.getObjectName());
            programCallDocument.setValue("qgyrprtl.filterInformation.outputQueue.libraryName", new int[]{n++}, qSYSObjectPathName.getLibraryName());
        }
    }

    Resource newResource(String string, int[] nArray) throws PcmlException, ResourceException {
        ProgramCallDocument programCallDocument = this.getDocument();
        String string2 = (String)programCallDocument.getValue(string + deviceNameDataName_, nArray);
        AS400 aS400 = this.getSystem();
        Object object = RPrinter.computeResourceKey(aS400, string2);
        RPrinter rPrinter = (RPrinter)ResourcePool.GLOBAL_RESOURCE_POOL.getResource(object);
        if (rPrinter == null) {
            try {
                rPrinter = new RPrinter(aS400, string2);
                rPrinter.setResourceKey(object);
                rPrinter.freezeProperties();
            }
            catch (Exception exception) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Exception while creating printer from printer list", (Throwable)exception);
                }
                throw new ResourceException(exception);
            }
        }
        try {
            Object[] objectArray = openListAttributeMap_.getIDs(ResourceLevel.vrmToLevel(aS400.getVRM()));
            Object[] objectArray2 = openListAttributeMap_.getValues(objectArray, aS400, programCallDocument, string, nArray);
            for (int i = 0; i < objectArray2.length; ++i) {
                rPrinter.initializeAttributeValue(objectArray[i], objectArray2[i]);
            }
        }
        catch (Exception exception) {
            throw new ResourceException(exception);
        }
        return rPrinter;
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selections_.add(PRINTER_NAMES, String.class, false, null, null, false, true);
            selections_.add(OUTPUT_QUEUES, String.class, false, null, null, false, true);
            openListAttributeMap_ = new ProgramMap();
            BooleanValueMap booleanValueMap = new BooleanValueMap("0", "1");
            openListAttributeMap_.add("DEVICE_NAME", null, "receiverVariable.deviceName");
            openListAttributeMap_.add("TEXT_DESCRIPTION", null, "receiverVariable.textDescription");
            openListAttributeMap_.add("OVERALL_STATUS", null, "receiverVariable.overallStatus");
            openListAttributeMap_.add("DEVICE_STATUS", null, "receiverVariable.deviceStatus");
            openListAttributeMap_.add("OUTPUT_QUEUE", null, "receiverVariable.outputQueue");
            openListAttributeMap_.add("OUTPUT_QUEUE_STATUS", null, "receiverVariable.outputQueueStatus");
            openListAttributeMap_.add("WRITER_STATUS", null, "receiverVariable.writerStatus");
            openListAttributeMap_.add((Object)"WRITER_STARTED", null, "receiverVariable.writerStarted", booleanValueMap);
            openListAttributeMap_.add("FORM_TYPE", null, "receiverVariable.formType");
            openListAttributeMap_.add("SPOOLED_FILE_NAME", null, "receiverVariable.currentFileName");
            openListAttributeMap_.add("USER_NAME", null, "receiverVariable.currentFileUser");
            openListAttributeMap_.add((Object)"PUBLISHED_STATUS", null, "receiverVariable.publishingStatus", booleanValueMap, new ResourceLevel("V5R1M0"));
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)pcmlException);
            }
        }
    }
}

