/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Text;

public class ValidationListTranslatedData {
    private byte[] bytes_ = null;
    private int ccsid_ = 0;

    public ValidationListTranslatedData() {
    }

    public ValidationListTranslatedData(byte[] byArray, int n) {
        this();
        int n2 = new AS400Bin4().toInt(byArray, n + this.getReadOffsetTByteLength());
        this.setCcsid(new AS400Bin4().toInt(byArray, n + this.getReadOffsetCcsid()));
        this.setBytes((byte[])new AS400ByteArray(n2).toObject(byArray, n + this.getReadOffsetTBytes()));
    }

    public ValidationListTranslatedData(int n, byte[] byArray) {
        this();
        this.setCcsid(n);
        this.setBytes(byArray);
    }

    public ValidationListTranslatedData(String string, int n, AS400 aS400) {
        this();
        this.setBytes(string, n, aS400);
    }

    public int getByteLength() {
        int n = this.getWriteOffsetTBytes();
        if (this.getBytes() != null) {
            n += this.getBytes().length;
        }
        return n;
    }

    public byte[] getBytes() {
        return this.bytes_;
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    protected int getReadOffsetCcsid() {
        return 4;
    }

    protected int getReadOffsetTByteLength() {
        return 0;
    }

    protected int getReadOffsetTBytes() {
        return 8;
    }

    public String getString(AS400 aS400) {
        int n = this.getCcsid();
        if (this.bytes_ == null || n == -1) {
            return null;
        }
        if (n == 13488) {
            return new String(this.bytes_);
        }
        if (n == 0) {
            n = aS400.getCcsid();
        }
        return (String)new AS400Text(this.bytes_.length, n, aS400).toObject(this.bytes_);
    }

    protected int getWriteNullDataLength() {
        return 0;
    }

    protected int getWriteOffsetCcsid() {
        return this.getReadOffsetCcsid();
    }

    protected int getWriteOffsetTByteLength() {
        return this.getReadOffsetTByteLength();
    }

    protected int getWriteOffsetTBytes() {
        return this.getReadOffsetTBytes();
    }

    protected boolean isValidCcsid(int n) {
        boolean bl = false;
        switch (n) {
            case 37: 
            case 256: 
            case 273: 
            case 277: 
            case 278: 
            case 280: 
            case 284: 
            case 285: 
            case 290: 
            case 297: 
            case 300: 
            case 420: 
            case 423: 
            case 424: 
            case 500: 
            case 833: 
            case 834: 
            case 835: 
            case 836: 
            case 837: 
            case 838: 
            case 870: 
            case 871: 
            case 875: 
            case 880: 
            case 905: 
            case 918: 
            case 924: 
            case 930: 
            case 933: 
            case 935: 
            case 937: 
            case 939: 
            case 1025: 
            case 1026: 
            case 1027: 
            case 1097: 
            case 1112: 
            case 1122: 
            case 1123: 
            case 1130: 
            case 1132: 
            case 1140: 
            case 1141: 
            case 1142: 
            case 1143: 
            case 1144: 
            case 1145: 
            case 1146: 
            case 1147: 
            case 1148: 
            case 1149: 
            case 1364: 
            case 1388: 
            case 4396: 
            case 4930: 
            case 4933: 
            case 5026: 
            case 5035: 
            case 8612: 
            case 8616: 
            case 9030: 
            case 12708: 
            case 13121: 
            case 13124: 
            case 13488: 
            case 28709: 
            case 62211: 
            case 62224: 
            case 62235: {
                bl = true;
            }
        }
        return bl;
    }

    public void setBytes(byte[] byArray) {
        this.bytes_ = byArray;
    }

    public void setBytes(String string, int n, AS400 aS400) {
        int n2;
        if (n == 0) {
            n = aS400.getCcsid();
        }
        this.setCcsid(n);
        if (n == 13488) {
            this.setBytes(string.getBytes());
            return;
        }
        byte[] byArray = new AS400Text(n2, n, aS400).toBytes(string);
        for (n2 = string.length() * 2; n2 > 0 && byArray[n2 - 1] == 64; --n2) {
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        this.setBytes(byArray2);
    }

    public void setCcsid(int n) {
        this.ccsid_ = n <= 0 || this.isValidCcsid(n) ? n : 37;
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.getByteLength()];
        this.toBytes(byArray, 0);
        return byArray;
    }

    public int toBytes(byte[] byArray, int n) {
        byte[] byArray2 = this.getBytes();
        int n2 = byArray2 == null ? this.getWriteNullDataLength() : byArray2.length;
        new AS400Bin4().toBytes(n2, byArray, n + this.getWriteOffsetTByteLength());
        new AS400Bin4().toBytes(this.getCcsid(), byArray, n + this.getWriteOffsetCcsid());
        if (n2 > 0) {
            System.arraycopy(byArray2, 0, byArray, n + this.getWriteOffsetTBytes(), n2);
        }
        return this.getByteLength();
    }
}

