/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCPreparedStatementImpl;
import com.ibm.as400.access.AS400JDBCStatementLock;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class AS400JDBCCallableStatement
extends AS400JDBCPreparedStatementImpl
implements CallableStatement {
    static final int NO_VALIDATION_ = -9999;
    private int[] registeredTypes_ = new int[this.parameterCount_];
    private boolean[] registered_ = new boolean[this.parameterCount_];
    private boolean returnValueParameterRegistered_;
    private boolean wasNull_;
    private boolean wasDataMappingError_;
    private int maxToLog_ = 10000;
    private Object byteArrayClass_;

    AS400JDBCCallableStatement(AS400JDBCConnection aS400JDBCConnection, int n, JDTransactionManager jDTransactionManager, JDPackageManager jDPackageManager, String string, int n2, JDSQLStatement jDSQLStatement, String string2, int n3, int n4, int n5, int n6) throws SQLException {
        super(aS400JDBCConnection, n, jDTransactionManager, jDPackageManager, string, n2, false, jDSQLStatement, true, string2, n3, n4, n5, n6);
        for (int i = 0; i < this.parameterCount_; ++i) {
            this.registered_[i] = false;
        }
        this.returnValueParameterRegistered_ = false;
        this.wasNull_ = false;
        this.wasDataMappingError_ = false;
    }

    void commonExecuteBefore(JDSQLStatement jDSQLStatement, DBSQLRequestDS dBSQLRequestDS) throws SQLException {
        for (int i = 0; i < this.parameterCount_; ++i) {
            if (this.registered_[i] || !this.parameterRow_.isOutput(i + 1)) continue;
            JDError.throwSQLException((Object)this, "07001");
        }
        super.commonExecuteBefore(jDSQLStatement, dBSQLRequestDS);
    }

    void validateParameterIndex(int n) throws SQLException {
        if (n < 1) {
            JDError.throwSQLException((Object)this, "07009", n + "<1");
        }
        if (n > this.parameterCount_) {
            JDError.throwSQLException((Object)this, "07009", n + ">" + this.parameterCount_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[n - 1]) {
                    case 2000: 
                    case 2003: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                }
                sQLData = this.getValue(n);
            }
            Array array = sQLData == null ? null : sQLData.getArray();
            this.testDataTruncation(n, sQLData, true);
            return array;
        }
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (this.registeredTypes_[n - 1] == -1) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            BigDecimal bigDecimal = sQLData == null ? null : sQLData.getBigDecimal(-1);
            this.testDataTruncation(n, sQLData, true);
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (n2 < 0) {
            JDError.throwSQLException((Object)this, "HY094", "" + n2);
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            BigDecimal bigDecimal = sQLData == null ? null : sQLData.getBigDecimal(n2);
            this.testDataTruncation(n, sQLData, true);
            return bigDecimal;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[n - 1]) {
                    case 2000: 
                    case 2004: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                }
                sQLData = this.getValue(n);
            }
            Blob blob = sQLData == null ? null : sQLData.getBlob();
            this.testDataTruncation(n, sQLData, false);
            return blob;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            boolean bl = sQLData == null ? false : sQLData.getBoolean();
            this.testDataTruncation(n, sQLData, true);
            return bl;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            byte by = sQLData == null ? (byte)0 : sQLData.getByte();
            this.testDataTruncation(n, sQLData, true);
            return by;
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.getValue(n);
            }
            byte[] byArray = sQLData == null ? null : sQLData.getBytes();
            this.testDataTruncation(n, sQLData, false);
            return byArray;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[n - 1]) {
                    case 2000: 
                    case 2005: 
                    case 2011: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                }
                sQLData = this.getValue(n);
            }
            Clob clob = sQLData == null ? null : sQLData.getClob();
            this.testDataTruncation(n, sQLData, false);
            return clob;
        }
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findParameterIndex(string));
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(n, AS400Calendar.getGregorianInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[n - 1]) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: 
                    case 2000: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                }
                sQLData = this.getValue(n);
            }
            Date date = sQLData == null ? null : sQLData.getDate(calendar);
            this.testDataTruncation(n, sQLData, false);
            return date;
        }
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findParameterIndex(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findParameterIndex(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            double d = sQLData == null ? 0.0 : sQLData.getDouble();
            this.testDataTruncation(n, sQLData, true);
            return d;
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            float f = sQLData == null ? 0.0f : sQLData.getFloat();
            this.testDataTruncation(n, sQLData, true);
            return f;
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            int n2 = sQLData == null ? 0 : sQLData.getInt();
            this.testDataTruncation(n, sQLData, true);
            return n2;
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            long l = sQLData == null ? 0L : sQLData.getLong();
            this.testDataTruncation(n, sQLData, true);
            return l;
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.getValue(n);
            }
            if (sQLData == null) {
                return null;
            }
            Object object = sQLData == null ? null : sQLData.getObject();
            this.testDataTruncation(n, sQLData, false);
            return object;
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (map == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        return this.getObject(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findParameterIndex(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findParameterIndex(string));
    }

    public Ref getRef(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[n - 1], n);
                sQLData = this.getValue(n);
            }
            short s = sQLData == null ? (short)0 : sQLData.getShort();
            this.testDataTruncation(n, sQLData, true);
            return s;
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.getValue(n);
            }
            String string = sQLData == null ? null : sQLData.getString();
            this.testDataTruncation(n, sQLData, false);
            return string;
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findParameterIndex(string));
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, AS400Calendar.getGregorianInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[n - 1]) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 92: 
                    case 93: 
                    case 2000: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                }
                sQLData = this.getValue(n);
            }
            Time time = sQLData == null ? null : sQLData.getTime(calendar);
            this.testDataTruncation(n, sQLData, false);
            return time;
        }
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findParameterIndex(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findParameterIndex(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, AS400Calendar.getGregorianInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[n - 1]) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2000: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                }
                sQLData = this.getValue(n);
            }
            Timestamp timestamp = sQLData == null ? null : sQLData.getTimestamp(calendar);
            this.testDataTruncation(n, sQLData, false);
            return timestamp;
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[n - 1]) {
                    case 1: 
                    case 12: 
                    case 70: 
                    case 2000: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                }
                sQLData = this.getValue(n);
            }
            String string = sQLData == null ? null : sQLData.getString();
            this.testDataTruncation(n, sQLData, false);
            if (string != null) {
                try {
                    return new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    JDError.throwSQLException((Object)this, "07006", malformedURLException);
                    return null;
                }
            }
            return null;
        }
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findParameterIndex(string));
    }

    private SQLData getValue(int n) throws SQLException {
        if (!this.executed_) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        SQLData sQLData = this.parameterRow_.getSQLData(n);
        this.wasNull_ = this.parameterRow_.isNull(n);
        this.wasDataMappingError_ = this.parameterRow_.isDataMappingError(n);
        return this.wasNull_ ? null : sQLData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    if (n2 != 4) {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                    this.returnValueParameterRegistered_ = true;
                    return;
                }
                --n;
            }
            this.validateParameterIndex(n);
            if (n3 < 0) {
                JDError.throwSQLException((Object)this, "HY094");
            }
            if (!this.parameterRow_.isOutput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            this.registeredTypes_[n - 1] = n2;
            this.registered_[n - 1] = true;
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n, 0);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n, n2);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n, 0);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + n);
            }
        }
        this.setAsciiStream(this.findParameterIndex(string), inputStream, n);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBigDecimal()");
            if (bigDecimal == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + bigDecimal.toString());
            }
        }
        this.setBigDecimal(this.findParameterIndex(string), bigDecimal);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + n);
            }
        }
        this.setBinaryStream(this.findParameterIndex(string), inputStream, n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBoolean()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + bl);
        }
        this.setBoolean(this.findParameterIndex(string), bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setByte()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + by);
        }
        this.setByte(this.findParameterIndex(string), by);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBytes()");
            if (byArray == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Trace.printByteArray(stringBuffer, byArray);
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + stringBuffer.toString());
            }
        }
        this.setBytes(this.findParameterIndex(string), byArray);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + n);
            }
        }
        this.setCharacterStream(this.findParameterIndex(string), reader, n);
    }

    public void setDate(String string, Date date) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (date == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + date.toString());
            }
        }
        this.setDate(this.findParameterIndex(string), date);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (date == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + date.toString());
            }
        }
        this.setDate(this.findParameterIndex(string), date, calendar);
    }

    public void setDouble(String string, double d) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDouble()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + d);
        }
        this.setDouble(this.findParameterIndex(string), d);
    }

    public void setFloat(String string, float f) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFloat()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + f);
        }
        this.setFloat(this.findParameterIndex(string), f);
    }

    public void setInt(String string, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setInt()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + n);
        }
        this.setInt(this.findParameterIndex(string), n);
    }

    public void setLong(String string, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setLong()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + l);
        }
        this.setLong(this.findParameterIndex(string), l);
    }

    public void setNull(String string, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
        }
        this.setNull(this.findParameterIndex(string), n);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
        }
        this.setNull(this.findParameterIndex(string), n, string2);
    }

    public void setObject(String string, Object object) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " type: " + object.getClass().getName());
            }
        }
        this.setObject(this.findParameterIndex(string), object);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " type: " + object.getClass().getName());
            }
        }
        this.setObject(this.findParameterIndex(string), object, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " type: " + object.getClass().getName());
            }
        }
        this.setObject(this.findParameterIndex(string), object, n, n2);
    }

    public void setShort(String string, short s) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setShort()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + s);
        }
        this.setShort(this.findParameterIndex(string), s);
    }

    public void setString(String string, String string2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setString()");
            if (string2 == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else if (string2.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + string2.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + string2);
            }
        }
        this.setString(this.findParameterIndex(string), string2);
    }

    public void setTime(String string, Time time) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (time == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + time.toString());
            }
        }
        this.setTime(this.findParameterIndex(string), time);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (time == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + time.toString());
            }
        }
        this.setTime(this.findParameterIndex(string), time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (timestamp == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + timestamp.toString());
            }
        }
        this.setTimestamp(this.findParameterIndex(string), timestamp);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (timestamp == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + timestamp.toString());
            }
        }
        this.setTimestamp(this.findParameterIndex(string), timestamp, calendar);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setURL()");
            if (uRL == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + uRL.toString());
            }
        }
        this.setURL(this.findParameterIndex(string), uRL);
    }

    private void testDataTruncation(int n, SQLData sQLData, boolean bl) throws SQLException {
        int n2;
        if (this.wasDataMappingError_) {
            this.postWarning(new DataTruncation(n, true, true, -1, -1));
        }
        if (sQLData != null && (n2 = sQLData.getTruncated()) > 0) {
            if (bl && sQLData.getOutOfBounds()) {
                JDError.throwSQLException((Object)this, "07006", "P#=" + n);
            }
            int n3 = sQLData.getActualSize();
            this.postWarning(new DataTruncation(n, true, true, n3, n3 - n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.wasNull_;
        }
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCCallableStatement", "java.sql.CallableStatement"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.getValue(n);
            }
            Reader reader = sQLData == null ? null : sQLData.getCharacterStream();
            this.testDataTruncation(n, sQLData, false);
            return reader;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getNCharacterStream(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.getValue(n);
            }
            Reader reader = sQLData == null ? null : sQLData.getNCharacterStream();
            this.testDataTruncation(n, sQLData, false);
            return reader;
        }
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NClob getNClob(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[n - 1]) {
                    case 2000: 
                    case 2005: 
                    case 2011: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + n);
                    }
                }
                sQLData = this.getValue(n);
            }
            NClob nClob = sQLData == null ? null : sQLData.getNClob();
            this.testDataTruncation(n, sQLData, false);
            return nClob;
        }
    }

    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNString(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.getValue(n);
            }
            String string = sQLData == null ? null : sQLData.getNString();
            this.testDataTruncation(n, sQLData, false);
            return string;
        }
    }

    public String getNString(String string) throws SQLException {
        return this.getNString(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowId getRowId(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.getValue(n);
            }
            RowId rowId = sQLData == null ? null : sQLData.getRowId();
            this.testDataTruncation(n, sQLData, false);
            return rowId;
        }
    }

    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findParameterIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLXML getSQLXML(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData sQLData = null;
            if (this.useReturnValueParameter_ && n == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --n;
                }
                this.validateParameterIndex(n);
                if (!this.parameterRow_.isOutput(n)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[n - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                sQLData = this.getValue(n);
            }
            SQLXML sQLXML = sQLData == null ? null : sQLData.getSQLXML();
            this.testDataTruncation(n, sQLData, false);
            return sQLXML;
        }
    }

    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findParameterIndex(string));
    }

    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + l);
            }
        }
        this.setAsciiStream(this.findParameterIndex(string), inputStream, l);
    }

    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + l);
            }
        }
        this.setBinaryStream(this.findParameterIndex(string), inputStream, l);
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (blob == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + blob.length());
            }
        }
        this.setBlob(this.findParameterIndex(string), blob);
    }

    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + l);
            }
        }
        this.setBlob(this.findParameterIndex(string), inputStream, l);
    }

    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + l);
            }
        }
        this.setCharacterStream(this.findParameterIndex(string), reader, l);
    }

    public void setClob(String string, Clob clob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (clob == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + clob.length());
            }
        }
        this.setClob(this.findParameterIndex(string), clob);
    }

    public void setClob(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + l);
            }
        }
        this.setClob(this.findParameterIndex(string), reader, l);
    }

    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNCharacterStream()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + l);
            }
        }
        this.setNCharacterStream(this.findParameterIndex(string), reader, l);
    }

    public void setNClob(String string, NClob nClob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob()");
            if (nClob == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + nClob.length());
            }
        }
        this.setNClob(this.findParameterIndex(string), nClob);
    }

    public void setNClob(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + l);
            }
        }
        this.setNClob(this.findParameterIndex(string), reader, l);
    }

    public void setNString(String string, String string2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNString()");
            if (string2 == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else if (string2.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + string2.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + string2);
            }
        }
        this.setNString(this.findParameterIndex(string), string2);
    }

    public void setRowId(String string, RowId rowId) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setRowId()");
            if (rowId == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: " + rowId.toString());
            }
        }
        this.setRowId(this.findParameterIndex(string), rowId);
    }

    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (sQLXML == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " length: " + sQLXML.toString().length());
            }
        }
        this.setSQLXML(this.findParameterIndex(string), sQLXML);
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream(String, InputStream)");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            }
        }
        this.setAsciiStream(this.findParameterIndex(string), inputStream);
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream(String, InputStream)");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            }
        }
        this.setBinaryStream(this.findParameterIndex(string), inputStream);
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob(String, InputStream)");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            }
        }
        this.setBlob(this.findParameterIndex(string), inputStream);
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream(String, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            }
        }
        this.setCharacterStream(this.findParameterIndex(string), reader);
    }

    public void setClob(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob(String, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            }
        }
        this.setClob(this.findParameterIndex(string), reader);
    }

    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNCharacterStream(String, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            }
        }
        this.setNCharacterStream(this.findParameterIndex(string), reader);
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob(String, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(string) + " value: NULL");
            }
        }
        this.setNClob(this.findParameterIndex(string), reader);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        Object object;
        if (clazz == null) {
            JDError.throwSQLException("HY105");
        }
        if (this.byteArrayClass_ == null) {
            object = new byte[1];
            this.byteArrayClass_ = object.getClass();
        }
        if (clazz == String.class) {
            return this.getString(n);
        }
        if (clazz == Byte.class) {
            byte by = this.getByte(n);
            if (by == 0 && this.wasNull()) {
                return null;
            }
            return new Byte(by);
        }
        if (clazz == Short.class) {
            short s = this.getShort(n);
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return new Short(s);
        }
        if (clazz == Integer.class) {
            int n2 = this.getInt(n);
            if (n2 == 0 && this.wasNull()) {
                return null;
            }
            return new Integer(n2);
        }
        if (clazz == Long.class) {
            long l = this.getLong(n);
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return new Long(l);
        }
        if (clazz == Float.class) {
            float f = this.getFloat(n);
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return new Float(f);
        }
        if (clazz == Double.class) {
            double d = this.getDouble(n);
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return new Double(d);
        }
        if (clazz == BigDecimal.class) {
            return this.getBigDecimal(n);
        }
        if (clazz == Boolean.class) {
            boolean bl = this.getBoolean(n);
            if (!bl && this.wasNull()) {
                return null;
            }
            return new Boolean(bl);
        }
        if (clazz == Date.class) {
            return this.getDate(n);
        }
        if (clazz == Time.class) {
            return this.getTime(n);
        }
        if (clazz == Timestamp.class) {
            return this.getTimestamp(n);
        }
        if (clazz == this.byteArrayClass_) {
            return this.getBytes(n);
        }
        if (clazz == InputStream.class) {
            object = this.getBlob(n);
            if (object == null) {
                return object;
            }
            return object.getBinaryStream();
        }
        if (clazz == Reader.class) {
            return this.getCharacterStream(n);
        }
        if (clazz == Clob.class) {
            return this.getClob(n);
        }
        if (clazz == Blob.class) {
            return this.getBlob(n);
        }
        if (clazz == Array.class) {
            return this.getArray(n);
        }
        if (clazz == Ref.class) {
            return this.getRef(n);
        }
        if (clazz == URL.class) {
            return this.getURL(n);
        }
        if (clazz == NClob.class) {
            return this.getNClob(n);
        }
        if (clazz == RowId.class) {
            return this.getRowId(n);
        }
        if (clazz == SQLXML.class) {
            return this.getSQLXML(n);
        }
        if (clazz == Object.class) {
            return this.getObject(n);
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    public Object getObject(String string, Class clazz) throws SQLException {
        return this.getObject(this.findParameterIndex(string), clazz);
    }

    private void validateNumericRegisteredType(int n, int n2) throws SQLException {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 1111: 
            case 2000: {
                break;
            }
            default: {
                JDError.throwSQLException((Object)this, "07006", "P#=" + n2);
            }
        }
    }

    static int mapSQLTypeCS(SQLType sQLType) throws SQLException {
        if (sQLType instanceof JDBCType) {
            return sQLType.getVendorTypeNumber();
        }
        throw new SQLFeatureNotSupportedException("targetSqlType=" + sQLType);
    }

    public void setObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        int n2 = AS400JDBCCallableStatement.mapSQLTypeCS(sQLType);
        this.setObject(string, object, n2, n);
    }

    public void setObject(String string, Object object, SQLType sQLType) throws SQLException {
        int n = AS400JDBCCallableStatement.mapSQLTypeCS(sQLType);
        this.setObject(string, object, n);
    }

    public void registerOutParameter(int n, SQLType sQLType) throws SQLException {
        int n2 = AS400JDBCCallableStatement.mapSQLTypeCS(sQLType);
        this.registerOutParameter(n, n2);
    }

    public void registerOutParameter(int n, SQLType sQLType, int n2) throws SQLException {
        int n3 = AS400JDBCCallableStatement.mapSQLTypeCS(sQLType);
        this.registerOutParameter(n, n3, n2);
    }

    public void registerOutParameter(int n, SQLType sQLType, String string) throws SQLException {
        int n2 = AS400JDBCCallableStatement.mapSQLTypeCS(sQLType);
        this.registerOutParameter(n, n2, string);
    }

    public void registerOutParameter(String string, SQLType sQLType) throws SQLException {
        int n = AS400JDBCCallableStatement.mapSQLTypeCS(sQLType);
        this.registerOutParameter(string, n);
    }

    public void registerOutParameter(String string, SQLType sQLType, int n) throws SQLException {
        int n2 = AS400JDBCCallableStatement.mapSQLTypeCS(sQLType);
        this.registerOutParameter(string, n2, n);
    }

    public void registerOutParameter(String string, SQLType sQLType, String string2) throws SQLException {
        int n = AS400JDBCCallableStatement.mapSQLTypeCS(sQLType);
        this.registerOutParameter(string, n, string2);
    }
}

