/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.validator;

import java.util.ArrayList;
import java.util.List;
import miworkplace.i18n.Messages;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;

public class ObjectPathValidator
implements IInputValidator {
    private List<String> names = new ArrayList<String>();

    public ObjectPathValidator() {
    }

    public ObjectPathValidator(List<String> names) {
        this.names.addAll(names);
    }

    public String isValid(String newText) {
        String errorMessage = null;
        String[] parts = newText.split("/");
        int countMatches = StringUtils.countMatches((CharSequence)newText, (CharSequence)"/");
        if (countMatches > 1) {
            return Messages.object_path_val_syntax;
        }
        if (parts.length == 1) {
            errorMessage = this.validateName(parts[0]);
        } else {
            errorMessage = this.validateLibrary(parts[0]);
            if (errorMessage != null) {
                errorMessage = this.validateName(parts[1]);
            }
        }
        return errorMessage;
    }

    private String validateName(String newText) {
        String errorMessage = null;
        if (newText.length() == 0) {
            errorMessage = Messages.object_path_val_name_empty;
        } else if (newText.length() > 10) {
            errorMessage = Messages.object_path_val_name_chars;
        } else if (!newText.substring(0, 1).matches("[a-zA-Z]")) {
            errorMessage = Messages.object_path_val_name_start;
        } else if (this.names.contains(newText)) {
            errorMessage = Messages.object_path_val_name_exists;
        }
        return errorMessage;
    }

    private String validateLibrary(String newText) {
        String errorMessage = null;
        if (newText.length() == 0) {
            errorMessage = Messages.object_path_val_lib_empty;
        } else if (newText.length() > 10) {
            errorMessage = Messages.object_path_val_lib_chars;
        } else if (!newText.substring(0, 1).matches("[a-zA-Z]")) {
            errorMessage = Messages.object_path_val_lib_start;
        }
        return errorMessage;
    }
}

