/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.validator;

import java.util.ArrayList;
import java.util.List;
import miworkplace.i18n.Messages;
import org.eclipse.jface.dialogs.IInputValidator;

public class ObjectNameValidator
implements IInputValidator {
    private List<String> names = new ArrayList<String>();

    public ObjectNameValidator() {
    }

    public ObjectNameValidator(List<String> names) {
        this.names.addAll(names);
    }

    public String isValid(String newText) {
        String errorMessage = null;
        if (newText.length() == 0) {
            errorMessage = Messages.object_name_val_empty;
        } else if (newText.length() > 10) {
            errorMessage = Messages.object_name_val_length;
        } else if (!newText.substring(0, 1).matches("[a-zA-Z]")) {
            errorMessage = Messages.object_name_val_start;
        } else if (this.names.contains(newText)) {
            errorMessage = Messages.object_name_val_exists;
        }
        return errorMessage;
    }
}

