/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.ui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class SWTFontUtils {
    private static final Map<Device, Font> MONOSPACED_FONTS = new HashMap<Device, Font>();

    private SWTFontUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getMonospacedFont() {
        Map<Device, Font> map = MONOSPACED_FONTS;
        synchronized (map) {
            Display display = Display.getCurrent();
            if (display == null) {
                String msg = "Must be invoked for a SWT UI thread.";
                throw new IllegalStateException(msg);
            }
            return SWTFontUtils.getMonospacedFont(display);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getMonospacedFont(final Display display) {
        Map<Device, Font> map = MONOSPACED_FONTS;
        synchronized (map) {
            Font cachedFont = MONOSPACED_FONTS.get(display);
            if (cachedFont != null) {
                return cachedFont;
            }
            String os = System.getProperty("os.name");
            String ws = SWT.getPlatform();
            os = StringUtils.deleteWhitespace((String)os).toLowerCase(Locale.US);
            ws = StringUtils.deleteWhitespace((String)ws).toLowerCase(Locale.US);
            String[] names = new String[]{os + "_" + ws, os, ""};
            String[] fontDataTxts = null;
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals("aix")) {
                    fontDataTxts = new String[]{"adobe-courier|normal|12"};
                    break;
                }
                if (name.equals("hp-ux")) {
                    fontDataTxts = new String[]{"adobe-courier|normal|14"};
                    break;
                }
                if (name.equals("linux_gtk")) {
                    fontDataTxts = new String[]{"Monospace|normal|10"};
                    break;
                }
                if (name.equals("linux")) {
                    fontDataTxts = new String[]{"adobe-courier|normal|12"};
                    break;
                }
                if (name.equals("macosx")) {
                    fontDataTxts = new String[]{"Monaco|normal|11", "Courier|normal|12", "Courier New|normal|12"};
                    break;
                }
                if (name.equals("sunos") || name.equals("solaris")) {
                    fontDataTxts = new String[]{"adobe-courier|normal|12"};
                    break;
                }
                if (name.equals("windows98")) {
                    fontDataTxts = new String[]{"Courier New|normal|10", "Courier|normal|10", "Lucida Console|normal|9"};
                    break;
                }
                if (name.equals("windowsnt")) {
                    fontDataTxts = new String[]{"Courier New|normal|10", "Courier|normal|10", "Lucida Console|normal|9"};
                    break;
                }
                if (name.equals("windows2000")) {
                    fontDataTxts = new String[]{"Courier New|normal|10", "Courier|normal|10", "Lucida Console|normal|9"};
                    break;
                }
                if (name.equals("windowsxp")) {
                    fontDataTxts = new String[]{"Courier New|normal|10", "Courier|normal|10", "Lucida Console|normal|9"};
                    break;
                }
                if (name.equals("windowsvista")) {
                    fontDataTxts = new String[]{"Consolas|normal|10", "Courier New|normal|10"};
                    break;
                }
                if (name.equals("windows7")) {
                    fontDataTxts = new String[]{"Consolas|normal|10", "Courier New|normal|10"};
                    break;
                }
                if (name.equals("windows8")) {
                    fontDataTxts = new String[]{"Consolas|normal|10", "Courier New|normal|10"};
                    break;
                }
                if (name.equals("")) {
                    fontDataTxts = new String[]{"Courier New|normal|10", "Courier|normal|10", "b&h-lucidabright|normal|9"};
                    break;
                }
                ++n2;
            }
            if (fontDataTxts == null) {
                throw new AssertionError();
            }
            FontData[] fontDatas = new FontData[fontDataTxts.length];
            int i = 0;
            while (i < fontDatas.length) {
                String txt = fontDataTxts[i];
                int bar2 = txt.lastIndexOf(124);
                int bar1 = txt.lastIndexOf(124, bar2 - 1);
                String name = txt.substring(0, bar1);
                String[] styles = txt.substring(bar1 + 1, bar2).split(",");
                int style = 0;
                String[] stringArray2 = styles;
                int n3 = styles.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray2[n4];
                    if (s.equals("normal")) {
                        style |= 0;
                    } else if (s.equals("bold")) {
                        style |= 1;
                    } else if (s.equals("italic")) {
                        style |= 2;
                    } else {
                        throw new RuntimeException("Invalid style: " + s);
                    }
                    ++n4;
                }
                int height = Integer.parseInt(txt.substring(bar2 + 1));
                fontDatas[i] = new FontData(name, height, style);
                ++i;
            }
            final Font font = new Font((Device)display, fontDatas);
            display.disposeExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map<Device, Font> map = MONOSPACED_FONTS;
                    synchronized (map) {
                        MONOSPACED_FONTS.remove(display);
                        font.dispose();
                    }
                }
            });
            MONOSPACED_FONTS.put((Device)display, font);
            return font;
        }
    }
}

