/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.ui;

import java.awt.MouseInfo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MiniMessage {
    private StyledText fStyledText;
    private Shell fShell;
    private int fWaitBeforeFade = 0;
    private Control fControl;

    private MiniMessage(int waitBeforeFade) {
        this.fWaitBeforeFade = waitBeforeFade;
    }

    public static MiniMessage get(int pWaitBeforeFade) {
        return new MiniMessage(pWaitBeforeFade);
    }

    public MiniMessage above(Control pControl) {
        this.fControl = pControl;
        return this;
    }

    public void openWait(String message) {
        this.doOpen(message, true);
    }

    public void submit(String text) {
        Runnable runner = () -> this.doOpen(text, false);
        Display.getDefault().asyncExec(runner);
    }

    public void open(String text) {
        this.doOpen(text, false);
    }

    private void doOpen(String text, boolean wait) {
        try {
            Display display = Display.getDefault();
            this.fShell = new Shell(display, 540680);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 1;
            gridLayout.marginHeight = 1;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            this.createContents((Composite)this.fShell, 0);
            this.setText(text);
            Control focusControl = display.getFocusControl();
            this.fShell.setLayout((Layout)gridLayout);
            this.fShell.pack();
            this.fShell.setLocation(this.getLocation());
            this.fShell.open();
            this.fShell.layout();
            if (focusControl != null) {
                focusControl.forceFocus();
            }
            Thread thread = new Thread(new Fader(this.fWaitBeforeFade));
            thread.run();
            while (wait && !this.fShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Point getLocation() {
        if (this.fControl == null || this.fControl.isDisposed() || this.fControl.getParent() == null) {
            return new Point(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y - this.fShell.getSize().y);
        }
        return this.fControl.getParent().toDisplay(this.fControl.getLocation().x + this.fControl.getSize().x / 2 - this.fShell.getSize().x / 2, this.fControl.getLocation().y - this.fControl.getSize().y - 10);
    }

    private void setText(String string) {
        this.fStyledText.setText(string);
    }

    private void createContents(Composite parent, int style) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 9;
        gridLayout.marginHeight = 9;
        parent.setLayout((Layout)gridLayout);
        this.fStyledText = new StyledText(parent, 2048);
        this.fStyledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.fStyledText.setEditable(false);
        this.fStyledText.setEnabled(false);
        this.fStyledText.setBackground(parent.getDisplay().getSystemColor(6));
        this.fStyledText.setForeground(parent.getDisplay().getSystemColor(1));
    }

    private class Fader
    implements Runnable {
        int fAlpha = 255;
        private int fTimerWait = 10;
        private int fWaitBeforeFade = 0;

        public Fader(int waitBeforeFade) {
            this.fWaitBeforeFade = waitBeforeFade;
        }

        @Override
        public void run() {
            if (this.fWaitBeforeFade > 0) {
                MiniMessage.this.fShell.getDisplay().timerExec(this.fWaitBeforeFade, (Runnable)this);
                this.fWaitBeforeFade = 0;
            } else if (this.fAlpha <= 5) {
                MiniMessage.this.fShell.dispose();
            } else {
                this.fAlpha -= 5;
                if (this.fAlpha < 255) {
                    MiniMessage.this.fShell.setAlpha(this.fAlpha);
                }
                MiniMessage.this.fShell.getDisplay().timerExec(this.fTimerWait, (Runnable)this);
            }
        }
    }
}

