/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.text;

public class RpgSyntaxTypeChecker {
    public static boolean isFullFree(String code) {
        String[] lines;
        if (code == null) {
            return false;
        }
        if (code.length() < 6) {
            return false;
        }
        if (code.substring(0, 6).equalsIgnoreCase("**FREE")) {
            return true;
        }
        String[] stringArray = lines = code.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (RpgSyntaxTypeChecker.isFreeControlStatement(line) || RpgSyntaxTypeChecker.isFreeDeclareStatement(line)) {
                return true;
            }
            if (RpgSyntaxTypeChecker.isFixedHeaderSpecification(line) || RpgSyntaxTypeChecker.isFixedFileSpecification(line)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isFreeControlStatement(String line) {
        return line.trim().toLowerCase().startsWith("ctl-opt");
    }

    private static boolean isFreeDeclareStatement(String line) {
        return line.trim().toLowerCase().startsWith("dcl-");
    }

    private static boolean isFixedHeaderSpecification(String line) {
        return line.length() > 6 && line.substring(5, 6).equalsIgnoreCase("H") && !line.substring(6, 7).equals("*");
    }

    private static boolean isFixedFileSpecification(String line) {
        return line.length() > 16 && line.substring(5, 6).equalsIgnoreCase("F") && !line.substring(6, 7).equals("*") && "IOUC".contains(line.substring(16, 17));
    }
}

