/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.i18n.check;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;

public class ResourcesCheck {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Parameters: miworkplace.properties , resources-in-code.txt");
            return;
        }
        Properties miwResources = new Properties();
        miwResources.load(new FileReader(args[0]));
        int missingCount = 0;
        List<String> usedPropertyNames = ResourcesCheck.extractUsedPropertyNames(args[1]);
        for (String propertyName : usedPropertyNames) {
            if (miwResources.containsKey(propertyName)) continue;
            System.err.println("Missing property: " + propertyName);
            ++missingCount;
        }
        if (missingCount == 0) {
            System.out.println("all properties found");
        } else {
            System.out.println(missingCount + " properties not found");
        }
    }

    private static List<String> extractUsedPropertyNames(String filename) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        try (Scanner scanner = new Scanner(new File(filename));){
            try {
                String line;
                while ((line = scanner.nextLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    String[] values = line.split(" |\t", 2);
                    if (values.length != 2) {
                        System.err.println("No code in line " + line);
                        continue;
                    }
                    String value = values[1];
                    int x = value.indexOf("Resources.instance().get(");
                    if (x == -1) {
                        System.err.println("No Resources.instance in value " + value);
                        continue;
                    }
                    if (value.length() > 26 + x) {
                        value = value.substring(x + 26, value.indexOf("\"", x + 26));
                        names.add(value);
                        continue;
                    }
                    System.err.println("Error in line " + line);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                scanner.close();
            }
        }
        return names;
    }
}

