/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import miworkplace.ui.editor.cl.ast.AbstractToken;
import miworkplace.ui.editor.cl.ast.Statement;

public class Preprocessor {
    public List<Statement> process(List<AbstractToken> tokens) {
        LinkedList<Statement> statements = new LinkedList<Statement>();
        if (tokens.isEmpty()) {
            return statements;
        }
        AtomicInteger line = new AtomicInteger(tokens.get((int)0).line);
        Statement statement = new Statement();
        for (AbstractToken token : tokens) {
            if (line.get() != token.line) {
                if (!statement.list().isEmpty() && this.isContinuationChar(statement.list().get((int)(statement.size() - 1)).value)) {
                    line.set(token.line);
                } else {
                    statements.add(statement);
                    statement = new Statement();
                    line.set(token.line);
                }
            }
            statement.add(token);
        }
        statements.add(statement);
        return statements;
    }

    private boolean isContinuationChar(String value) {
        if ("+".equals(value)) {
            return true;
        }
        return "-".equals(value);
    }
}

