/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.ast;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import miworkplace.ui.editor.cl.ast.AbstractToken;
import miworkplace.ui.editor.cl.ast.Ast;
import miworkplace.ui.editor.cl.ast.Comment;
import miworkplace.ui.editor.cl.ast.File;
import miworkplace.ui.editor.cl.ast.Label;
import miworkplace.ui.editor.cl.ast.Parameter;
import miworkplace.ui.editor.cl.ast.Preprocessor;
import miworkplace.ui.editor.cl.ast.Statement;
import miworkplace.ui.editor.cl.ast.Subroutine;
import miworkplace.ui.editor.cl.ast.Tokenizer;
import miworkplace.ui.editor.cl.ast.Variable;

public class Parser {
    private Tokenizer tokenizer = new Tokenizer();
    private Preprocessor preprocessor = new Preprocessor();

    public Ast parse(String text) throws Exception {
        List<AbstractToken> tokens = this.tokenizer.tokenize(text);
        List<Statement> statements = this.preprocessor.process(tokens);
        Ast ast = this.process(statements);
        ast.setTokens(tokens);
        return ast;
    }

    private Ast process(List<Statement> statements) {
        Ast ast = new Ast();
        Subroutine subroutine = null;
        for (Statement st : statements) {
            if (subroutine == null && this.isSubroutineStart(st)) {
                subroutine = new Subroutine();
                AbstractToken nameToken = this.parseSubroutineName(st);
                subroutine.setNameToken(nameToken);
                ast.addSubroutine(subroutine);
            }
            this.parseStatement(st, ast);
            if (subroutine == null) continue;
            subroutine.addStatement(st);
            if (!this.isSubroutineEnd(st)) continue;
            subroutine = null;
        }
        return ast;
    }

    private AbstractToken parseSubroutineName(Statement st) {
        Iterator<AbstractToken> iterator = st.list().iterator();
        while (iterator.hasNext()) {
            AbstractToken token = iterator.next();
            if ("/*".equals(token.value)) {
                this.skipComment(iterator);
                continue;
            }
            if (!"SUBR".equalsIgnoreCase(token.value)) continue;
            try {
                token = iterator.next();
                if ("SUBR".equalsIgnoreCase(token.value)) {
                    token = iterator.next();
                    if (!"(".equalsIgnoreCase(token.value)) continue;
                    return iterator.next();
                }
                return token;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        return null;
    }

    private boolean isSubroutineStart(Statement st) {
        Iterator<AbstractToken> iterator = st.list().iterator();
        while (iterator.hasNext()) {
            AbstractToken token = iterator.next();
            if ("/*".equals(token.value)) {
                this.skipComment(iterator);
                continue;
            }
            if ("//".equals(token.value) || "?".equals(token.value) || token.value.equals(":")) continue;
            return "SUBR".equalsIgnoreCase(token.value);
        }
        return false;
    }

    private boolean isSubroutineEnd(Statement st) {
        Iterator<AbstractToken> iterator = st.list().iterator();
        while (iterator.hasNext()) {
            AbstractToken token = iterator.next();
            if ("/*".equals(token.value)) {
                this.skipComment(iterator);
                continue;
            }
            if ("//".equals(token.value) || "?".equals(token.value) || token.value.equals(":")) continue;
            return "ENDSUBR".equalsIgnoreCase(token.value);
        }
        return false;
    }

    private void parseStatement(Statement st, Ast ast) {
        ListIterator<AbstractToken> iterator = st.list().listIterator();
        while (iterator.hasNext()) {
            AbstractToken token = iterator.next();
            if ("//".equals(token.value) || "?".equals(token.value)) continue;
            if (token.value.equals(":")) {
                token = iterator.previous();
                if (iterator.hasPrevious()) {
                    token = iterator.previous();
                    ast.addLabel(new Label(token));
                    token = iterator.next();
                }
                token = iterator.next();
                continue;
            }
            if ("PGM".equalsIgnoreCase(token.value) && iterator.previousIndex() == 0) {
                this.parseParameters(st, ast);
                break;
            }
            if ("ENDPGM".equalsIgnoreCase(token.value)) continue;
            if ("DCL".equalsIgnoreCase(token.value)) {
                this.parseVariableDeclaration(st, ast);
                break;
            }
            if ("DCLF".equalsIgnoreCase(token.value)) {
                this.parseFileDeclaration(st, ast);
                break;
            }
            if ("/*".equals(token.value)) {
                ast.addComment(new Comment(st));
                break;
            }
            if (!"/**".equals(token.value)) continue;
            ast.addComment(new Comment(st));
            break;
        }
    }

    private void parseParameters(Statement st, Ast ast) {
        Iterator<AbstractToken> iterator = st.list().iterator();
        while (iterator.hasNext()) {
            AbstractToken token = iterator.next();
            if ("/*".equals(token.value)) {
                this.skipComment(iterator);
                continue;
            }
            if (!token.value.startsWith("&")) continue;
            ast.addParameter(new Parameter(st, token));
        }
    }

    private void skipComment(Iterator<AbstractToken> iterator) {
        while (iterator.hasNext()) {
            AbstractToken token = iterator.next();
            if (!"*/".equals(token.value)) continue;
            return;
        }
    }

    private void parseFileDeclaration(Statement st, Ast ast) {
        File f = new File();
        f.setStatement(st);
        Iterator<AbstractToken> iterator = st.list().iterator();
        while (iterator.hasNext()) {
            AbstractToken token = iterator.next();
            if ("//".equals(token.value) || "?".equals(token.value) || token.value.equals(":")) continue;
            if ("/*".equals(token.value)) {
                this.skipComment(iterator);
                continue;
            }
            if (!"DCLF".equalsIgnoreCase(token.value)) continue;
            boolean shortDeclarationTypeOn = true;
            int numberShortDeclarations = 0;
            while (iterator.hasNext()) {
                AbstractToken valueToken;
                token = iterator.next();
                if ("/*".equals(token.value)) {
                    this.skipComment(iterator);
                    continue;
                }
                if ("FILE".equalsIgnoreCase(token.value)) {
                    List<AbstractToken> valueTokens = this.getParameterValues(iterator);
                    if (valueTokens.size() == 1) {
                        f.setFileToken(valueTokens.get(0));
                        continue;
                    }
                    if (valueTokens.size() == 2 && valueTokens.get((int)0).value.equals("/")) {
                        f.setFileToken(valueTokens.get(1));
                        continue;
                    }
                    if (valueTokens.size() == 2 && valueTokens.get((int)1).value.equals("/")) {
                        f.setLibraryToken(valueTokens.get(0));
                        continue;
                    }
                    if (valueTokens.size() <= 2) continue;
                    f.setLibraryToken(valueTokens.get(0));
                    f.setFileToken(valueTokens.get(2));
                    continue;
                }
                if ("RCDFMT".equalsIgnoreCase(token.value)) {
                    valueToken = this.getParameterValue(iterator);
                    f.setRecordFormatToken(valueToken);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("OPNID".equalsIgnoreCase(token.value)) {
                    valueToken = this.getParameterValue(iterator);
                    f.setOpenIdToken(valueToken);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("ALWVARLEN".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("ALWNULL".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("ALWGRAPHIC".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("DCLBINFLD".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if (!shortDeclarationTypeOn) continue;
                if (numberShortDeclarations == 1 && f.getLibraryToken() == null && "/".equals(token.value)) {
                    --numberShortDeclarations;
                    f.setLibraryToken(f.getFileToken());
                    continue;
                }
                switch (numberShortDeclarations) {
                    case 0: {
                        if (f.getFileToken() == null) {
                            f.setFileToken(token);
                        } else if (f.getLibraryToken() == null) {
                            f.setLibraryToken(token);
                        } else {
                            f.setFileToken(token);
                        }
                        ++numberShortDeclarations;
                        break;
                    }
                    case 1: {
                        f.setRecordFormatToken(token);
                        ++numberShortDeclarations;
                        break;
                    }
                    case 2: {
                        f.setOpenIdToken(token);
                        ++numberShortDeclarations;
                    }
                }
            }
        }
        if (f.getFile() != null) {
            ast.addFile(f);
        }
    }

    private void parseVariableDeclaration(Statement st, Ast ast) {
        Variable v = new Variable();
        v.setStatement(st);
        Iterator<AbstractToken> iterator = st.list().iterator();
        while (iterator.hasNext()) {
            AbstractToken token = iterator.next();
            if ("//".equals(token.value) || "?".equals(token.value) || token.value.equals(":")) continue;
            if ("/*".equals(token.value)) {
                this.skipComment(iterator);
                continue;
            }
            if (!"DCL".equalsIgnoreCase(token.value)) continue;
            boolean shortDeclarationTypeOn = true;
            int numberShortDeclarations = 0;
            while (iterator.hasNext()) {
                AbstractToken valueToken;
                token = iterator.next();
                if ("/*".equals(token.value)) {
                    this.skipComment(iterator);
                    continue;
                }
                if ("VAR".equalsIgnoreCase(token.value)) {
                    valueToken = this.getParameterValue(iterator);
                    v.setName(valueToken);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("TYPE".equalsIgnoreCase(token.value)) {
                    valueToken = this.getParameterValue(iterator);
                    v.setTypeToken(valueToken);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("LEN".equalsIgnoreCase(token.value)) {
                    List<AbstractToken> valueTokens = this.getParameterValues(iterator);
                    if (valueTokens != null) {
                        if (valueTokens.size() >= 1) {
                            v.setLengthToken(valueTokens.get(0));
                        }
                        if (valueTokens.size() == 2) {
                            v.setDecimalPositionToken(valueTokens.get(1));
                        }
                    }
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("VALUE".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("STG".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("ADDRESS".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("DEFVAR".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if ("BASPTR".equalsIgnoreCase(token.value)) {
                    this.skipParameter(iterator);
                    shortDeclarationTypeOn = false;
                    continue;
                }
                if (!shortDeclarationTypeOn) continue;
                switch (numberShortDeclarations) {
                    case 0: {
                        v.setName(token);
                        break;
                    }
                    case 1: {
                        v.setTypeToken(token);
                        break;
                    }
                    case 2: {
                        if ("(".equals(token.value)) {
                            token = iterator.next();
                            if (token == null) break;
                            v.setLengthToken(token);
                            token = iterator.next();
                            if (token == null || ")".equals(token.value)) break;
                            v.setDecimalPositionToken(token);
                            token = iterator.next();
                            break;
                        }
                        v.setLengthToken(token);
                    }
                }
                ++numberShortDeclarations;
            }
        }
        if (v.getName() != null) {
            ast.addVariable(v);
        }
    }

    private AbstractToken getParameterValue(Iterator<AbstractToken> iterator) {
        AbstractToken token = iterator.next();
        if (token != null && token.value.equals("(") && (token = iterator.next()) != null && !token.value.equals(")")) {
            return token;
        }
        return null;
    }

    private List<AbstractToken> getParameterValues(Iterator<AbstractToken> iterator) {
        LinkedList<AbstractToken> tokens = new LinkedList<AbstractToken>();
        AbstractToken token = iterator.next();
        if (token != null && token.value.equals("(")) {
            token = iterator.next();
            while (token != null) {
                if ("/*".equals(token.value)) {
                    this.skipComment(iterator);
                } else {
                    if (token.value.equals(")")) {
                        return tokens;
                    }
                    tokens.add(token);
                }
                token = iterator.next();
            }
        }
        return null;
    }

    private void skipParameter(Iterator<AbstractToken> iterator) {
        AbstractToken token = iterator.next();
        while (token != null) {
            if (")".equals(token.value)) {
                return;
            }
            token = iterator.next();
        }
    }
}

