/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref.validation;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.pref.api.IValidator;
import miworkplace.ui.pref.api.ValidationException;

public class NumberValidator
implements IValidator {
    private List<Integer> values = new LinkedList<Integer>();

    public NumberValidator() {
    }

    public NumberValidator(Integer number) {
        this.values.add(number);
    }

    public NumberValidator(Collection<Integer> numbers) {
        this.values.addAll(numbers);
    }

    public void add(Integer number) {
        this.values.add(number);
    }

    @Override
    public void validate(String value) throws ValidationException {
        if (value == null) {
            throw new ValidationException(Messages.pref_val_number_empty);
        }
        try {
            Integer number = Integer.valueOf(value);
            if (!this.values.contains(number)) {
                throw new ValidationException(String.format(Messages.pref_val_number_range, value), value);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ValidationException(String.format(Messages.pref_val_number_valid, value), value, nfe);
        }
    }
}

