/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import miworkplace.ui.pref.api.IValidator;
import miworkplace.ui.pref.api.PasswordPreference;
import miworkplace.ui.pref.api.Preference;
import miworkplace.ui.pref.api.PreferencePage;
import miworkplace.ui.pref.api.ValidationException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

class SimplePreferencePage
extends PreferencePage {
    public SimplePreferencePage(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void save(IEclipsePreferences preferences) {
        this.findPreferences(preferences, this.getChildren());
    }

    private void findPreferences(IEclipsePreferences preferences, Control[] widgets) {
        Object data;
        Control field;
        boolean valid = true;
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            field = controlArray[n2];
            data = field.getData("preference");
            if (data != null) {
                Preference pref = (Preference)data;
                for (IValidator v : pref.getValidators()) {
                    if (!(field instanceof Text)) continue;
                    try {
                        v.validate(((Text)field).getText());
                    }
                    catch (ValidationException validationException) {
                        valid = false;
                    }
                }
            }
            if (field instanceof Composite) {
                this.findPreferences(preferences, ((Composite)field).getChildren());
            }
            ++n2;
        }
        if (valid) {
            controlArray = widgets;
            n = widgets.length;
            n2 = 0;
            while (n2 < n) {
                field = controlArray[n2];
                data = field.getData("preference");
                if (data != null) {
                    this.savePreference(preferences, (Preference)data, field);
                }
                if (field instanceof Composite) {
                    this.findPreferences(preferences, ((Composite)field).getChildren());
                }
                ++n2;
            }
        }
    }

    private void savePreference(IEclipsePreferences preferences, Preference p, Control control) {
        if (control instanceof Text) {
            String value = ((Text)control).getText();
            if (p instanceof PasswordPreference) {
                try {
                    value = Base64.getEncoder().encodeToString(value.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException("UTF-8 is not supported on this machine.");
                }
            }
            preferences.put(p.getId(), value);
        } else if (control instanceof Button) {
            preferences.putBoolean(p.getId(), ((Button)control).getSelection());
        } else if (control instanceof CCombo) {
            preferences.put(p.getId(), ((CCombo)control).getText());
        }
    }
}

