/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.rpgunit.ui;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.rpgunit.model.CallStackEntry;
import miworkplace.rpgunit.model.UnitTestCase;
import miworkplace.rpgunit.model.UnitTestResult;
import miworkplace.rpgunit.model.UnitTestViewerRoot;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.ui.themes.Colors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RpgUnitView {
    public static final String PART_ID = "miworkplace.rpgunit.part";
    @Inject
    private IResourcePool imagePool;
    @Inject
    private IObjectPropertiesStore propertiesStore;
    @Inject
    @Preference(nodePath="miworkplace.application")
    protected IEclipsePreferences applicationPreferences;
    private TreeViewer viewer;
    private HeaderControl header;
    private boolean showFailuresOnly = false;

    @PostConstruct
    public void createPartControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainPanel.setLayout((Layout)layout);
        this.header = new HeaderControl(mainPanel);
        this.header.setLayoutData(new GridData(768));
        this.viewer = new TreeViewer(mainPanel);
        this.viewer.getTree().setHeaderVisible(false);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new UnitTestContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new UnitTestTreeLabelProvider(this.imagePool));
        this.viewer.setFilters(new ViewerFilter[]{new FailureFilter()});
    }

    @Focus
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setInput(UnitTestResult[] testResults) {
        if (testResults == null) {
            this.viewer.setInput(null);
            this.header.clear();
        } else {
            this.viewer.setInput((Object)new UnitTestViewerRoot(testResults));
            this.viewer.refresh(true);
            this.viewer.expandAll();
            this.header.update(testResults);
        }
    }

    public void toggleShowFailuresOnly() {
        this.showFailuresOnly = !this.showFailuresOnly;
        this.viewer.refresh(true);
        this.viewer.expandAll();
    }

    public Object getViewerInput() {
        return this.viewer.getInput();
    }

    class FailureFilter
    extends ViewerFilter {
        FailureFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (RpgUnitView.this.showFailuresOnly) {
                if (element instanceof UnitTestCase) {
                    return !((UnitTestCase)element).isSuccessful();
                }
                if (element instanceof UnitTestResult) {
                    if (((UnitTestResult)element).getNumberFailures() > 0) {
                        return true;
                    }
                    return ((UnitTestResult)element).getNumberErrors() > 0;
                }
                return true;
            }
            return true;
        }
    }

    class HeaderControl
    extends Composite {
        private Label runs;
        private Label errors;
        private Label failures;

        public HeaderControl(Composite parent) {
            super(parent, 0);
            this.init();
        }

        public void clear() {
            this.runs.setText("0");
            this.errors.setText("0");
            this.failures.setText("0");
            this.update();
        }

        private void init() {
            FillLayout layout = new FillLayout(256);
            layout.marginWidth = 10;
            layout.marginHeight = 10;
            this.setLayout((Layout)layout);
            Composite col1 = new Composite((Composite)this, 0);
            col1.setLayout((Layout)new RowLayout(256));
            Label label = new Label(col1, 0);
            label.setText(Messages.rpgunit_runs + ":");
            this.runs = new Label(col1, 0);
            this.runs.setText("0");
            Composite col2 = new Composite((Composite)this, 0);
            col2.setLayout((Layout)new RowLayout(256));
            label = new Label(col2, 0);
            label.setImage(RpgUnitView.this.imagePool.getImageUnchecked("IMAGE_RPGUNIT_TEST_FAILED"));
            label = new Label(col2, 0);
            label.setText(Messages.rpgunit_failures + ":");
            this.failures = new Label(col2, 0);
            this.failures.setText("0");
            Composite col3 = new Composite((Composite)this, 0);
            col3.setLayout((Layout)new RowLayout(256));
            label = new Label(col3, 0);
            label.setImage(RpgUnitView.this.imagePool.getImageUnchecked("IMAGE_RPGUNIT_ERROR"));
            label = new Label(col3, 0);
            label.setText(Messages.rpgunit_errors + ":");
            this.errors = new Label(col3, 0);
            this.errors.setText("0");
        }

        public void update(UnitTestResult[] results) {
            int numberRuns = 0;
            int numberErrors = 0;
            int numberFailures = 0;
            UnitTestResult[] unitTestResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                UnitTestResult unitTestResult = unitTestResultArray[n2];
                numberRuns += unitTestResult.getNumberTestCases();
                numberErrors += unitTestResult.getNumberErrors();
                numberFailures += unitTestResult.getNumberFailures();
                ++n2;
            }
            this.runs.setText(String.valueOf(numberRuns));
            this.errors.setText(String.valueOf(numberErrors));
            this.failures.setText(String.valueOf(numberFailures));
            this.update();
        }
    }

    class UnitTestContentProvider
    implements ITreeContentProvider {
        private Object[] noElements = new Object[0];

        UnitTestContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof UnitTestViewerRoot) {
                return ((UnitTestViewerRoot)parentElement).getTestResults();
            }
            if (parentElement instanceof UnitTestResult) {
                return ((UnitTestResult)parentElement).getTestCases();
            }
            if (parentElement instanceof UnitTestCase) {
                UnitTestCase testcase = (UnitTestCase)parentElement;
                List<CallStackEntry> callStack = testcase.getCallStack();
                if (callStack != null && !callStack.isEmpty()) {
                    List<CallStackEntry> filteredCallStack = this.filterCallStack(callStack);
                    return filteredCallStack.toArray(new CallStackEntry[filteredCallStack.size()]);
                }
                return this.noElements;
            }
            return this.noElements;
        }

        private List<CallStackEntry> filterCallStack(List<CallStackEntry> callStack) {
            String rpgunitLibrary = RpgUnitView.this.applicationPreferences.get("miworkplace.rpgunit.library", "RPGUNIT");
            String rpgunitRunner = RpgUnitView.this.applicationPreferences.get("miworkplace.rpgunit.runner", "RUPGMRMT");
            ArrayList<CallStackEntry> filteredCallStack = new ArrayList<CallStackEntry>();
            for (CallStackEntry entry : callStack) {
                if (rpgunitLibrary.equalsIgnoreCase(entry.senderProgramLibrary) && rpgunitRunner.equalsIgnoreCase(entry.senderProgramName)) break;
                filteredCallStack.add(entry);
            }
            return filteredCallStack;
        }

        public Object getParent(Object element) {
            if (element instanceof UnitTestResult) {
                return RpgUnitView.this.viewer.getInput();
            }
            if (element instanceof UnitTestCase) {
                return ((UnitTestCase)element).getTestResult();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class UnitTestTreeLabelProvider
    extends StyledCellLabelProvider {
        private final NumberFormat formatter;
        private final IResourcePool imagePool;

        public UnitTestTreeLabelProvider(IResourcePool imagePool) {
            this.imagePool = imagePool;
            this.formatter = NumberFormat.getInstance();
            this.formatter.setGroupingUsed(false);
            this.formatter.setMinimumIntegerDigits(1);
            this.formatter.setMinimumFractionDigits(3);
        }

        public Image getImage(Object element) {
            if (element instanceof UnitTestCase) {
                UnitTestCase test = (UnitTestCase)element;
                if (UnitTestCase.Status.Success.equals((Object)test.getStatus())) {
                    return this.imagePool.getImageUnchecked("IMAGE_RPGUNIT_TEST_SUCCESS");
                }
                if (UnitTestCase.Status.Error.equals((Object)test.getStatus())) {
                    return this.imagePool.getImageUnchecked("IMAGE_RPGUNIT_ERROR");
                }
                if (UnitTestCase.Status.Failure.equals((Object)test.getStatus())) {
                    return this.imagePool.getImageUnchecked("IMAGE_RPGUNIT_TEST_FAILED");
                }
            } else if (element instanceof UnitTestResult) {
                if (((UnitTestResult)element).getNumberErrors() > 0) {
                    return this.imagePool.getImageUnchecked("IMAGE_RPGUNIT_ERROR");
                }
                if (((UnitTestResult)element).getNumberFailures() > 0) {
                    return this.imagePool.getImageUnchecked("IMAGE_RPGUNIT_TEST_FAILED");
                }
                return this.imagePool.getImageUnchecked("IMAGE_RPGUNIT_TEST_SUCCESS");
            }
            return null;
        }

        public void update(ViewerCell cell) {
            StringBuilder text = new StringBuilder();
            LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
            Object element = cell.getElement();
            if (element instanceof UnitTestCase) {
                StyleRange range;
                UnitTestCase testcase = (UnitTestCase)element;
                text.append(testcase.getName());
                if (testcase.getExecutionTime() != null) {
                    String time = " (" + this.formatter.format(testcase.getExecutionTime()) + " s)";
                    range = new StyleRange();
                    range.start = text.length();
                    range.length = time.length();
                    range.foreground = Colors.instance().get(Colors.ColorDefinition.String);
                    styleRanges.add(range);
                    text.append(time);
                }
                if (!testcase.isSuccessful()) {
                    String styledText = " - " + testcase.getErrorMessage();
                    range = new StyleRange();
                    range.start = text.length();
                    range.length = styledText.length();
                    range.foreground = Colors.instance().get(Colors.ColorDefinition.Alert);
                    styleRanges.add(range);
                    text.append(styledText);
                }
            } else if (element instanceof CallStackEntry) {
                text.append(element.toString());
            } else if (element instanceof UnitTestResult) {
                IRemoteObject object = ((UnitTestResult)element).getServiceProgram();
                Map properties = RpgUnitView.this.propertiesStore.get(object);
                if (properties != null && properties.get(ObjectProperty.textdescription) != null && properties.get(ObjectProperty.textdescription).toString().trim().length() > 0) {
                    text.append(object.getName());
                    String styledText = " (" + properties.get(ObjectProperty.textdescription).toString().trim() + ")";
                    StyleRange range = new StyleRange();
                    range.start = text.length();
                    range.length = styledText.length();
                    range.foreground = Colors.instance().get(Colors.ColorDefinition.DefaultFont);
                    styleRanges.add(range);
                    text.append(styledText);
                } else {
                    text.append(object.getName());
                }
            }
            cell.setImage(this.getImage(element));
            cell.setText(text.toString());
            cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
            super.update(cell);
        }
    }
}

