/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.rpgunit.handler;

import jakarta.inject.Inject;
import java.util.Arrays;
import miworkplace.rpgunit.RerunUnitTestJob;
import miworkplace.rpgunit.model.UnitTestResult;
import miworkplace.rpgunit.model.UnitTestViewerRoot;
import miworkplace.rpgunit.ui.RpgUnitView;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class RerunUnitTestHandler {
    @Inject
    private UISynchronize sync;
    @Inject
    private IEclipseContext context;
    @Inject
    private EPartService partService;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;

    @CanExecute
    public boolean canExecute() {
        RpgUnitView view = this.getView("miworkplace.rpgunit.part");
        return view.getViewerInput() != null;
    }

    @Execute
    public void execute() {
        RpgUnitView view = (RpgUnitView)this.partService.findPart("miworkplace.rpgunit.part").getObject();
        UnitTestResult[] results = ((UnitTestViewerRoot)view.getViewerInput()).getTestResults();
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set("miworkplace.rpgunit.results", Arrays.asList(results));
        additionalContext.set(UISynchronize.class, (Object)this.sync);
        Job job = (Job)ContextInjectionFactory.make(RerunUnitTestJob.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        job.schedule();
    }

    private RpgUnitView getView(String partId) {
        MPart part = this.partService.findPart("miworkplace.rpgunit.part");
        if (part == null) {
            return null;
        }
        return (RpgUnitView)part.getObject();
    }
}

