/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.text;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.FieldDescription;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.iledocs.model.EscapeMessage;
import miworkplace.iledocs.model.IledocsModel;
import miworkplace.iledocs.model.Parameter;
import miworkplace.iledocs.model.Variable;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Constant;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.themes.Colors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.RGB;

public class DescriptionBuilder {
    private static final String DATASTRUCTURE_IMAGE_BASE64 = "R0lGODlhEAAQANUAALS70YmYu5+rx2d9qXSIsIaUroiVrIyXqo+aqJScpe/6/9Xz/5ifovX8//j9//T8/+v6/+/7/zeYYKjOt3y4fZ6inqKlm6iol62rlLGukbWwjr21ibmyjL+2iO6ek+BrXuuRhv///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACEALAAAAAAQABAAAAZ9wJBwSCwOO8ikMjncLJ7Q6GIz5Cwmkglky4VwhpqFhCKBDAgBAQCiGWau2UhEIZdnhpjF49HY+/cYQxcLDoWGhxdDFouMjYxDFVKSFUMMC12YEAxDCQsgIB+ZEAlDCJ4eHxFnaQARCEMHCx+zf34HQwaEh7sGQwW/wMHAIUEAOw==";
    private static final String VARIABLE_IMAGE_BASE64 = "R0lGODlhEAAQALMAABCGTTSYaEShdH29n5HIrh6JUnGxdYm4gf///////wAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAkALAAAAAAQABAAAAQpMMlJq704680xEQKxEcFxBGIWGAhiBBpwtAegDXI9bEMB7J2gcEjURAAAOw==";
    private static final String CONSTANT_IMAGE_BASE64 = "R0lGODlhEAAQAOMIAEF3r1OGuhBcnBljoCZrpyxwqEiDs7DJ3////////////////////////////////yH5BAEKAA8ALAAAAAAQABAAAAQi8MlJq7046827/4RnBAZ3FEhxbAPiDtoJIICaCXgufHxPRQA7";
    private static final String PROCEDURE_IMAGE_BASE64 = "R0lGODlhEAAQAMQAAAOASAWBSR2MVi6VYEOcbE2jc2SuhXG2jW+xinW3kD+XYD+YX0qbZVancF+qdGKqcHGxdnGxdYS/hIK9goS+hIK1f4i5gYi4gYm4gZjGkJe9iKvPmavPmLTSnf///wAAACH5BAEAAB4ALAAAAAAQABAAAAU+oCeOZGmeaKquLJoEQ7IWTpc5RXo0W881BxRgQilKJgCU4AGBRCAPAcqwsFwwFoUhRWBoKgzCCgFDtM5oVggAOw==";
    private static final String PROTOTYPE_IMAGE_BASE64 = "R0lGODlhEAAQAMQAAISHj4OIk292hMbHyZqbnJCRkrO0s7Cwr6iop6Cgn5mZmJSUk5OTko+PjoaGhcvLy7+/v7S0tLGxsbCwsKioqKSkpKGhoaCgoJ+fn5KSkpCQkI+Pj////wAAAAAAAAAAACH5BAEAABwALAAAAAAQABAAAAU+ICeOZGmeaKqu5EA4w1pQz1NlaZRIEHRcBpQggSgiLgJUYMFoMjQA1GRjwWAsjUlKoChmkqpJIKBlmc9odAgAOw==";

    public String build(Procedure procedure) {
        return this.build(procedure, new miworkplace.iledocs.model.Procedure());
    }

    public String build(Procedure procedure, miworkplace.iledocs.model.Procedure iledocs) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div>");
        sb.append("<div class=\"header\">");
        sb.append(this.getProcedureEmbeddedImage());
        sb.append(" <span class=\"name\">");
        sb.append(procedure.getName());
        sb.append("</span>");
        sb.append("</div>");
        String iledocsString = this.buildIledocs((IledocsModel)iledocs);
        if (StringUtils.isNotEmpty((CharSequence)iledocsString)) {
            sb.append("<div>");
            sb.append(iledocsString);
            sb.append("</div>");
        }
        if (!procedure.getProcedureInterface().getParameters().isEmpty()) {
            sb.append(this.createIledocsParameters(procedure.getProcedureInterface().getParameters(), iledocs));
        }
        if (procedure.getProcedureInterface().getReturnValue() != null) {
            sb.append(this.createIledocsReturnValue(procedure.getProcedureInterface().getReturnValue(), iledocs));
        }
        sb.append(this.createIledocsDeprecated(iledocs));
        sb.append(this.createIledocsInfos(iledocs));
        sb.append(this.createIledocsWarnings(iledocs));
        sb.append(this.createIledocsEscapeMessages(iledocs));
        sb.append("</div>");
        return this.composeHtml(sb.toString());
    }

    private String buildParameterDescription(miworkplace.ui.editor.rpg.ast.Parameter parameter) {
        StringBuffer sb = new StringBuffer();
        if (parameter instanceof DataStructure) {
            DataStructure ds = (DataStructure)parameter;
            sb.append(" <span class=\"name\">");
            sb.append(ds.getName());
            if (ds.getLike() != null) {
                sb.append("<span class=\"type\"> : ");
                sb.append(ds.getLike());
                sb.append("</span>");
            }
            sb.append("</span>");
        } else if (parameter instanceof miworkplace.ui.editor.rpg.ast.Variable) {
            miworkplace.ui.editor.rpg.ast.Variable variable = (miworkplace.ui.editor.rpg.ast.Variable)parameter;
            sb.append(" <span class=\"name\">");
            sb.append(variable.getName());
            sb.append("</span>");
            sb.append("<span class=\"type\">");
            sb.append(" : ");
            sb.append(this.buildVariableType(variable));
            sb.append("</span>");
        }
        return sb.toString();
    }

    public String build(Prototype prototype, Procedure procedure, miworkplace.iledocs.model.Procedure iledocs) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div>");
        sb.append("<div class=\"header\">");
        sb.append(this.getProtptypeEmbeddedImage());
        sb.append(" <span class=\"name\">");
        sb.append(prototype.getName());
        sb.append("</span>");
        sb.append("</div>");
        String iledocsString = this.buildIledocs((IledocsModel)iledocs);
        if (StringUtils.isNotEmpty((CharSequence)iledocsString)) {
            sb.append("<div>");
            sb.append(iledocsString);
            sb.append("</div>");
        }
        if (!prototype.getParameters().isEmpty()) {
            sb.append(this.createIledocsParameters(prototype.getParameters(), iledocs));
        }
        if (prototype.getReturnValue() != null) {
            sb.append(this.createIledocsReturnValue(prototype.getReturnValue(), iledocs));
        }
        sb.append(this.createIledocsDeprecated(iledocs));
        sb.append(this.createIledocsInfos(iledocs));
        sb.append(this.createIledocsWarnings(iledocs));
        sb.append(this.createIledocsEscapeMessages(iledocs));
        sb.append("</div>");
        return this.composeHtml(sb.toString());
    }

    private String createIledocsReturnValue(Object returnValue, miworkplace.iledocs.model.Procedure iledocs) {
        if (returnValue == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div>");
        sb.append("<b>" + Messages.editor_rpg_text_descbuilder_retval + "</b><br/>");
        sb.append("<span class=\"subcontent\">");
        if (returnValue instanceof DataStructure) {
            DataStructure ds = (DataStructure)returnValue;
            sb.append(" <span class=\"name\">");
            sb.append(ds.getLike());
            sb.append("</span>");
        } else if (returnValue instanceof miworkplace.ui.editor.rpg.ast.Variable) {
            miworkplace.ui.editor.rpg.ast.Variable variable = (miworkplace.ui.editor.rpg.ast.Variable)returnValue;
            sb.append(this.buildVariableType(variable));
        }
        if (iledocs != null && iledocs.getReturnValue() != null && StringUtils.isNotEmpty((CharSequence)iledocs.getReturnValue().getDescription())) {
            sb.append(" - " + iledocs.getReturnValue().getDescription());
        }
        sb.append("</span>");
        sb.append("</div>");
        return sb.toString();
    }

    private String createIledocsParameters(List<miworkplace.ui.editor.rpg.ast.Parameter> parameters, miworkplace.iledocs.model.Procedure iledocs) {
        if (parameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div>");
        sb.append("<b>" + Messages.editor_rpg_text_descbuilder_parms + "</b><br/>");
        int i = 1;
        for (miworkplace.ui.editor.rpg.ast.Parameter parameter : parameters) {
            sb.append("<span class=\"subcontent\">" + this.buildParameterDescription(parameter));
            if (iledocs != null && iledocs.getParameters().size() >= i) {
                sb.append(" - " + ((Parameter)iledocs.getParameters().get(i - 1)).getDescription());
            }
            sb.append("</span><br/>");
            ++i;
        }
        sb.append("</div>");
        return sb.toString();
    }

    private String createIledocsEscapeMessages(miworkplace.iledocs.model.Procedure iledocs) {
        if (iledocs != null && !iledocs.getEscapeMessages().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<div>");
            sb.append("<b>" + Messages.editor_rpg_iledocs_escape + ":</b><br/>");
            sb.append("<span class=\"subcontent\">");
            List messages = iledocs.getEscapeMessages();
            int i = 0;
            while (i < messages.size()) {
                EscapeMessage message = (EscapeMessage)messages.get(i);
                if (StringUtils.isNotEmpty((CharSequence)message.getId())) {
                    sb.append(message.getId() + " - ");
                }
                sb.append(message.getDescription());
                if (i < messages.size() - 1) {
                    sb.append("<br/>");
                }
                ++i;
            }
            sb.append("</span>");
            sb.append("</div>");
            return sb.toString();
        }
        return "";
    }

    private String createIledocsWarnings(miworkplace.iledocs.model.Procedure iledocs) {
        if (iledocs != null && !iledocs.getWarnings().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<div>");
            sb.append("<b>" + Messages.editor_rpg_iledocs_warnings + "</b><br/>");
            List warnings = iledocs.getWarnings();
            int i = 0;
            while (i < warnings.size()) {
                sb.append("<span class=\"subcontent\">");
                sb.append((String)warnings.get(i));
                if (i < warnings.size() - 1) {
                    sb.append("<br/>");
                }
                sb.append("</span>");
                ++i;
            }
            sb.append("</div>");
            return sb.toString();
        }
        return "";
    }

    private String createIledocsInfos(miworkplace.iledocs.model.Procedure iledocs) {
        if (iledocs != null && !iledocs.getInfos().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<div>");
            sb.append("<b>" + Messages.editor_rpg_iledocs_infos + "</b><br/>");
            List infos = iledocs.getInfos();
            int i = 0;
            while (i < infos.size()) {
                sb.append("<span class=\"subcontent\">");
                sb.append((String)infos.get(i));
                if (i < infos.size() - 1) {
                    sb.append("<br/>");
                }
                sb.append("</span>");
                ++i;
            }
            sb.append("</div>");
            return sb.toString();
        }
        return "";
    }

    private String createIledocsDeprecated(miworkplace.iledocs.model.Procedure iledocs) {
        if (iledocs != null && StringUtils.isNotEmpty((CharSequence)iledocs.getDeprecated())) {
            StringBuilder sb = new StringBuilder();
            sb.append("<div>");
            sb.append("<b>" + Messages.editor_rpg_iledocs_deprecated + ":</b><br/>");
            sb.append("<span class=\"subcontent\">");
            sb.append(iledocs.getDeprecated());
            sb.append("</span>");
            sb.append("</div>");
            return sb.toString();
        }
        return "";
    }

    public String build(miworkplace.ui.editor.rpg.ast.Variable variable, Ast ast, Procedure procedure, Variable iledocs) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div>");
        sb.append("<div class=\"header\">");
        sb.append(this.getVariableEmbeddedImage());
        sb.append(" <span class=\"name\">");
        sb.append(variable.getName());
        sb.append("</span>");
        sb.append("<span class=\"type\">");
        sb.append(" : ");
        sb.append(this.buildVariableType(variable));
        sb.append("</span>");
        sb.append(" <span class=\"scope\">[");
        sb.append(procedure == null ? Messages.editor_rpg_text_descbuilder_global : procedure.getName());
        sb.append("]</span>");
        sb.append("</div>");
        String iledocsString = this.buildIledocs(iledocs);
        if (StringUtils.isNotEmpty((CharSequence)iledocsString)) {
            sb.append("<div>");
            sb.append(iledocsString);
            sb.append("</div>");
        }
        sb.append("</div>");
        return this.composeHtml(sb.toString());
    }

    public String build(DataStructure ds, Ast ast, Procedure procedure, Variable iledocs) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div>");
        sb.append("<div class=\"header\">");
        sb.append(this.getDataStructureEmbeddedImage());
        sb.append(" <span class=\"name\">");
        sb.append(ds.getName());
        if (ds.getArraySize() != null) {
            sb.append(" [");
            sb.append(ds.getArraySize());
            sb.append("]");
        }
        sb.append("</span>");
        sb.append(" <span class=\"scope\">[");
        sb.append(procedure == null ? Messages.editor_rpg_text_descbuilder_global : procedure.getName());
        sb.append("]</span>");
        sb.append("</div>");
        String iledocsString = this.buildIledocs(iledocs);
        if (StringUtils.isNotEmpty((CharSequence)iledocsString)) {
            sb.append("<div>");
            sb.append(iledocsString);
            sb.append("</div>");
        }
        if (ds.getExternalName() == null && ds.getLike() == null && ds.getLikeRecord() == null) {
            sb.append("<p>");
            sb.append("<span class=\"subtitle\">");
            sb.append(Messages.editor_rpg_text_descbuilder_subfields);
            sb.append("</span>");
            sb.append("<div class=\"subcontent\">");
            List subfields = ds.getSubfields();
            for (Object object : subfields) {
                if (object instanceof miworkplace.ui.editor.rpg.ast.Variable) {
                    sb.append("<div>");
                    sb.append("<span class=\"name\">");
                    sb.append(((miworkplace.ui.editor.rpg.ast.Variable)object).getName());
                    sb.append("</span>");
                    sb.append("<span class=\"type\">");
                    sb.append(" : ");
                    sb.append(this.buildVariableType((miworkplace.ui.editor.rpg.ast.Variable)object));
                    sb.append("</span>");
                    sb.append("<div>");
                    continue;
                }
                if (!(object instanceof DataStructure)) continue;
                sb.append("<div>");
                sb.append("<span class=\"name\">");
                sb.append(((DataStructure)object).getName());
                sb.append("</span>");
                sb.append("<div>");
            }
            sb.append("</div>");
            sb.append("</p>");
        } else {
            sb.append("<p>");
            sb.append("<span class=\"subtitle\">");
            sb.append(Messages.editor_rpg_text_descbuilder_like);
            sb.append("</span><br/>");
            sb.append("<span class=\"subcontent\">");
            if (ds.getLike() != null) {
                sb.append(ds.getLike());
            } else if (ds.getLikeRecord() != null) {
                sb.append(ds.getLikeRecord());
            } else if (ds.getExternalName() != null) {
                sb.append(ds.getExternalName());
            }
            sb.append("</span>");
            sb.append("</p>");
        }
        sb.append("</div>");
        return this.composeHtml(sb.toString());
    }

    public String build(Constant constant, Ast ast, Procedure procedure, miworkplace.iledocs.model.Constant iledocs) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div>");
        sb.append("<div class=\"header\">");
        sb.append(this.getConstantEmbeddedImage());
        sb.append(" <span class=\"name\">");
        sb.append(constant.name.value);
        sb.append("</span> <span class=\"scope\">[");
        sb.append(procedure == null ? Messages.editor_rpg_text_descbuilder_global : procedure.getName());
        sb.append("]</span>");
        sb.append("</div>");
        sb.append("<p>");
        sb.append("<span class=\"subtitle\">");
        sb.append(Messages.editor_rpg_text_descbuilder_value);
        sb.append("</span> <span class=\"constantValue\">");
        sb.append(constant.value);
        sb.append("</span>");
        sb.append("</p>");
        String iledocsString = this.buildIledocs(iledocs);
        if (StringUtils.isNotEmpty((CharSequence)iledocsString)) {
            sb.append("<div>");
            sb.append(iledocsString);
            sb.append("</div>");
        }
        sb.append("</div>");
        return this.composeHtml(sb.toString());
    }

    private String composeHtml(String info) {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>");
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<style>");
        sb.append(this.getCCS());
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append(info);
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private Object getConstantEmbeddedImage() {
        return "<img src=\"data:image/gif;base64,R0lGODlhEAAQAOMIAEF3r1OGuhBcnBljoCZrpyxwqEiDs7DJ3////////////////////////////////yH5BAEKAA8ALAAAAAAQABAAAAQi8MlJq7046827/4RnBAZ3FEhxbAPiDtoJIICaCXgufHxPRQA7\" width=\"16\" height=\"16\" align=\"top\" />";
    }

    private String getVariableEmbeddedImage() {
        return "<img src=\"data:image/gif;base64,R0lGODlhEAAQALMAABCGTTSYaEShdH29n5HIrh6JUnGxdYm4gf///////wAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAkALAAAAAAQABAAAAQpMMlJq704680xEQKxEcFxBGIWGAhiBBpwtAegDXI9bEMB7J2gcEjURAAAOw==\" width=\"16\" height=\"16\" align=\"center\" />";
    }

    private String getDataStructureEmbeddedImage() {
        return "<img src=\"data:image/gif;base64,R0lGODlhEAAQANUAALS70YmYu5+rx2d9qXSIsIaUroiVrIyXqo+aqJScpe/6/9Xz/5ifovX8//j9//T8/+v6/+/7/zeYYKjOt3y4fZ6inqKlm6iol62rlLGukbWwjr21ibmyjL+2iO6ek+BrXuuRhv///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACEALAAAAAAQABAAAAZ9wJBwSCwOO8ikMjncLJ7Q6GIz5Cwmkglky4VwhpqFhCKBDAgBAQCiGWau2UhEIZdnhpjF49HY+/cYQxcLDoWGhxdDFouMjYxDFVKSFUMMC12YEAxDCQsgIB+ZEAlDCJ4eHxFnaQARCEMHCx+zf34HQwaEh7sGQwW/wMHAIUEAOw==\" width=\"16\" height=\"16\" align=\"top\"/>";
    }

    private String getProcedureEmbeddedImage() {
        return "<img src=\"data:image/gif;base64,R0lGODlhEAAQAMQAAAOASAWBSR2MVi6VYEOcbE2jc2SuhXG2jW+xinW3kD+XYD+YX0qbZVancF+qdGKqcHGxdnGxdYS/hIK9goS+hIK1f4i5gYi4gYm4gZjGkJe9iKvPmavPmLTSnf///wAAACH5BAEAAB4ALAAAAAAQABAAAAU+oCeOZGmeaKquLJoEQ7IWTpc5RXo0W881BxRgQilKJgCU4AGBRCAPAcqwsFwwFoUhRWBoKgzCCgFDtM5oVggAOw==\" width=\"16\" height=\"16\" align=\"center\" />";
    }

    private String getProtptypeEmbeddedImage() {
        return "<img src=\"data:image/gif;base64,R0lGODlhEAAQAMQAAISHj4OIk292hMbHyZqbnJCRkrO0s7Cwr6iop6Cgn5mZmJSUk5OTko+PjoaGhcvLy7+/v7S0tLGxsbCwsKioqKSkpKGhoaCgoJ+fn5KSkpCQkI+Pj////wAAAAAAAAAAACH5BAEAABwALAAAAAAQABAAAAU+ICeOZGmeaKqu5EA4w1pQz1NlaZRIEHRcBpQggSgiLgJUYMFoMjQA1GRjwWAsjUlKoChmkqpJIKBlmc9odAgAOw==\" width=\"16\" height=\"16\" align=\"center\" />";
    }

    public String buildVariableType(miworkplace.ui.editor.rpg.ast.Variable v) {
        StringBuilder sb = new StringBuilder();
        if (v.getLike() != null) {
            sb.append(v.getLike());
        } else if (v.getType() != null) {
            switch (v.getType()) {
                case BinaryDecimal: {
                    sb.append("binary (" + v.getLength() + ")");
                    break;
                }
                case Boolean: {
                    sb.append("boolean");
                    break;
                }
                case Date: {
                    sb.append("date");
                    break;
                }
                case Integer: {
                    sb.append("integer (" + v.getLength() + ")");
                    break;
                }
                case Character: {
                    sb.append("char (" + v.getLength() + ")");
                    break;
                }
                case Float: {
                    sb.append("float (" + v.getLength() + ")");
                    break;
                }
                case Graph: {
                    sb.append("graph (" + v.getLength() + ")");
                    break;
                }
                case Object: {
                    sb.append("object");
                    break;
                }
                case Pointer: {
                    sb.append("pointer");
                    break;
                }
                case Packed: {
                    sb.append("packed (" + v.getLength() + ")");
                    break;
                }
                case Time: {
                    sb.append("time");
                    break;
                }
                case Timestamp: {
                    sb.append("timestamp");
                    break;
                }
                case UnsignedInteger: {
                    sb.append("unsigned int. (" + v.getLength() + ")");
                    break;
                }
                case UCS2: {
                    sb.append("ucs2 (" + v.getLength() + ")");
                    break;
                }
                case Varchar: {
                    sb.append("varchar (" + v.getLength() + ")");
                    break;
                }
                case Zoned: {
                    sb.append("zoned (" + v.getLength() + ")");
                    break;
                }
                case File: {
                    sb.append("file (" + v.getLikeFile() + ")");
                }
            }
        }
        if (sb.length() > 0 && v.getArraySize() != null) {
            if (StringUtils.isNumeric((CharSequence)v.getArraySize())) {
                sb.append(" [");
                sb.append(v.getArraySize());
                sb.append("]");
            } else {
                sb.append(" [" + Messages.common_unknown + "]");
            }
        }
        return sb.toString();
    }

    public String buildFieldTypeLabel(FieldDescription fd) {
        AS400DataType dataType = fd.getDataType();
        switch (dataType.getInstanceType()) {
            case 0: {
                return "array";
            }
            case 14: {
                return "integer (3)";
            }
            case 1: {
                return "integer (5)";
            }
            case 2: {
                return "integer (10)";
            }
            case 3: {
                return "integer (20)";
            }
            case 4: {
                return "array";
            }
            case 17: {
                return "date";
            }
            case 5: {
                return "float (4)";
            }
            case 6: {
                return "float (8)";
            }
            case 7: {
                AS400PackedDecimal packedDataType = (AS400PackedDecimal)dataType;
                return "packed (" + packedDataType.getNumberOfDigits() + ", " + packedDataType.getNumberOfDecimalPositions() + ")";
            }
            case 9: {
                return "char (" + fd.getLength() + ")";
            }
            case 18: {
                return "time";
            }
            case 19: {
                return "timestamp";
            }
            case 15: {
                return "unsigned int. (3)";
            }
            case 10: {
                return "unsigned int. (5)";
            }
            case 11: {
                return "unsigned int. (10)";
            }
            case 16: {
                return "unsigned int. (20)";
            }
            case 12: {
                AS400ZonedDecimal zonedDataType = (AS400ZonedDecimal)dataType;
                return "zoned (" + zonedDataType.getNumberOfDigits() + ", " + zonedDataType.getNumberOfDecimalPositions() + ")";
            }
        }
        return null;
    }

    private String getCCS() {
        StringBuilder sb = new StringBuilder();
        RGB foreground = Colors.instance().get(Colors.ColorDefinition.DefaultFont).getRGB();
        RGB background = Colors.instance().get(Colors.ColorDefinition.DefaultBackground).getRGB();
        RGB title = Colors.instance().get(Colors.ColorDefinition.Code).getRGB();
        sb.append("body {");
        sb.append("background: ");
        sb.append(String.format("#%02X%02X%02X; ", background.red, background.green, background.blue));
        sb.append("font-family: Verdana,Arial,Helvetica Neue,Helvetica,sans-serif;line-height: 22px;}body div {");
        sb.append("color: ");
        sb.append(String.format("#%02X%02X%02X; ", foreground.red, foreground.green, foreground.blue));
        sb.append("} div {margin-top: 10px; margin-bottom: 10px; ");
        sb.append("} .header .name {color: ");
        sb.append(String.format("#%02X%02X%02X; ", title.red, title.green, title.blue));
        sb.append("font-weight: bold;} .header .returnValue {color: ");
        sb.append(String.format("#%02X%02X%02X; ", foreground.red, foreground.green, foreground.blue));
        sb.append("} .parameter {color: ");
        sb.append(String.format("#%02X%02X%02X; ", foreground.red, foreground.green, foreground.blue));
        sb.append("} .header .scope {color: ");
        sb.append(String.format("#%02X%02X%02X; ", title.red, title.green, title.blue));
        sb.append("} .header .type {color: ");
        sb.append(String.format("#%02X%02X%02X; ", title.red, title.green, title.blue));
        sb.append("} .subtitle {font-weight: bold;} .constantValue {font-family: monospace;} .subcontent {padding-left: 20px;}");
        return sb.toString();
    }

    private String buildIledocs(IledocsModel iledocs) {
        if (iledocs == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)iledocs.getTitle()) && StringUtils.isEmpty((CharSequence)iledocs.getDescription())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div>");
        if (StringUtils.isNotBlank((CharSequence)iledocs.getDescription())) {
            sb.append(iledocs.getDescription());
        } else {
            sb.append(iledocs.getTitle());
        }
        sb.append("</p>");
        return sb.toString();
    }

    private String buildIledocs(miworkplace.iledocs.model.Constant iledocs) {
        if (iledocs == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)iledocs.getName()) && StringUtils.isEmpty((CharSequence)iledocs.getDescription())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div>");
        if (StringUtils.isNotBlank((CharSequence)iledocs.getDescription())) {
            sb.append(iledocs.getDescription());
        } else {
            sb.append(iledocs.getName());
        }
        sb.append("</p>");
        return sb.toString();
    }

    private String buildIledocs(Variable iledocs) {
        if (iledocs == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)iledocs.getName()) && StringUtils.isEmpty((CharSequence)iledocs.getDescription())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div>");
        if (StringUtils.isNotBlank((CharSequence)iledocs.getDescription())) {
            sb.append(iledocs.getDescription());
        } else {
            sb.append(iledocs.getName());
        }
        sb.append("</p>");
        return sb.toString();
    }
}

