/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.contentassist;

import java.util.Iterator;
import miworkplace.ui.editor.AbstractCompletionProposal;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.Parameter;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Variable;
import miworkplace.ui.editor.rpg.text.DescriptionBuilder;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ProcedureCompletionProposal
extends AbstractCompletionProposal {
    private Procedure procedure;
    private Image icon;
    private DescriptionBuilder descriptionBuilder = new DescriptionBuilder();

    public ProcedureCompletionProposal(Procedure procedure, Image icon, String description) {
        super(procedure.getName(), description);
        this.icon = icon;
        this.procedure = procedure;
    }

    public String getDisplayString() {
        return this.composeDisplayString();
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.composeDisplayString());
    }

    public Image getImage() {
        return this.icon;
    }

    protected int getCursorPosition() {
        return super.getCursorPosition() - 1;
    }

    protected String getApplyString() {
        return this.procedure.getName() + "()";
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.descriptionBuilder.build(this.procedure);
    }

    private String composeDisplayString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.procedure.getName());
        sb.append("(");
        if (this.procedure.getProcedureInterface() != null && this.procedure.getProcedureInterface().getParameters() != null && !this.procedure.getProcedureInterface().getParameters().isEmpty()) {
            Iterator iterator = this.procedure.getProcedureInterface().getParameters().iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                if (parameter instanceof Variable) {
                    String declaration = this.descriptionBuilder.buildVariableType((Variable)parameter);
                    if (StringUtils.isNotBlank((CharSequence)declaration)) {
                        sb.append(declaration);
                        sb.append(" ");
                        sb.append(StringUtils.defaultString((String)((Variable)parameter).getName()));
                    }
                } else if (parameter instanceof DataStructure) {
                    DataStructure ds = (DataStructure)parameter;
                    if (ds.getLike() != null) {
                        sb.append(ds.getLike());
                        sb.append(" ");
                    }
                    if (StringUtils.isNotBlank((CharSequence)ds.getName())) {
                        sb.append(ds.getName());
                    }
                }
                if (!iterator.hasNext()) continue;
                sb.append(" : ");
            }
        }
        sb.append(")");
        if (this.procedure.getProcedureInterface() != null && this.procedure.getProcedureInterface().getReturnValue() != null) {
            Object returnValue = this.procedure.getProcedureInterface().getReturnValue();
            if (returnValue instanceof Variable) {
                sb.append(" : " + this.descriptionBuilder.buildVariableType((Variable)returnValue));
            } else if (returnValue instanceof DataStructure && ((DataStructure)returnValue).getLike() != null) {
                sb.append(" : " + ((DataStructure)returnValue).getLike());
            }
        }
        return sb.toString();
    }
}

