/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.contentassist;

import miworkplace.ast.rpg.iledocs.ILEDocs;
import miworkplace.ast.rpg.iledocs.Link;
import miworkplace.i18n.Messages;

public class ILEDocsUtil {
    public static String buildILEDocsHtmlPresentation(ILEDocs iledocs) {
        Link[] links;
        String[] warnings;
        String[] infos;
        int n;
        StringBuilder html = new StringBuilder();
        html.append("<p><b>" + iledocs.getBriefDescription() + "</b></p>");
        if (iledocs.isDeprecated()) {
            html.append("<b>" + Messages.editor_rpg_iledocs_deprecated + "</b> " + iledocs.getDeprecatedDescription());
        }
        html.append("<p>" + iledocs.getDescription() + "</p>");
        String[] parmDesc = iledocs.getParameterDescriptions();
        if (parmDesc.length > 0) {
            html.append("<dl><dt><b>" + Messages.editor_rpg_iledocs_parms + "</b></dt>");
            String[] stringArray = parmDesc;
            n = parmDesc.length;
            int n2 = 0;
            while (n2 < n) {
                String desc = stringArray[n2];
                html.append("<dd>" + desc + "</dd>");
                ++n2;
            }
            html.append("</dl>");
        }
        if (iledocs.getReturnValueDescription().length() > 0) {
            html.append("<dl><dt><b>" + Messages.editor_rpg_iledocs_return + "</b></dt><dd>" + iledocs.getReturnValueDescription() + "</dd></dl>");
        }
        if (iledocs.getAuthor().length() > 0) {
            html.append("<dl><dt><b>" + Messages.editor_rpg_iledocs_author + "</b></dt><dd>" + iledocs.getAuthor() + "</dd></dl>");
        }
        if (iledocs.getDate().length() > 0) {
            html.append("<dl><dt><b>" + Messages.editor_rpg_iledocs_date + "</b></dt><dd>" + iledocs.getDate() + "</dd></dl>");
        }
        if (iledocs.getTask().length() > 0) {
            html.append("<dl><dt><b>" + Messages.editor_rpg_iledocs_task + "</b></dt><dd>" + iledocs.getTask() + "</dd></dl>");
        }
        if ((infos = iledocs.getInfos()).length > 0) {
            html.append("<dl><dt><b>" + Messages.editor_rpg_iledocs_infos + "</b></dt><dd><ul>");
            String[] stringArray = infos;
            int n3 = infos.length;
            n = 0;
            while (n < n3) {
                String info = stringArray[n];
                html.append("<li>" + info + "</li>");
                ++n;
            }
            html.append("</ul></dd></dl>");
        }
        if ((warnings = iledocs.getWarnings()).length > 0) {
            html.append("<dl><dt><b>" + Messages.editor_rpg_iledocs_warnings + "</b></dt><dd><ul>");
            String[] stringArray = warnings;
            int n4 = warnings.length;
            int n5 = 0;
            while (n5 < n4) {
                String warning = stringArray[n5];
                html.append("<li>" + warning + "</li>");
                ++n5;
            }
            html.append("</ul></dd></dl>");
        }
        if ((links = iledocs.getLinks()).length > 0) {
            html.append("<dl><dt><b>" + Messages.editor_rpg_iledocs_links + "</b></dt>");
            Link[] linkArray = links;
            int n6 = links.length;
            int n7 = 0;
            while (n7 < n6) {
                Link link = linkArray[n7];
                String linkDesc = link.getDescription().length() == 0 ? link.getUrl() : link.getDescription();
                html.append("<dd><a href='" + link.getUrl() + "'>" + linkDesc + "</a></dd>");
                ++n7;
            }
            html.append("</dl>");
        }
        return html.toString();
    }
}

