/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.contentassist;

import miworkplace.ui.editor.AbstractCompletionProposal;
import miworkplace.ui.editor.Activator;
import miworkplace.ui.editor.ColoredStyler;
import miworkplace.ui.themes.Colors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class BifCompletionProposal
extends AbstractCompletionProposal {
    private String returnValueCode;
    private String[] parameters;
    private StyledString.Styler styler = new ColoredStyler(Colors.instance().get(Colors.ColorDefinition.ContentAssistReturnValue));

    public BifCompletionProposal(String code) {
        super(code);
    }

    public BifCompletionProposal(String code, String returnValueCode) {
        this(code, returnValueCode, null, new String[0]);
    }

    public BifCompletionProposal(String code, String returnValueCode, String description, String[] parameters) {
        super(code, description);
        this.parameters = parameters;
        if (StringUtils.isNotBlank((CharSequence)returnValueCode)) {
            this.returnValueCode = returnValueCode;
        }
    }

    public String getDisplayString() {
        if (this.returnValueCode == null) {
            return this.getCode();
        }
        return this.getCode() + " : " + this.returnValueCode;
    }

    public Image getImage() {
        return Activator.getDefault().getImageRegistry().get("bif");
    }

    public StyledString getStyledDisplayString() {
        if (this.returnValueCode == null) {
            return new StyledString(this.getCode());
        }
        StyledString string = new StyledString(this.getCode());
        string.append(" : " + this.returnValueCode, this.styler);
        return string;
    }

    protected int getCursorPosition() {
        return super.getCursorPosition() - 1;
    }

    public String toString() {
        if (this.returnValueCode == null) {
            return this.getCode();
        }
        return this.getCode() + " : " + this.returnValueCode;
    }

    public String getApplyString() {
        return "%" + super.getCode() + "()";
    }

    public String getCode() {
        return "%" + super.getCode() + "(" + this.buildParameterString() + ")";
    }

    private String buildParameterString() {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            builder.append(parameter + " : ");
            ++n2;
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 3);
        }
        return builder.toString();
    }
}

