/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg;

import java.io.IOException;
import java.net.URL;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static Activator instance;
    private ImageRegistry imageRegistry;
    private PreferenceStore syntaxHighlightPrefStore;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        context = null;
    }

    private ImageRegistry buildImageRegistry() {
        ImageRegistry imageRegistry = new ImageRegistry();
        imageRegistry.put(Images.iledocs.name(), new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/icons/iledocs.gif")));
        imageRegistry.put(Images.template.name(), new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/icons/template.gif")));
        imageRegistry.put(Images.bif.name(), new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/icons/opcode.gif")));
        return imageRegistry;
    }

    public static Activator getDefault() {
        return instance;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.buildImageRegistry();
        }
        return this.imageRegistry;
    }

    public PreferenceStore getSyntaxHighlightingPreferenceStore() {
        if (this.syntaxHighlightPrefStore == null) {
            this.syntaxHighlightPrefStore = new PreferenceStore();
            try {
                URL resource = this.context.getBundle().getResource("miworkplace/ui/editor/rpg/text/syntax_highlighting.properties");
                if (resource != null) {
                    this.syntaxHighlightPrefStore.load(resource.openStream());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load properties for syntax highlighting.", ioe);
            }
            catch (NullPointerException npe) {
                throw new RuntimeException("No opcode properties in properties file.", npe);
            }
        }
        return this.syntaxHighlightPrefStore;
    }

    public static enum Images {
        iledocs,
        template,
        bif;

    }
}

