/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.panel;

import com.ibm.iseries.debug.MonitorDescriptor;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.panel.MonitorsPanel;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugFile;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;

public class UnixMonitorsPanel
extends MonitorsPanel {
    private JSplitPane m_splitPane;
    private JScrollPane m_scrollPane;
    private MonitorText m_textArea = new MonitorText();
    private int m_fixCount;
    private boolean m_copyText;

    public UnixMonitorsPanel() {
        this.m_scrollPane = new JScrollPane(this.m_textArea);
        this.m_splitPane = new JSplitPane(0, this.getMonitorPane(), this.m_scrollPane);
        this.m_splitPane.setDividerLocation(0.5);
        this.m_splitPane.setOneTouchExpandable(true);
        this.m_textArea.addMouseListener(this);
        this.m_scrollPane.getViewport().addMouseListener(this);
        this.m_textArea.addFocusListener(this);
        this.m_scrollPane.getViewport().addFocusListener(this);
        Util.setAccessible((Accessible)this.m_textArea, this.m_name);
        Util.setOrientation(this.m_scrollPane);
    }

    public void deleteMonitor() {
        super.deleteMonitor();
        if (this.getMonitorCount() == 0) {
            this.m_textArea.setText("");
            this.m_fixCount = 0;
        } else {
            this.formatMonitors();
        }
    }

    public void deleteAllMonitors() {
        super.deleteAllMonitors();
        this.m_textArea.setText("");
        this.m_fixCount = 0;
    }

    protected int maxColCount() {
        return 2;
    }

    protected boolean isValidColId(int n) {
        return n == 0 || n == 5;
    }

    protected String getColumnNameFromId(int n) {
        switch (n) {
            case 0: {
                return MRI.get("DBG_ADDRESS");
            }
            case 5: {
                return MRI.get("DBG_WATCH");
            }
        }
        return "";
    }

    public void saveSettings() {
        super.saveSettings();
        this.m_userCfg.setInt("monitorsDiv", this.m_splitPane.getDividerLocation());
    }

    public void restoreSettings() {
        super.restoreSettings();
        int n = this.m_userCfg.getInt("monitorsDiv", 100);
        this.m_splitPane.setDividerLocation(n);
    }

    protected void lookAndFeelModifications() {
        super.lookAndFeelModifications();
        this.m_textArea.setFont(SettingsManager.getFixedPitchFont());
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
    }

    public void cleanUp() {
        this.m_textArea.removeFocusListener(this);
        this.m_scrollPane.getViewport().removeFocusListener(this);
        this.m_splitPane = null;
        this.m_scrollPane = null;
        this.m_textArea = null;
        super.cleanUp();
    }

    public JComponent getComponent() {
        return this.m_splitPane;
    }

    public void clear(boolean bl) {
        super.clear(bl);
        this.m_textArea.setText("");
    }

    public boolean canDoColumns() {
        return false;
    }

    public boolean canDoCopy() {
        if (this.m_textArea.hasFocus()) {
            this.m_copyText = this.m_textArea.getSelectedText() != null;
            return this.m_copyText;
        }
        this.m_copyText = false;
        return super.canDoCopy();
    }

    public void copy() {
        if (this.m_copyText) {
            this.m_textArea.copy();
            return;
        }
        super.copy();
    }

    public int openEnvironment(DebugFile debugFile, String string, String string2) throws IOException {
        boolean bl = string.length() > 0 && string2.length() > 0;
        int n = debugFile.readInt();
        this.m_fixCount = 0;
        for (int i = 0; i < n; ++i) {
            String string3 = debugFile.readString();
            String string4 = debugFile.readString();
            int n2 = debugFile.readInt();
            String string5 = debugFile.readString();
            String string6 = debugFile.readString();
            int n3 = debugFile.readInt();
            int n4 = debugFile.readInt();
            if (bl && string3.equals(string)) {
                string3 = string2;
            }
            MonitorDescriptor monitorDescriptor = new MonitorDescriptor(n3, string3, string4, n2, string5, string6, n4);
            String string7 = string3.indexOf(32) >= 0 ? "\"" + string3 + "\" " + string4 + " " + n2 + " " + string5 + " " + 0 : string3 + " " + string4 + " " + n2 + " " + string5 + " " + 0;
            monitorDescriptor.setViewId(string7);
            this.m_monitors.add(monitorDescriptor);
            VariableDescriptor variableDescriptor = new VariableDescriptor(monitorDescriptor.getViewId(), monitorDescriptor.getLineNum(), monitorDescriptor.getName(), monitorDescriptor.getName(), monitorDescriptor.getVarType());
            this.insertVariableNode(this.m_root, variableDescriptor, i, true);
            ++this.m_fixCount;
        }
        if (n > 0) {
            this.m_treeModel.reload();
        }
        return n;
    }

    public void variablesAvailable(VariableEvent variableEvent) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(500);
        int n2 = variableEvent.getDescriptorCount();
        if (this.m_fixCount > 0) {
            for (n = 0; n < n2; ++n) {
                VariableDescriptor variableDescriptor = variableEvent.getDescriptorAt(n);
                MonitorDescriptor monitorDescriptor = (MonitorDescriptor)this.m_monitors.get(n);
                if (monitorDescriptor.getViewId().equals(variableDescriptor.getViewId())) continue;
                this.updateVariableNode(variableDescriptor, monitorDescriptor.getViewId());
                monitorDescriptor.setViewId(variableDescriptor.getViewId());
                --this.m_fixCount;
            }
        }
        super.variablesAvailable(variableEvent);
        for (n = 0; n < n2; ++n) {
            this.formatMonitor(stringBuffer, variableEvent.getDescriptorAt(n));
        }
        this.m_textArea.setText(stringBuffer.toString());
    }

    public void monitorCreated(VariableEvent variableEvent) {
        super.monitorCreated(variableEvent);
        this.formatMonitors();
    }

    private void formatMonitors() {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = this.m_root.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_root.getChildAt(i);
            VariableDescriptor variableDescriptor = (VariableDescriptor)defaultMutableTreeNode.getUserObject();
            this.formatMonitor(stringBuffer, variableDescriptor);
        }
        this.m_textArea.setText(stringBuffer.toString());
    }

    private void formatMonitor(StringBuffer stringBuffer, VariableDescriptor variableDescriptor) {
        String string = variableDescriptor.getBounds().trim();
        int n = string.length();
        int n2 = stringBuffer.length();
        if (n > 0) {
            if (string.length() > 100) {
                if (n2 > 1 && stringBuffer.charAt(n2 - 1) == '\n' && stringBuffer.charAt(n2 - 2) != '\n') {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(string);
                if (string.charAt(n - 1) != '\n') {
                    stringBuffer.append('\n');
                }
                stringBuffer.append('\n');
            } else {
                stringBuffer.append(string);
                if (string.charAt(n - 1) != '\n') {
                    stringBuffer.append('\n');
                }
            }
        }
    }

    public class MonitorText
    extends JTextArea {
        public MonitorText() {
            this.setEditable(false);
            this.setLineWrap(true);
        }

        public void clear() {
            this.setText("");
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isManagingFocus() {
            return false;
        }

        public void updateUI() {
            super.updateUI();
            this.setFont(SettingsManager.getFixedPitchFont());
        }
    }
}

