/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.unix.packet.UnixPacket;
import java.io.IOException;

public class UnixSyncSourcePacket
extends UnixPacket
implements DebugConstants {
    private String m_fromViewId;
    private int m_fromLineNum;
    private String m_toViewId;
    private int m_toLineNum;
    private ISeriesMessage m_msgObj;

    public UnixSyncSourcePacket() {
        super(3009);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_fromViewId = null;
        this.m_toViewId = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_fromViewId = commLink.readString();
        this.m_fromLineNum = commLink.readInt();
        this.m_toViewId = commLink.readString();
        this.m_toLineNum = commLink.readInt();
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        this.m_ctxt.retractClock();
        if (this.m_msgObj == null) {
            Object object;
            DebugSource debugSource = this.m_ctxt.getDesktop().getActiveSource();
            DebugSource debugSource2 = this.m_ctxt.getDisassembly();
            DebugSource debugSource3 = null;
            if (debugSource != null) {
                object = debugSource.getViewId();
                if (((String)object).equals(this.m_fromViewId)) {
                    debugSource3 = debugSource2;
                    if (!debugSource2.getViewId().equals(this.m_toViewId)) {
                        debugSource2.setViewId(this.m_toViewId);
                    }
                } else if (((String)object).equals(this.m_toViewId)) {
                    debugSource3 = debugSource;
                } else {
                    debugSource3 = this.m_ctxt.getDesktop().getSource(this.m_toViewId);
                    if (debugSource3 != null) {
                        this.m_ctxt.getDesktop().activateSource(debugSource3, -1);
                    }
                }
            }
            if (debugSource3 != null) {
                if (debugSource3.getTotalLineCount() > 0 && (debugSource3.isFullSource() || debugSource3.containsLineNum(this.m_toLineNum))) {
                    debugSource3.gotoLine(this.m_toLineNum);
                } else {
                    object = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                    ((SourceViewManager)object).requestSourceViewLineNum(this.m_toViewId, this.m_toLineNum);
                }
            } else {
                object = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                ((SourceViewManager)object).requestSourceViewLineNum(this.m_toViewId, this.m_toLineNum);
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }
}

