/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.register.RegisterDefinition;
import com.ibm.iseries.debug.register.RegisterDescriptor;
import com.ibm.iseries.debug.register.RegisterSet;
import java.util.HashMap;

public class UnixRegisterSet
implements RegisterSet,
DebugConstants {
    public static final int GPR = 0;
    public static final int FPR = 32;
    public static final int IAR = 64;
    public static final int MSR = 65;
    public static final int CR = 66;
    public static final int LR = 67;
    public static final int CTR = 68;
    public static final int XER = 69;
    public static final int MQ = 70;
    public static final int FPSCR = 71;
    public static final int FPSCRX = 72;
    public static final int CR_LT = 73;
    public static final int CR_GT = 74;
    public static final int CR_EQ = 75;
    public static final int CR_SO = 76;
    public static final int CR_FX = 77;
    public static final int CR_FEX = 78;
    public static final int CR_VX = 79;
    public static final int CR_OX = 80;
    public static final int MSR_SF = 81;
    public static final int MSR_TA = 82;
    public static final int MSR_MXA = 83;
    public static final int MSR_MXE = 84;
    public static final int MSR_C2 = 85;
    public static final int MSR_POW = 86;
    public static final int MSR_ILE = 87;
    public static final int MSR_EE = 88;
    public static final int MSR_PR = 89;
    public static final int MSR_FP = 90;
    public static final int MSR_ME = 91;
    public static final int MSR_FE0 = 92;
    public static final int MSR_SE = 93;
    public static final int MSR_BE = 94;
    public static final int MSR_FE1 = 95;
    public static final int MSR_US = 96;
    public static final int MSR_IP = 97;
    public static final int MSR_IR = 98;
    public static final int MSR_DR = 99;
    public static final int MSR_FC = 100;
    public static final int MSR_MM = 101;
    public static final int MSR_RI = 102;
    public static final int MSR_LE = 103;
    public static final int XER_DC = 104;
    public static final int XER_SO = 105;
    public static final int XER_OV = 106;
    public static final int XER_CA = 107;
    public static final int XER_OC = 108;
    public static final int XER_FXCC = 109;
    public static final int XER_LT = 110;
    public static final int XER_GT = 111;
    public static final int XER_EQ = 112;
    public static final int XER_IC = 113;
    public static final int XER_DS = 114;
    public static final int XER_T02 = 115;
    public static final int XER_T07 = 116;
    public static final int XER_TAG = 117;
    public static final int FPSCR_FX = 118;
    public static final int FPSCR_FEX = 119;
    public static final int FPSCR_VX = 120;
    public static final int FPSCR_OX = 121;
    public static final int FPSCR_UX = 122;
    public static final int FPSCR_ZX = 123;
    public static final int FPSCR_XX = 124;
    public static final int FPSCR_VXSNAN = 125;
    public static final int FPSCR_VXISI = 126;
    public static final int FPSCR_VXIDI = 127;
    public static final int FPSCR_VXZDZ = 128;
    public static final int FPSCR_VXIMZ = 129;
    public static final int FPSCR_VXVC = 130;
    public static final int FPSCR_FR = 131;
    public static final int FPSCR_FI = 132;
    public static final int FPSCR_FPFR = 133;
    public static final int FPSCR_C = 134;
    public static final int FPSCR_FPCC = 135;
    public static final int FPSCR_FLORLT = 136;
    public static final int FPSCR_FGORGT = 137;
    public static final int FPSCR_FEOREQ = 138;
    public static final int FPSCR_FUORQU = 139;
    public static final int FPSCR_VXSOFT = 140;
    public static final int FPSCR_VXSQRT = 141;
    public static final int FPSCR_VXCVI = 142;
    public static final int FPSCR_VE = 143;
    public static final int FPSCR_OE = 144;
    public static final int FPSCR_UE = 145;
    public static final int FPSCR_ZE = 146;
    public static final int FPSCR_XE = 147;
    public static final int FPSCR_NI = 148;
    public static final int FPSCR_RN = 149;
    public static final int BASE_REG_COUNT = 73;
    public static final int CHILD_REG_COUNT = 77;
    public static final int TOTAL_REG_COUNT = 150;
    private RegisterDefinition[] m_regDefinitions = new RegisterDefinition[150];
    private RegisterDescriptor[] m_regDescriptors = new RegisterDescriptor[73];
    private HashMap m_regNameToDef = new HashMap();
    private int m_addrSizeInBits;

    public UnixRegisterSet(int n) {
        this.m_addrSizeInBits = n;
        this.configRegs();
    }

    public void cleanUp() {
        for (int i = 0; i < 150; ++i) {
            this.m_regDefinitions[i] = null;
            if (i >= 73) continue;
            this.m_regDescriptors[i] = null;
        }
        this.m_regNameToDef.clear();
        this.m_regNameToDef = null;
        this.m_regDefinitions = null;
        this.m_regDescriptors = null;
    }

    public int getCount() {
        return 73;
    }

    public RegisterDefinition getDefinition(int n) {
        return this.m_regDefinitions[n];
    }

    public RegisterDefinition getDefinition(String string) {
        return (RegisterDefinition)this.m_regNameToDef.get(string);
    }

    public RegisterDescriptor getDescriptor(int n) {
        if (n < 73) {
            return this.m_regDescriptors[n];
        }
        RegisterDefinition registerDefinition = this.m_regDefinitions[n];
        RegisterDescriptor registerDescriptor = this.m_regDescriptors[registerDefinition.getParentId()];
        String string = registerDefinition.isBitRegister() ? registerDescriptor.getChildBitValue(registerDefinition.getStartBit(), registerDefinition.getEndBit()) : registerDescriptor.getChildHexValue(registerDefinition.getStartBit(), registerDefinition.getEndBit(), registerDefinition.getDisplayMode());
        return new RegisterDescriptor(n, string);
    }

    public void setDescriptor(RegisterDescriptor registerDescriptor) {
        int n = registerDescriptor.getId();
        if (n < 73) {
            this.m_regDescriptors[n] = registerDescriptor;
            return;
        }
        RegisterDefinition registerDefinition = this.m_regDefinitions[registerDescriptor.getId()];
        RegisterDescriptor registerDescriptor2 = this.m_regDescriptors[registerDefinition.getParentId()];
        if (registerDefinition.isBitRegister()) {
            registerDescriptor2.setChildBitValue(registerDescriptor.getValue(), registerDefinition.getStartBit(), registerDefinition.getEndBit());
        } else {
            registerDescriptor2.setChildHexValue(registerDescriptor.getValue(), registerDefinition.getStartBit(), registerDefinition.getEndBit(), registerDefinition.getDisplayMode());
        }
    }

    public String getRegisterName(int n) {
        RegisterDefinition registerDefinition = this.m_regDefinitions[n];
        if (registerDefinition.isChildRegister()) {
            return this.m_regDefinitions[registerDefinition.getParentId()].getLabel() + "_" + registerDefinition.getLabel();
        }
        if (n >= 0 && n < 32) {
            return "GPR[" + (n - 0) + "]";
        }
        if (n >= 32 && n < 64) {
            return "FPR[" + (n - 32) + "]";
        }
        return registerDefinition.getLabel();
    }

    protected void configRegs() {
        int n;
        for (n = 0; n < 32; ++n) {
            String string = String.valueOf(n);
            this.m_regDefinitions[0 + n] = new RegisterDefinition(0 + n, string, this.m_addrSizeInBits, 0, false);
            this.m_regDefinitions[32 + n] = new RegisterDefinition(32 + n, string, 64, 0, false);
        }
        this.m_regDefinitions[64] = new RegisterDefinition(64, "IAR", this.m_addrSizeInBits, 0, false);
        this.m_regDefinitions[65] = new RegisterDefinition(65, "MSR", 64, 0, true);
        this.m_regDefinitions[66] = new RegisterDefinition(66, "CR", 32, 0, true);
        this.m_regDefinitions[67] = new RegisterDefinition(67, "LR", this.m_addrSizeInBits, 0, false);
        this.m_regDefinitions[68] = new RegisterDefinition(68, "CTR", this.m_addrSizeInBits, 0, false);
        this.m_regDefinitions[69] = new RegisterDefinition(69, "XER", 64, 0, true);
        this.m_regDefinitions[71] = new RegisterDefinition(71, "FPSCR", 32, 0, true);
        this.m_regDefinitions[72] = new RegisterDefinition(72, "FPSCRX", 32, 0, false);
        this.m_regDefinitions[70] = new RegisterDefinition(70, "MQ", 32, 0, false);
        this.m_regDefinitions[73] = new RegisterDefinition(73, 66, "LT", 0, 0, 3, 0);
        this.m_regDefinitions[74] = new RegisterDefinition(74, 66, "GT", 1, 1, 3, 0);
        this.m_regDefinitions[75] = new RegisterDefinition(75, 66, "EQ", 2, 2, 3, 0);
        this.m_regDefinitions[76] = new RegisterDefinition(76, 66, "SO", 3, 3, 3, 0);
        this.m_regDefinitions[77] = new RegisterDefinition(77, 66, "FX", 4, 4, 3, 0);
        this.m_regDefinitions[78] = new RegisterDefinition(78, 66, "FEX", 5, 5, 3, 0);
        this.m_regDefinitions[79] = new RegisterDefinition(79, 66, "VX", 6, 6, 3, 0);
        this.m_regDefinitions[80] = new RegisterDefinition(80, 66, "OX", 7, 7, 3, 0);
        this.m_regDefinitions[81] = new RegisterDefinition(81, 65, "SF", 0, 0, 3, 0);
        this.m_regDefinitions[82] = new RegisterDefinition(82, 65, "TA", 1, 1, 3, 0);
        this.m_regDefinitions[83] = new RegisterDefinition(83, 65, "MXA", 30, 30, 3, 0);
        this.m_regDefinitions[84] = new RegisterDefinition(84, 65, "MXE", 31, 31, 3, 0);
        this.m_regDefinitions[85] = new RegisterDefinition(85, 65, "C2", 33, 33, 3, 0);
        this.m_regDefinitions[86] = new RegisterDefinition(86, 65, "POW", 45, 45, 3, 0);
        this.m_regDefinitions[87] = new RegisterDefinition(87, 65, "ILE", 47, 47, 3, 0);
        this.m_regDefinitions[88] = new RegisterDefinition(88, 65, "EE", 48, 48, 3, 0);
        this.m_regDefinitions[89] = new RegisterDefinition(89, 65, "PR", 49, 49, 3, 0);
        this.m_regDefinitions[90] = new RegisterDefinition(90, 65, "FP", 50, 50, 3, 0);
        this.m_regDefinitions[91] = new RegisterDefinition(91, 65, "ME", 51, 51, 3, 0);
        this.m_regDefinitions[92] = new RegisterDefinition(92, 65, "FE0", 52, 52, 3, 0);
        this.m_regDefinitions[93] = new RegisterDefinition(93, 65, "SE", 53, 53, 3, 0);
        this.m_regDefinitions[94] = new RegisterDefinition(94, 65, "BE", 54, 54, 3, 0);
        this.m_regDefinitions[95] = new RegisterDefinition(95, 65, "FE1", 55, 55, 3, 0);
        this.m_regDefinitions[96] = new RegisterDefinition(96, 65, "US", 56, 56, 3, 0);
        this.m_regDefinitions[97] = new RegisterDefinition(97, 65, "IP", 57, 57, 3, 0);
        this.m_regDefinitions[98] = new RegisterDefinition(98, 65, "IR", 58, 58, 3, 0);
        this.m_regDefinitions[99] = new RegisterDefinition(99, 65, "DR", 59, 59, 3, 0);
        this.m_regDefinitions[100] = new RegisterDefinition(100, 65, "FC", 60, 60, 3, 0);
        this.m_regDefinitions[101] = new RegisterDefinition(101, 65, "MM", 61, 61, 3, 0);
        this.m_regDefinitions[102] = new RegisterDefinition(102, 65, "RI", 62, 62, 3, 0);
        this.m_regDefinitions[103] = new RegisterDefinition(103, 65, "LE", 63, 63, 3, 0);
        this.m_regDefinitions[104] = new RegisterDefinition(104, 69, "DC", 16, 31, 0, 0);
        this.m_regDefinitions[105] = new RegisterDefinition(105, 69, "SO", 32, 32, 3, 0);
        this.m_regDefinitions[106] = new RegisterDefinition(106, 69, "OV", 33, 33, 3, 0);
        this.m_regDefinitions[107] = new RegisterDefinition(107, 69, "CA", 34, 34, 3, 0);
        this.m_regDefinitions[108] = new RegisterDefinition(108, 69, "OC", 35, 35, 3, 0);
        this.m_regDefinitions[109] = new RegisterDefinition(109, 69, "FXCC", 36, 39, 0, 0);
        this.m_regDefinitions[110] = new RegisterDefinition(110, 69, "LT", 36, 36, 3, 0);
        this.m_regDefinitions[111] = new RegisterDefinition(111, 69, "GT", 37, 37, 3, 0);
        this.m_regDefinitions[112] = new RegisterDefinition(112, 69, "EQ", 38, 38, 3, 0);
        this.m_regDefinitions[113] = new RegisterDefinition(113, 69, "IC", 39, 39, 3, 0);
        this.m_regDefinitions[114] = new RegisterDefinition(114, 69, "DS", 40, 40, 3, 0);
        this.m_regDefinitions[115] = new RegisterDefinition(115, 69, "T02", 41, 41, 3, 0);
        this.m_regDefinitions[116] = new RegisterDefinition(116, 69, "T07", 42, 42, 3, 0);
        this.m_regDefinitions[117] = new RegisterDefinition(117, 69, "TAG", 43, 43, 3, 0);
        this.m_regDefinitions[118] = new RegisterDefinition(118, 71, "FX", 0, 0, 3, 0);
        this.m_regDefinitions[119] = new RegisterDefinition(119, 71, "FEX", 1, 1, 3, 0);
        this.m_regDefinitions[120] = new RegisterDefinition(120, 71, "VX", 2, 2, 3, 0);
        this.m_regDefinitions[121] = new RegisterDefinition(121, 71, "OX", 3, 3, 3, 0);
        this.m_regDefinitions[122] = new RegisterDefinition(122, 71, "UX", 4, 4, 3, 0);
        this.m_regDefinitions[123] = new RegisterDefinition(123, 71, "ZX", 5, 5, 3, 0);
        this.m_regDefinitions[124] = new RegisterDefinition(124, 71, "XX", 6, 6, 3, 0);
        this.m_regDefinitions[125] = new RegisterDefinition(125, 71, "VXSNAN", 7, 7, 3, 0);
        this.m_regDefinitions[126] = new RegisterDefinition(126, 71, "VXISI", 8, 8, 3, 0);
        this.m_regDefinitions[127] = new RegisterDefinition(127, 71, "VXIDI", 9, 9, 3, 0);
        this.m_regDefinitions[128] = new RegisterDefinition(128, 71, "VXZDZ", 10, 10, 3, 0);
        this.m_regDefinitions[129] = new RegisterDefinition(129, 71, "VXIMZ", 11, 11, 3, 0);
        this.m_regDefinitions[130] = new RegisterDefinition(130, 71, "VXVC", 12, 12, 3, 0);
        this.m_regDefinitions[131] = new RegisterDefinition(131, 71, "FR", 13, 13, 3, 0);
        this.m_regDefinitions[132] = new RegisterDefinition(132, 71, "FI", 14, 14, 3, 0);
        this.m_regDefinitions[133] = new RegisterDefinition(133, 71, "FPFR", 15, 19, 1, 0);
        this.m_regDefinitions[134] = new RegisterDefinition(134, 71, "C", 15, 15, 3, 0);
        this.m_regDefinitions[135] = new RegisterDefinition(135, 71, "FPCC", 16, 19, 0, 0);
        this.m_regDefinitions[136] = new RegisterDefinition(136, 71, "FLOR<", 16, 16, 3, 0);
        this.m_regDefinitions[137] = new RegisterDefinition(137, 71, "FGOR>", 17, 17, 3, 0);
        this.m_regDefinitions[138] = new RegisterDefinition(138, 71, "FEOR=", 18, 18, 3, 0);
        this.m_regDefinitions[139] = new RegisterDefinition(139, 71, "FUOR?", 19, 19, 3, 0);
        this.m_regDefinitions[140] = new RegisterDefinition(140, 71, "VXSOFT", 21, 21, 3, 0);
        this.m_regDefinitions[141] = new RegisterDefinition(141, 71, "VXSQRT", 22, 22, 3, 0);
        this.m_regDefinitions[142] = new RegisterDefinition(142, 71, "VXCVI", 23, 23, 3, 0);
        this.m_regDefinitions[143] = new RegisterDefinition(143, 71, "VE", 24, 24, 3, 0);
        this.m_regDefinitions[144] = new RegisterDefinition(144, 71, "OE", 25, 25, 3, 0);
        this.m_regDefinitions[145] = new RegisterDefinition(145, 71, "UE", 26, 26, 3, 0);
        this.m_regDefinitions[146] = new RegisterDefinition(146, 71, "ZE", 27, 27, 3, 0);
        this.m_regDefinitions[147] = new RegisterDefinition(147, 71, "XE", 28, 28, 3, 0);
        this.m_regDefinitions[148] = new RegisterDefinition(148, 71, "NI", 29, 29, 3, 0);
        this.m_regDefinitions[149] = new RegisterDefinition(149, 71, "RN", 30, 31, 3, 0);
        for (n = 0; n < 150; ++n) {
            this.m_regNameToDef.put(this.getRegisterName(n), this.m_regDefinitions[n]);
        }
    }
}

