/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class DebugFile {
    private DataInputStream m_in;
    private DataOutputStream m_out;
    private double m_version;
    private boolean m_unicode;

    public DebugFile(File file) throws FileNotFoundException, IOException {
        this.m_in = new DataInputStream(new FileInputStream(file));
        this.m_version = this.readDouble();
        this.m_unicode = this.m_version >= 5.10002 && this.m_version < 5.20001 || this.m_version >= 5.20002;
    }

    public DebugFile(File file, double d) throws FileNotFoundException, IOException {
        this.m_out = new DataOutputStream(new FileOutputStream(file));
        this.m_version = d;
        this.writeDouble(this.m_version);
        this.m_unicode = this.m_version >= 5.10002 && this.m_version < 5.20001 || this.m_version >= 5.20002;
    }

    public double getVersion() {
        return this.m_version;
    }

    public void setUnicode(boolean bl) {
        this.m_unicode = bl;
    }

    public void close() {
        try {
            if (this.m_in != null) {
                this.m_in.close();
                this.m_in = null;
            }
            if (this.m_out != null) {
                this.m_out.close();
                this.m_out = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int readBytesAvailable() {
        int n = 0;
        try {
            n = this.m_in.available();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public String readString() throws IOException {
        if (this.m_unicode) {
            int n = this.m_in.readInt();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.m_in.readChar());
            }
            return stringBuffer.toString();
        }
        int n = this.m_in.readInt();
        byte[] byArray = new byte[n];
        this.m_in.read(byArray);
        return new String(byArray);
    }

    public short readShort() throws IOException {
        return this.m_in.readShort();
    }

    public int readInt() throws IOException {
        return this.m_in.readInt();
    }

    public long readLong() throws IOException {
        return this.m_in.readLong();
    }

    public double readDouble() throws IOException {
        return this.m_in.readDouble();
    }

    public boolean readBoolean() throws IOException {
        return this.m_in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.m_in.readByte();
    }

    public byte[] readBytes() throws IOException {
        int n = this.m_in.readInt();
        byte[] byArray = new byte[n];
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.m_in.read(byArray, n3, n - n2);
                n2 += n4;
                n3 += n4;
            }
        }
        return byArray;
    }

    public void readBytes(byte[] byArray) throws IOException {
        int n = this.m_in.readInt();
        if (n == byArray.length) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.m_in.read(byArray, n3, n - n2);
                n2 += n4;
                n3 += n4;
            }
        }
    }

    public void readRawBytes(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.m_in.read(byArray, n3, n - n2);
                n2 += n4;
                n3 += n4;
            }
        }
    }

    public void readRawBytes(byte[] byArray, int n) throws IOException {
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.m_in.read(byArray, n3, n - n2);
                n2 += n4;
                n3 += n4;
            }
        }
    }

    public void writeString(String string) throws IOException {
        this.m_out.writeInt(string.length());
        if (this.m_unicode) {
            this.m_out.writeChars(string);
        } else {
            this.m_out.writeBytes(string);
        }
    }

    public void writeShort(short s) throws IOException {
        this.m_out.writeShort(s);
    }

    public void writeInt(int n) throws IOException {
        this.m_out.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.m_out.writeLong(l);
    }

    public void writeDouble(double d) throws IOException {
        this.m_out.writeDouble(d);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.m_out.writeBoolean(bl);
    }

    public void writeByte(byte by) throws IOException {
        this.m_out.writeByte(by);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.m_out.writeInt(byArray.length);
        this.m_out.write(byArray, 0, byArray.length);
    }

    public void writeRawBytes(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.m_out.write(byArray, 0, byArray.length);
        }
    }

    public void writeRawBytes(byte[] byArray, int n) throws IOException {
        if (n > 0) {
            this.m_out.write(byArray, 0, n);
        }
    }
}

