/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.source;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AutoEvalTooltip {
    public static final int DEFAULT_SHOW_MS = 250;
    public static final int DEFAULT_HIDE_MS = 4000;
    public static int SHOW_MS = 250;
    public static int HIDE_MS = 4000;
    private static AutoEvalTooltip s_instance = new AutoEvalTooltip();
    private TooltipPopup m_tipWindow;
    private JToolTip m_tip;
    private TooltipTimer m_timer = new TooltipTimer();

    public static AutoEvalTooltip instance() {
        return s_instance;
    }

    public static void setShowTimeInMilliseconds(int n) {
        SHOW_MS = n;
    }

    public static void setHideTimeInMilliseconds(int n) {
        if (n != HIDE_MS) {
            HIDE_MS = n;
            AutoEvalTooltip.s_instance.m_timer.m_tm.setDelay(HIDE_MS);
        }
    }

    private AutoEvalTooltip() {
    }

    public boolean isTooltipVisible() {
        return this.m_tipWindow != null;
    }

    public void showTooltip(JComponent jComponent, int n, int n2, String string) {
        if (jComponent == null || !jComponent.isShowing()) {
            return;
        }
        Point point = jComponent.getLocationOnScreen();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point2 = new Point();
        boolean bl = jComponent.getComponentOrientation().isLeftToRight();
        this.hideTooltip();
        this.m_tip = jComponent.createToolTip();
        this.m_tip.setTipText(string);
        Dimension dimension2 = this.m_tip.getPreferredSize();
        this.m_tipWindow = new TooltipPopup(this.m_tip, dimension2);
        Rectangle rectangle = jComponent.getVisibleRect();
        if (n2 + dimension2.height + 20 > rectangle.y + rectangle.height) {
            n2 -= dimension2.height + 20;
        }
        point2.x = point.x + n;
        point2.y = point.y + n2 + 20;
        if (!bl && point2.x - dimension2.width >= 0) {
            point2.x -= dimension2.width;
        }
        if (point2.x + dimension2.width > dimension.width) {
            point2.x -= dimension2.width;
        }
        if (point2.y + dimension2.height > dimension.height) {
            point2.y -= dimension2.height + 20;
        }
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setBounds(point2.x, point2.y, this.m_tipWindow.getBounds().width, this.m_tipWindow.getBounds().height);
        int n3 = this.getPopupFitHeight(rectangle2, jComponent);
        int n4 = this.getPopupFitWidth(rectangle2, jComponent);
        if (n3 > 0) {
            point2.y -= n3;
        }
        if (n4 > 0) {
            point2.x -= n4;
        }
        this.m_tipWindow.showTip(jComponent, point2.x, point2.y);
        this.m_timer.m_tm.restart();
    }

    public void hideTooltip() {
        if (this.m_tipWindow != null) {
            this.m_timer.m_tm.stop();
            this.m_tipWindow.hideTip();
            this.m_tip.getUI().uninstallUI(this.m_tip);
            this.m_tip = null;
            this.m_tipWindow = null;
        }
    }

    private int getHeightAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return 0;
        }
        return rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height) + 5;
    }

    private int getWidthAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            return 0;
        }
        return rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width) + 5;
    }

    private int getPopupFitHeight(Rectangle rectangle, Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            return this.getHeightAdjust(container.getBounds(), rectangle);
        }
        return 0;
    }

    private int getPopupFitWidth(Rectangle rectangle, Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            return this.getWidthAdjust(container.getBounds(), rectangle);
        }
        return 0;
    }

    private class TooltipTimer
    implements ActionListener {
        public Timer m_tm = new Timer(HIDE_MS, this);

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_tm.stop();
            AutoEvalTooltip.this.hideTooltip();
        }
    }

    private class TooltipPopup
    extends JPanel {
        public TooltipPopup(JComponent jComponent, Dimension dimension) {
            this.setLayout(new BorderLayout());
            this.setDoubleBuffered(true);
            this.setOpaque(true);
            this.add((Component)jComponent, "Center");
            this.setSize(dimension);
        }

        public void showTip(JComponent jComponent, int n, int n2) {
            Point point = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point, jComponent.getRootPane().getLayeredPane());
            this.setBounds(point.x, point.y, this.getSize().width, this.getSize().height);
            jComponent.getRootPane().getLayeredPane().add(this, JLayeredPane.POPUP_LAYER, 0);
        }

        public void hideTip() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

