/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.register;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.register.RegisterDefinition;
import com.ibm.iseries.debug.register.RegisterDescriptor;
import com.ibm.iseries.debug.register.RegisterEditListener;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.ColorUIResource;

public class RegisterControl
extends JTextField
implements DebugConstants,
CaretListener,
MouseListener {
    private static Color s_fg = new Color(UIManager.getColor("TextField.foreground").getRGB());
    private static Color s_bg = new Color(UIManager.getColor("TextField.background").getRGB());
    private static Color s_caret = new Color(UIManager.getColor("TextField.caretForeground").getRGB());
    private RegisterDefinition m_definition;
    private String m_value;
    private int m_cursorDirection;
    private boolean m_editing;
    private RegisterEditListener m_listener;
    private boolean m_changed;
    private Color m_changedFg;
    private Color m_changedBg;

    public static Font getRegFont() {
        return SettingsManager.getFixedPitchFont();
    }

    private static int getFormattedLength(RegisterDefinition registerDefinition) {
        int n = registerDefinition.isBitRegister() ? registerDefinition.getSizeInBits() : registerDefinition.getSizeInNibbles();
        int n2 = registerDefinition.getDisplayGap();
        if (n2 > 0 && n2 < n) {
            ++n;
        }
        return ++n;
    }

    private static int getInitialValue(RegisterDefinition registerDefinition) {
        int n = registerDefinition.isBitRegister() ? registerDefinition.getSizeInBits() : registerDefinition.getSizeInNibbles();
        int n2 = registerDefinition.getDisplayGap();
        if (n2 > 0 && n2 < n) {
            ++n;
        }
        return ++n;
    }

    public RegisterControl(RegisterDefinition registerDefinition) {
        super(RegisterControl.getFormattedLength(registerDefinition));
        this.m_definition = registerDefinition;
        this.m_cursorDirection = 1;
        this.m_changedFg = s_fg;
        this.m_changedBg = s_bg;
        this.setZero();
        this.addCaretListener(this);
        this.addMouseListener(this);
    }

    public void cleanUp() {
        this.m_definition = null;
        this.m_value = null;
        this.m_listener = null;
        this.m_changedFg = null;
        this.m_changedBg = null;
    }

    public JComponent getComponent() {
        return this;
    }

    public int getId() {
        return this.m_definition.getId();
    }

    public RegisterDefinition getDefinition() {
        return this.m_definition;
    }

    public RegisterDescriptor getDescriptor() {
        return new RegisterDescriptor(this.m_definition.getId(), this.getValue());
    }

    public void setDescriptor(RegisterDescriptor registerDescriptor) {
        this.setValue(registerDescriptor.getValue());
    }

    public void setZero() {
        if (this.m_value != null) {
            if (this.m_definition.isBitRegister()) {
                this.setValue("0000000000000000000000000000000000000000000000000000000000000000".substring(0, this.m_definition.getSizeInBits()));
            } else {
                this.setValue("0000000000000000000000000000000000000000000000000000000000000000".substring(0, this.m_definition.getSizeInNibbles()));
            }
        } else if (this.m_definition.isBitRegister()) {
            this.m_value = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, this.m_definition.getSizeInBits());
            this.setText(this.m_value);
        } else {
            this.m_value = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, this.m_definition.getSizeInNibbles());
            this.setText(this.m_value);
        }
    }

    public void setValue(String string) {
        if (!this.m_value.equals(string)) {
            this.m_value = string;
            this.m_changed = true;
            this.setText(this.m_value);
            this.setBackground(this.m_changedBg);
            this.setForeground(this.m_changedFg);
            this.setCaretColor(this.m_changedFg);
        } else {
            if (this.m_changed) {
                this.setBackground(s_bg);
                this.setForeground(s_fg);
                this.setCaretColor(s_caret);
            }
            this.m_changed = false;
        }
    }

    public String getValue() {
        String string = this.getText();
        int n = string.indexOf(32);
        if (n > 0) {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    protected String formatValue(String string) {
        int n = this.m_definition.getDisplayGap();
        if (n > 0 && n < string.length()) {
            return string.substring(0, n) + " " + string.substring(n);
        }
        return string;
    }

    public void setEditListener(RegisterEditListener registerEditListener) {
        this.m_listener = registerEditListener;
    }

    public boolean isEditing() {
        return this.m_editing;
    }

    protected void setEditColors(boolean bl) {
        if (bl) {
            this.setBackground(s_fg);
            this.setForeground(s_bg);
            this.setCaretColor(s_bg);
        } else {
            this.setBackground(s_bg);
            this.setForeground(s_fg);
            this.setCaretColor(s_caret);
        }
    }

    public void initiateEdit() {
        if (!this.m_editing) {
            this.m_editing = true;
            this.setEditColors(true);
            if (this.m_listener != null) {
                this.m_listener.registerEditInitiated(this);
            }
        }
    }

    public void acceptEdit() {
        if (this.m_editing) {
            this.m_editing = false;
            this.setEditColors(false);
            if (this.m_listener != null) {
                this.m_listener.registerEditCommitted(this);
            }
        }
    }

    public void cancelEdit() {
        if (this.m_editing) {
            this.m_editing = false;
            this.setEditColors(false);
            this.setText(this.m_value);
            if (this.m_listener != null) {
                this.m_listener.registerEditAborted(this);
            }
        }
    }

    public void setDynamicColors(ColorUIResource colorUIResource, ColorUIResource colorUIResource2) {
        this.m_changedFg = colorUIResource;
        this.m_changedBg = colorUIResource2;
    }

    protected boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public void setText(String string) {
        super.setText(this.formatValue(string));
        this.setCaretPosition(0);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = keyEvent.getID() == 401;
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 37: 
            case 226: {
                if (bl) {
                    this.m_cursorDirection = -1;
                    int n = this.getCaretPosition();
                    if (n == 0) {
                        this.setCaretPosition(this.getDocument().getLength() - 1);
                    } else {
                        this.setCaretPosition(n - 1);
                    }
                }
                keyEvent.consume();
                break;
            }
            case 39: 
            case 227: {
                if (bl) {
                    this.m_cursorDirection = 1;
                    int n = this.getCaretPosition();
                    if (n == this.getDocument().getLength() - 1) {
                        this.setCaretPosition(0);
                    } else {
                        this.setCaretPosition(n + 1);
                    }
                }
                keyEvent.consume();
                break;
            }
            case 36: {
                if (bl) {
                    this.setCaretPosition(0);
                }
                keyEvent.consume();
                break;
            }
            case 35: {
                if (bl) {
                    this.setCaretPosition(this.getDocument().getLength() - 1);
                }
                keyEvent.consume();
                break;
            }
            case 127: {
                if (bl) {
                    this.getToolkit().beep();
                }
                keyEvent.consume();
                break;
            }
            case 27: {
                if (bl && this.m_editing) {
                    this.cancelEdit();
                }
                keyEvent.consume();
                break;
            }
            case 10: {
                if (bl && this.m_editing) {
                    this.acceptEdit();
                }
                keyEvent.consume();
                break;
            }
            default: {
                this.m_cursorDirection = 1;
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyChar() == '\b') {
            return true;
        }
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
    }

    public void cut() {
    }

    public void replaceSelection(String string) {
        int n = this.getCaretPosition();
        int n2 = string.length();
        if (n2 == 0 || n >= this.getDocument().getLength()) {
            this.getToolkit().beep();
            return;
        }
        string = this.m_definition.isBitRegister() ? Util.validateBitData(string) : Util.validateHexData(string);
        if (string == null) {
            return;
        }
        n2 = string.length();
        if (this.hasSelection()) {
            this.setCaretPosition(this.getSelectionEnd());
            n = this.getCaretPosition();
        }
        try {
            if (n2 == 1) {
                this.getDocument().remove(n, n2);
                this.getDocument().insertString(n, string, null);
            } else {
                String string2 = this.getValue();
                StringBuffer stringBuffer = new StringBuffer(string2);
                int n3 = this.m_definition.getDisplayGap();
                if (n3 > 0 && n3 < string2.length() && n > n3) {
                    --n;
                }
                if (n + n2 > string2.length()) {
                    n2 = string2.length() - n;
                    string = string.substring(0, n2);
                }
                stringBuffer.replace(n, n + n2, string);
                this.setValue(stringBuffer.toString());
            }
            if (!this.m_editing) {
                this.initiateEdit();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(RegisterControl.getRegFont());
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public void caretUpdate(CaretEvent caretEvent) {
        try {
            int n = this.getDocument().getLength();
            int n2 = caretEvent.getDot();
            if (n > 0 && !this.hasSelection()) {
                if (n2 < n) {
                    String string = this.getText(n2, 1);
                    if (string.length() > 0 && string.charAt(0) == ' ') {
                        this.setCaretPosition(n2 + this.m_cursorDirection);
                    }
                } else {
                    this.setCaretPosition(0);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.m_definition != null && this.m_definition.isBitRegister() && this.m_definition.getSizeInBits() == 1) {
            String string = this.getText();
            char c = string.charAt(0);
            switch (c) {
                case '0': {
                    this.setText("1");
                    break;
                }
                case '1': {
                    this.setText("0");
                    break;
                }
                default: {
                    return;
                }
            }
            this.initiateEdit();
            this.acceptEdit();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.m_definition != null && this.m_definition.getSizeInBits() > 1) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }
}

