/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.RegisterEvent;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.listener.RegisterListener;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.manager.RegisterManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.register.RegisterControl;
import com.ibm.iseries.debug.register.RegisterDefinition;
import com.ibm.iseries.debug.register.RegisterDescriptor;
import com.ibm.iseries.debug.register.RegisterEditListener;
import com.ibm.iseries.debug.register.RegisterSet;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RegistersPanel
extends TabPanel
implements ContextListener,
RegisterListener,
RegisterEditListener,
SettingsListener,
LAFListener,
MouseListener {
    public static final String KEY = "registers";
    private static final String GIF = "/com/ibm/iseries/debug/dbg075.gif";
    protected static final int BORDER = 5;
    protected static final int X_GAP = 5;
    protected static final int Y_GAP = 3;
    protected SettingsManager m_settingsMgr;
    protected RegisterManager m_regMgr;
    protected JPanel m_panel = new JPanel(null);
    protected TabPanel.TabScrollPane m_scrollPane = new TabPanel.TabScrollPane(this, this.m_panel);
    protected ContextMenu m_contextMenu;
    protected int m_x = 5;
    protected int m_y = 5;
    protected int m_boundsX = 5;
    protected int m_boundsY = 5;
    protected ArrayList m_labels;
    protected HashMap m_regs;
    protected boolean m_regsEnabled = true;

    public RegistersPanel(String string) {
        super(string, MRI.getIcon(0, GIF));
        this.m_panel.addMouseListener(this);
        this.m_panel.addFocusListener(this);
        this.m_labels = new ArrayList();
        this.m_regs = new HashMap();
        Util.setOrientation(this.m_scrollPane);
    }

    protected void lookAndFeelModifications() {
        this.createContextMenu();
    }

    protected void createContextMenu() {
        String string = this.m_ctxt.getConfig().getString("registersContextMenu", null);
        if (string != null) {
            this.m_contextMenu = (ContextMenu)Util.loadObject(string);
            this.m_contextMenu.init(this.getActionGroup());
        }
    }

    protected boolean isConfigured() {
        return this.m_regs.size() > 0;
    }

    protected void configureRegisters() {
    }

    protected void clearRegisters() {
        Iterator iterator = this.m_regs.values().iterator();
        while (iterator.hasNext()) {
            RegisterControl registerControl = (RegisterControl)iterator.next();
            this.cleanUpRegister(registerControl);
        }
        this.m_panel.removeAll();
        this.m_panel.repaint(this.m_panel.getVisibleRect());
        this.m_scrollPane.revalidate();
        this.m_labels.clear();
        this.m_regs.clear();
        this.m_boundsY = 5;
        this.m_boundsX = 5;
        this.m_y = 5;
        this.m_x = 5;
        this.m_panel.setPreferredSize(new Dimension(this.m_boundsX + 5, this.m_boundsY + 5));
    }

    protected void requestRegisters() {
        this.m_regMgr.requestRegisters();
    }

    protected void refreshRegisters() {
        RegisterSet registerSet = this.m_regMgr.getRegisterSet();
        Iterator iterator = this.m_regs.values().iterator();
        while (iterator.hasNext()) {
            RegisterControl registerControl = (RegisterControl)iterator.next();
            RegisterDescriptor registerDescriptor = registerSet.getDescriptor(registerControl.getId());
            if (registerDescriptor == null) continue;
            registerControl.setDescriptor(registerDescriptor);
        }
    }

    protected void enableRegisters(boolean bl) {
        if (bl != this.m_regsEnabled) {
            this.m_regsEnabled = bl;
            Iterator iterator = this.m_regs.values().iterator();
            while (iterator.hasNext()) {
                RegisterControl registerControl = (RegisterControl)iterator.next();
                registerControl.setEnabled(bl);
            }
        }
    }

    protected void setRegistersVisible(boolean bl) {
        JComponent jComponent;
        int n = this.m_labels.size();
        for (int i = 0; i < n; ++i) {
            jComponent = (JLabel)this.m_labels.get(i);
            jComponent.setVisible(bl);
        }
        Iterator iterator = this.m_regs.values().iterator();
        while (iterator.hasNext()) {
            jComponent = (RegisterControl)iterator.next();
            ((RegisterControl)jComponent).getComponent().setVisible(bl);
        }
        if (bl) {
            this.m_panel.setPreferredSize(new Dimension(this.m_boundsX + 5, this.m_boundsY + 5));
        } else {
            this.m_panel.setPreferredSize(new Dimension(5, 5));
        }
        this.m_panel.repaint(this.m_panel.getVisibleRect());
        this.m_scrollPane.revalidate();
    }

    protected RegisterControl getRegister(int n) {
        return (RegisterControl)this.m_regs.get(new Integer(n));
    }

    protected void setUpRegister(RegisterControl registerControl) {
        this.m_regs.put(new Integer(registerControl.getId()), registerControl);
        registerControl.setDynamicColors(this.m_settingsMgr.m_regChangedFg, this.m_settingsMgr.m_regChangedBg);
        registerControl.setEditListener(this);
        registerControl.getComponent().addMouseListener(this);
        registerControl.getComponent().addFocusListener(this);
    }

    protected void cleanUpRegister(RegisterControl registerControl) {
        registerControl.getComponent().removeMouseListener(this);
        registerControl.getComponent().removeFocusListener(this);
        registerControl.cleanUp();
    }

    protected void beginLayout() {
        this.m_y = 5;
        this.m_x = 5;
        this.m_boundsY = 0;
        this.m_boundsX = 0;
    }

    protected void endLayout() {
        this.m_panel.setPreferredSize(new Dimension(this.m_boundsX + 5, this.m_boundsY + 5));
        this.m_panel.repaint(this.m_panel.getVisibleRect());
        this.m_scrollPane.revalidate();
    }

    protected void addColumn(ArrayList arrayList, int n) {
        int n2;
        FontMetrics fontMetrics = this.m_panel.getFontMetrics(RegisterControl.getRegFont());
        int n3 = arrayList.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            RegisterDefinition registerDefinition;
            int n5;
            Object e = arrayList.get(n2);
            if (!(e instanceof RegisterDefinition) || (n5 = fontMetrics.stringWidth((registerDefinition = (RegisterDefinition)e).getLabel())) <= n4) continue;
            n4 = n5;
        }
        n2 = this.m_x + n4 + 5;
        int n6 = this.m_y;
        for (int i = 0; i < n3; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof RegisterDefinition) {
                RegisterDefinition registerDefinition = (RegisterDefinition)e;
                RegisterControl registerControl = new RegisterControl(registerDefinition);
                RegisterLabel registerLabel = new RegisterLabel(registerDefinition.getLabel());
                registerLabel.setHorizontalAlignment(n);
                Dimension dimension = registerControl.getComponent().getPreferredSize();
                registerLabel.setBounds(this.m_x, n6, n4, dimension.height);
                registerControl.getComponent().setBounds(n2, n6, dimension.width, dimension.height);
                this.m_panel.add(registerLabel);
                this.m_panel.add(registerControl.getComponent());
                n6 += dimension.height + 3;
                if (n2 + dimension.width > this.m_boundsX) {
                    this.m_boundsX = n2 + dimension.width;
                }
                this.m_labels.add(registerLabel);
                this.setUpRegister(registerControl);
                continue;
            }
            n6 += 15;
        }
        if (n6 + 3 > this.m_boundsY) {
            this.m_boundsY = n6 + 3;
        }
        this.m_x = this.m_boundsX + 10;
    }

    protected void addRow(ArrayList arrayList, int n) {
        this.m_x = 5;
        this.m_y = this.m_boundsY;
        FontMetrics fontMetrics = this.m_panel.getFontMetrics(RegisterControl.getRegFont());
        int n2 = arrayList.size();
        int n3 = this.m_x;
        int n4 = this.m_y + 3;
        for (int i = 0; i < n2; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof RegisterDefinition) {
                RegisterDefinition registerDefinition = (RegisterDefinition)e;
                RegisterControl registerControl = new RegisterControl(registerDefinition);
                RegisterLabel registerLabel = new RegisterLabel(registerDefinition.getLabel());
                Dimension dimension = registerLabel.getPreferredSize();
                Dimension dimension2 = registerControl.getComponent().getPreferredSize();
                if (n == 1) {
                    if (dimension2.width > dimension.width) {
                        registerLabel.setBounds(n3 + (dimension2.width - dimension.width) / 2, n4, dimension.width, dimension.height);
                        registerControl.getComponent().setBounds(n3, n4 + dimension.height + 3, dimension2.width, dimension2.height);
                        n3 += dimension2.width + 10;
                    } else {
                        registerLabel.setBounds(n3, n4, dimension.width, dimension.height);
                        registerControl.getComponent().setBounds(n3 + (dimension.width - dimension2.width) / 2, n4 + dimension.height + 3, dimension2.width, dimension2.height);
                        n3 += dimension.width + 10;
                    }
                } else {
                    registerLabel.setBounds(n3, n4, dimension.width, dimension2.height);
                    registerControl.getComponent().setBounds(n3 += dimension.width + 5, n4, dimension2.width, dimension2.height);
                    n3 += dimension2.width + 10;
                }
                this.m_panel.add(registerLabel);
                this.m_panel.add(registerControl.getComponent());
                if (n3 > this.m_boundsX) {
                    this.m_boundsX = n3;
                }
                if (i == n2 - 1) {
                    if (n == 1) {
                        n4 += dimension.height + 3;
                    }
                    if ((n4 += dimension2.height + 6) > this.m_boundsY) {
                        this.m_y = this.m_boundsY = n4;
                    }
                }
                this.m_labels.add(registerLabel);
                this.setUpRegister(registerControl);
                continue;
            }
            n3 += 15;
        }
    }

    protected void addVerticalSpacer() {
        this.m_boundsY += 15;
        this.m_x = 5;
        this.m_y = this.m_boundsY;
    }

    protected void addLargeVerticalSpacer() {
        this.m_boundsY += 30;
        this.m_x = 5;
        this.m_y = this.m_boundsY;
    }

    protected void clearActionContext() {
        this.m_ctxt.enableAction("gotomem", false);
        this.m_ctxt.enableAction("newmem", false);
        this.m_ctxt.enableAction("godsm", false);
    }

    protected void prepareActionContext(RegisterControl registerControl) {
        if (registerControl != null) {
            boolean bl;
            RegisterDefinition registerDefinition = registerControl.getDefinition();
            boolean bl2 = bl = registerDefinition.getSizeInBits() == this.m_ctxt.getAddrSizeInBits();
            if (bl) {
                this.m_ctxt.getActionGroup().setAddressContext(registerControl.getValue());
            }
            this.m_ctxt.enableAction("gotomem", bl);
            this.m_ctxt.enableAction("newmem", bl);
            this.m_ctxt.enableAction("godsm", bl);
        } else {
            this.clearActionContext();
        }
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.lookAndFeelModifications();
        this.m_settingsMgr = (SettingsManager)this.m_ctxt.getManager("settmgr");
        this.m_regMgr = (RegisterManager)this.m_ctxt.getManager("regmgr");
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
        this.m_ctxt.getManager("regmgr").addListener(this);
        this.m_ctxt.getManager("settmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("regmgr").removeListener(this);
        this.m_ctxt.getManager("settmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_panel.removeFocusListener(this);
        Iterator iterator = this.m_regs.values().iterator();
        while (iterator.hasNext()) {
            this.cleanUpRegister((RegisterControl)iterator.next());
        }
        this.m_labels.clear();
        this.m_regs.clear();
        this.m_settingsMgr = null;
        this.m_regMgr = null;
        this.m_panel = null;
        this.m_scrollPane = null;
        this.m_contextMenu = null;
        this.m_labels = null;
        this.m_regs = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgregs_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_scrollPane;
    }

    public void clear(boolean bl) {
        if (bl) {
            this.setRegistersVisible(false);
        } else {
            this.clearRegisters();
        }
        this.clearActionContext();
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (!bl) {
            this.clearActionContext();
        }
    }

    public boolean canDoSuspend() {
        return true;
    }

    public void setSuspended(boolean bl) {
        super.setSuspended(bl);
        if (bl) {
            this.clear(true);
            this.m_panel.requestFocus();
        } else {
            if (this.isConfigured()) {
                this.setRegistersVisible(true);
            } else {
                this.configureRegisters();
            }
            this.requestRegisters();
        }
        this.m_scrollPane.setText(bl ? MRI.get("DBG_SUSPENDED") : null);
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: 
            case 1: {
                this.requestRegisters();
                this.enableRegisters(true);
                break;
            }
            case 3: {
                this.enableRegisters(false);
                break;
            }
            case 4: {
                this.clear(true);
            }
        }
    }

    public void registersChanged(RegisterEvent registerEvent) {
        switch (registerEvent.getType()) {
            case 1: {
                this.configureRegisters();
                break;
            }
            case 2: {
                this.clearRegisters();
                break;
            }
            case 3: {
                this.refreshRegisters();
            }
        }
    }

    public void registerChanged(RegisterEvent registerEvent) {
        RegisterDescriptor registerDescriptor = registerEvent.getDescriptor();
        RegisterControl registerControl = (RegisterControl)this.m_regs.get(new Integer(registerDescriptor.getId()));
        if (registerControl != null) {
            registerControl.setDescriptor(registerDescriptor);
        }
    }

    public void registerNotChanged(RegisterEvent registerEvent) {
        this.refreshRegisters();
    }

    public void registerEditInitiated(RegisterControl registerControl) {
    }

    public void registerEditCommitted(RegisterControl registerControl) {
        this.m_regMgr.requestRegisterWrite(registerControl.getDescriptor());
    }

    public void registerEditAborted(RegisterControl registerControl) {
        this.m_ctxt.setMessage(MRI.get("DBG_REGISTER_EDIT_CANCELED"));
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
        if (settingsEvent.colorsChanged()) {
            Iterator iterator = this.m_regs.values().iterator();
            while (iterator.hasNext()) {
                RegisterControl registerControl = (RegisterControl)iterator.next();
                registerControl.setDynamicColors(this.m_settingsMgr.m_regChangedFg, this.m_settingsMgr.m_regChangedBg);
                registerControl.repaint();
            }
        }
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof RegisterControl) {
            RegisterControl registerControl = (RegisterControl)focusEvent.getSource();
            this.prepareActionContext(registerControl);
        }
        super.focusGained(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        RegisterControl registerControl;
        if (focusEvent.getSource() instanceof RegisterControl && (registerControl = (RegisterControl)focusEvent.getSource()).isEditing()) {
            registerControl.acceptEdit();
        }
        super.focusLost(focusEvent);
    }

    private boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            this.m_contextMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Action action;
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        int n = mouseEvent.getClickCount();
        if (n == 1) {
            this.m_ctxt.setActivePanel(this);
            jComponent.requestFocus();
            if (jComponent instanceof RegisterControl) {
                this.prepareActionContext((RegisterControl)jComponent);
            } else {
                this.clearActionContext();
            }
        }
        if (!this.handlePopupMenu(mouseEvent) && n == 2 && jComponent instanceof RegisterControl && (action = this.m_ctxt.getAction("gotomem")) != null && action.isEnabled()) {
            action.run();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected class HorizontalSpacer {
    }

    protected class VerticalSpacer {
    }

    protected class RegisterLabel
    extends JLabel {
        public RegisterLabel(String string) {
            super(string);
            Util.setAccessible((Accessible)this, string);
        }

        public void updateUI() {
            super.updateUI();
            this.setFont(RegisterControl.getRegFont());
        }
    }
}

