/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.panel.VariablesPanel;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class LocalsPanel
extends VariablesPanel
implements DebugConstants {
    public static final String KEY = "locals";
    private static final String GIF = "/com/ibm/iseries/debug/dbg018.gif";
    static /* synthetic */ Class class$java$lang$String;

    public LocalsPanel() {
        super(1, MRI.get("DBG_LOCALS"), MRI.getIcon(0, GIF));
    }

    public String getHelpId() {
        return "dbglcl_p";
    }

    public String getKey() {
        return KEY;
    }

    protected AbstractTableModel createTableModel() {
        return new TblModel();
    }

    protected DefaultMutableTreeNode createTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, VariableDescriptor variableDescriptor) {
        return new DefaultMutableTreeNode(variableDescriptor);
    }

    protected void lookAndFeelModifications() {
        super.lookAndFeelModifications();
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("localsContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
        this.m_validate = this.m_userCfg.getBool("validateDerefs", false);
    }

    protected String key(VariableDescriptor variableDescriptor) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(variableDescriptor.getEvalName());
        stringBuffer.append("_");
        stringBuffer.append(variableDescriptor.getType());
        stringBuffer.append("_");
        stringBuffer.append(this.m_viewId);
        stringBuffer.append("_");
        stringBuffer.append(this.m_procId);
        return stringBuffer.toString();
    }

    protected void requestVariables() {
        this.forgetEvalVariables();
        this.m_nodes.clear();
        this.m_paths.clear();
        this.m_varMgr.requestLocals(this.m_viewId, this.m_lineNum, this.m_ctxt.getVariableDisplayMask());
    }

    public void variablesAvailable(VariableEvent variableEvent) {
        this.m_procId = variableEvent.getUniqueId();
        this.m_root.removeAllChildren();
        int n = variableEvent.getDescriptorCount();
        for (int i = 0; i < n; ++i) {
            VariableDescriptor variableDescriptor = variableEvent.getDescriptorAt(i);
            this.insertVariableNode(this.m_root, variableDescriptor, i, false);
        }
        this.restoreTreeState(true);
        this.requestEvalVariables();
        this.m_notCurrent = false;
        this.m_actionNode = null;
        this.m_actionPath = null;
    }

    private class TblModel
    extends AbstractTableModel {
        private final int COL_COUNT = 1;

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return LocalsPanel.this.m_tree != null ? LocalsPanel.this.m_tree.getRowCount() : 0;
        }

        public String getColumnName(int n) {
            return MRI.get("DBG_VALUE");
        }

        public Object getValueAt(int n, int n2) {
            VariableDescriptor variableDescriptor = LocalsPanel.this.getVariableDescriptor(n);
            return variableDescriptor.getValue();
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            TreePath treePath = LocalsPanel.this.m_tree.getPathForRow(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            VariableDescriptor variableDescriptor = (VariableDescriptor)defaultMutableTreeNode.getUserObject();
            if (variableDescriptor == null) {
                return;
            }
            if (!string.equals(variableDescriptor.getValue())) {
                LocalsPanel.this.m_varMgr.requestModify(LocalsPanel.this.m_panelId, variableDescriptor, string, LocalsPanel.this.m_ctxt.getVariableDisplayMask());
                variableDescriptor.setValue(string);
            }
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = LocalsPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            VariableDescriptor variableDescriptor = LocalsPanel.this.getVariableDescriptor(n);
            boolean bl = true;
            switch (variableDescriptor.getType()) {
                case 0: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    bl = false;
                }
            }
            return bl;
        }
    }
}

