/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.ConvTableWriter;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class IOPanel
extends TabPanel
implements LAFListener,
ActionListener,
MouseListener,
ClipboardOwner {
    public static final String KEY = "io";
    protected static final String GIF = "/com/ibm/iseries/debug/dbg085.gif";
    protected static final String GO = "GO";
    protected static final String STD_IN = "STDIN";
    protected JPanel m_panel = new JPanel(new BorderLayout());
    protected JSplitPane m_splitPane;
    protected StdioInputText m_stdInText;
    protected JScrollPane m_stdOutScroll;
    protected StdioOutputText m_stdOutText;
    protected JScrollPane m_stdErrScroll;
    protected StdioOutputText m_stdErrText;
    protected StdioWriter m_stdIn;
    protected StdioReader m_stdOut;
    protected StdioReader m_stdErr;
    protected ContextMenu m_contextMenu;
    protected StdioOutputText m_focusText;

    public IOPanel() {
        super(MRI.get("DBG_STANDARD_IO"), MRI.getIcon(0, GIF));
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_STDOUT"));
        jLabel.setHorizontalAlignment(0);
        this.m_stdOutText = new StdioOutputText();
        this.m_stdOutScroll = new JScrollPane(this.m_stdOutText);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.m_stdOutScroll, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_STDERR"));
        jLabel2.setHorizontalAlignment(0);
        this.m_stdErrText = new StdioOutputText();
        this.m_stdErrScroll = new JScrollPane(this.m_stdErrText);
        jPanel2.add((Component)jLabel2, "North");
        jPanel2.add((Component)this.m_stdErrScroll, "Center");
        this.m_splitPane = new JSplitPane(0, jPanel, jPanel2);
        this.m_splitPane.setOneTouchExpandable(true);
        this.m_splitPane.setDividerLocation(0.5);
        this.m_splitPane.setResizeWeight(0.5);
        JLabel jLabel3 = Util.getAccessibleLabel(MRI.get("DBG_STDIN_LABEL"));
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 0));
        this.m_stdInText = new StdioInputText();
        this.m_stdInText.setActionCommand(STD_IN);
        this.m_stdInText.addActionListener(this);
        JButton jButton = new JButton(MRI.get("DBG_GO"));
        jButton.setActionCommand(GO);
        jButton.addActionListener(this);
        jButton.setMargin(new Insets(0, 2, 0, 2));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.add((Component)jLabel3, MRI.isLtoR() ? "West" : "East");
        jPanel3.add((Component)this.m_stdInText, "Center");
        jPanel3.add((Component)jButton, MRI.isLtoR() ? "East" : "West");
        this.m_stdOutText.addMouseListener(this);
        this.m_stdErrText.addMouseListener(this);
        this.m_stdInText.addMouseListener(this);
        jPanel3.addMouseListener(this);
        this.m_stdOutText.addFocusListener(this);
        this.m_stdErrText.addFocusListener(this);
        this.m_stdInText.addFocusListener(this);
        Util.setAccessible((Accessible)this.m_stdOutText, jLabel);
        Util.setAccessible((Accessible)this.m_stdErrText, jLabel2);
        Util.setAccessible((Accessible)this.m_stdInText, jLabel3);
        Util.setAccessible((Accessible)jButton, jButton.getText());
        Util.setOrientation(this.m_stdOutText);
        Util.setOrientation(this.m_stdErrText);
        Util.setOrientation(this.m_stdInText, jLabel3);
        Util.setOrientation(jButton);
        this.m_panel.add((Component)this.m_splitPane, "Center");
        this.m_panel.add((Component)jPanel3, "South");
    }

    public void redirectIO(int n, int n2) {
        if (n >= 0) {
            String string = this.m_ctxt.getSystem();
            String string2 = this.m_ctxt.getUser();
            if (n2 == -1) {
                n2 = Toolbox.instance().getAS400(string, string2).getCcsid();
            }
            this.m_stdIn = new StdioWriter(string, n, n2);
            this.m_stdOut = new StdioReader(this.m_stdOutText, string, n, n2);
            this.m_stdErr = new StdioReader(this.m_stdErrText, string, n, n2);
        }
    }

    protected void lookAndFeelModifications() {
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("ioContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.lookAndFeelModifications();
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void clear(boolean bl) {
        if (!bl) {
            if (this.m_stdIn != null) {
                this.m_stdIn.cleanUp();
                this.m_stdIn = null;
            }
            if (this.m_stdOut != null) {
                this.m_stdOut.halt();
                this.m_stdOut.cleanUp();
                this.m_stdOut = null;
            }
            if (this.m_stdErr != null) {
                this.m_stdErr.halt();
                this.m_stdErr.cleanUp();
                this.m_stdErr = null;
            }
            this.m_stdOutText.clear();
            this.m_stdErrText.clear();
            this.m_stdInText.setText("");
        } else if (this.m_focusText != null) {
            this.m_focusText.clear();
        }
    }

    public void cleanUp() {
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        if (this.m_stdIn != null) {
            this.m_stdIn.cleanUp();
            this.m_stdIn = null;
        }
        if (this.m_stdOut != null) {
            this.m_stdOut.cleanUp();
            this.m_stdOut = null;
        }
        if (this.m_stdErr != null) {
            this.m_stdErr.cleanUp();
            this.m_stdErr = null;
        }
        this.m_panel = null;
        this.m_splitPane = null;
        this.m_stdInText = null;
        this.m_stdOutScroll = null;
        this.m_stdOutText = null;
        this.m_stdErrText = null;
        this.m_stdErrScroll = null;
        this.m_contextMenu = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgio_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        this.m_ctxt.enableAction("clrcon", bl && this.canDoFind());
    }

    public boolean canDoCopy() {
        return this.m_focusText != null && this.m_focusText.hasSelection();
    }

    public void copy() {
        if (this.m_focusText != null) {
            this.m_focusText.copy();
        }
    }

    public boolean canDoCopyPanel() {
        return this.m_stdOutText.hasData() || this.m_stdErrText.hasData();
    }

    public void copyPanel() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MRI.get("DBG_STDOUT"));
        stringBuffer.append('\n');
        stringBuffer.append(this.m_stdOutText.getText());
        stringBuffer.append('\n');
        stringBuffer.append('\n');
        stringBuffer.append(MRI.get("DBG_STDERR"));
        stringBuffer.append('\n');
        stringBuffer.append(this.m_stdErrText.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, this);
    }

    public boolean canDoFind() {
        return this.m_focusText != null && this.m_focusText.hasData();
    }

    public boolean find(String string) {
        if (this.m_focusText != null) {
            return this.m_focusText.find(string, false, true);
        }
        return false;
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(STD_IN)) {
            if (this.m_stdIn != null) {
                String string2 = this.m_stdInText.getText() + '\n';
                this.m_stdIn.write(string2);
            }
            this.m_stdInText.setText("");
        } else if (string.equals(GO)) {
            String string3;
            if (this.m_stdIn != null && (string3 = this.m_stdInText.getText()).length() > 0) {
                this.m_stdIn.write(string3);
            }
            this.m_stdInText.setText("");
        }
    }

    protected boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            this.m_contextMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_ctxt.setActivePanel(this);
        ((JComponent)mouseEvent.getSource()).requestFocus();
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        if (focusEvent.getSource() instanceof StdioOutputText) {
            this.m_focusText = (StdioOutputText)focusEvent.getSource();
            if (!this.m_focusText.getCaret().isVisible()) {
                this.m_focusText.getCaret().setVisible(true);
            }
            this.m_ctxt.enableAction("clrcon", this.m_focusText.hasData());
            this.m_ctxt.enableAction("find", this.m_focusText.hasData());
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private class StdioReader
    extends Thread {
        private StdioOutputText m_textArea;
        private ConvTableReader m_reader;
        private boolean m_done;
        private Socket m_socket;

        public StdioReader(StdioOutputText stdioOutputText, String string, int n, int n2) {
            this.m_textArea = stdioOutputText;
            try {
                this.m_socket = new Socket(string, n);
                this.m_reader = new ConvTableReader((InputStream)new DataInputStream(new BufferedInputStream(this.m_socket.getInputStream())), n2);
                this.setDaemon(true);
                this.start();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void cleanUp() {
            if (this.m_reader != null) {
                try {
                    if (!IOPanel.this.m_ctxt.hasPartnerContext()) {
                        this.m_reader.close();
                    }
                    this.m_reader = null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.m_reader = null;
                this.m_socket = null;
            }
        }

        public void halt() {
            this.m_done = true;
            this.cleanUp();
        }

        public void run() {
            try {
                while (!this.m_done) {
                    String string = this.m_reader.read(1);
                    if (string == null) {
                        this.m_done = true;
                        continue;
                    }
                    if (string.charAt(0) == '\u0085' && this.m_reader.getCcsid() == 37) {
                        this.m_textArea.append(System.getProperty("line.separator"));
                        continue;
                    }
                    this.m_textArea.append(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cleanUp();
        }
    }

    private class StdioWriter {
        private ConvTableWriter m_writer;
        private Socket m_socket;

        public StdioWriter(String string, int n, int n2) {
            try {
                this.m_socket = new Socket(string, n);
                this.m_writer = new ConvTableWriter((OutputStream)new DataOutputStream(new BufferedOutputStream(this.m_socket.getOutputStream())), n2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void cleanUp() {
            if (this.m_writer != null) {
                try {
                    if (!IOPanel.this.m_ctxt.hasPartnerContext()) {
                        this.m_writer.close();
                    }
                    this.m_writer = null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.m_writer = null;
                this.m_socket = null;
            }
        }

        public void write(String string) {
            try {
                this.m_writer.write(string);
                this.m_writer.flush();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private class StdioOutputText
    extends JTextArea {
        public StdioOutputText() {
            this.setEditable(false);
        }

        public void clear() {
            this.setText("");
        }

        public boolean hasData() {
            return this.getDocument().getLength() > 0;
        }

        public boolean hasSelection() {
            return this.getSelectionStart() != this.getSelectionEnd();
        }

        public void append(String string) {
            super.append(string);
            this.setCaretPosition(this.getDocument().getLength());
        }

        public boolean find(String string, boolean bl, boolean bl2) {
            int n = -1;
            if (string != null && string.length() > 0) {
                String string2;
                if (!bl) {
                    string2 = this.getText().toUpperCase();
                    string = string.toUpperCase();
                } else {
                    string2 = this.getText();
                }
                int n2 = this.getCaretPosition();
                n = string2.indexOf(string, this.getCaretPosition());
                if (n < 0 && bl2 && n2 > 0) {
                    n = string2.indexOf(string, 0);
                }
                if (n >= 0) {
                    this.requestFocus();
                    this.select(n, n + string.length());
                } else {
                    this.setCaretPosition(0);
                }
            }
            return n >= 0;
        }

        public boolean isManagingFocus() {
            return false;
        }

        public void updateUI() {
            super.updateUI();
            this.setFont(SettingsManager.getFixedPitchFont());
        }
    }

    private class StdioInputText
    extends JTextField {
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
        }
    }
}

