/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.ThreadDescriptor;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.panel.ThreadsPanel;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;

public class ThreadsPacket
extends DebuggerPacket {
    private ThreadDescriptor[] m_descriptors;

    public ThreadsPacket() {
        super(1510);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptors = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        int n2 = commLink.readInt();
        this.m_descriptors = new ThreadDescriptor[n2];
        for (int i = 0; i < n2; ++i) {
            ThreadDescriptor threadDescriptor = new ThreadDescriptor();
            threadDescriptor.read(commLink);
            if (PgmDescriptor.isUnixPgm(threadDescriptor.getPgmType())) {
                threadDescriptor.setAddress(pgmManager.getViewAddress(threadDescriptor.getViewId(), threadDescriptor.getLineNum()));
            }
            this.m_descriptors[i] = threadDescriptor;
        }
    }

    public void run() {
        ThreadsPanel threadsPanel = (ThreadsPanel)this.m_ctxt.getPanel("threads");
        threadsPanel.setThreads(this.m_descriptors);
        this.cleanUp();
    }
}

