/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.request.ReleaseSvcEntryPtRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;

public class RemoteAttachPacket
extends DebuggerPacket
implements DebugConstants {
    private static final int SERVICE_ENTRY_POINT = 0;
    private static final int WAIT_TIME = 250;
    private static final int MAX_WAIT_TIME = 30000;
    private int m_reason;
    private String m_info;
    private String m_system;
    private String m_user;
    private String m_pgmLib;
    private String m_pgmName;
    private int m_pgmType;
    private String m_jobId;
    private DebugContext m_newCtxt;
    private int m_waitTime;

    public RemoteAttachPacket() {
        super(1529);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_info = null;
        this.m_system = null;
        this.m_user = null;
        this.m_pgmLib = null;
        this.m_pgmName = null;
        this.m_jobId = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_system = commLink.getSystem();
        this.m_user = commLink.getUser();
        this.m_reason = commLink.readInt();
        this.m_info = commLink.readString();
        this.m_pgmLib = commLink.readString();
        this.m_pgmName = commLink.readString();
        this.m_pgmType = commLink.readInt();
        this.m_jobId = commLink.readString();
        this.m_jobId = Util.firstUpperJobId(this.m_jobId);
        if (this.m_pgmType == 0 || this.m_pgmType == 1) {
            this.m_pgmLib = Util.firstUpper(this.m_pgmLib);
            this.m_pgmName = Util.firstUpper(this.m_pgmName);
        }
    }

    public void run() {
        if (this.m_newCtxt == null) {
            this.m_ctxt.bringToFront();
            Toolkit.getDefaultToolkit().beep();
            PgmDescriptor pgmDescriptor = new PgmDescriptor(this.m_pgmLib, this.m_pgmName, this.m_pgmType);
            Object[] objectArray = new Object[]{pgmDescriptor.getPgmPath(), this.m_jobId};
            String string = MessageFormat.format(MRI.get("DBG_SERVICE_ENTRY_POINT_FMT"), objectArray);
            int n = Util.confirm(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string);
            if (n == 0) {
                String[] stringArray;
                this.m_ctxt.postClock();
                this.m_ctxt.commitUserConfig();
                Rectangle rectangle = this.m_ctxt.getJFrame().getBounds();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (rectangle.width < dimension.width || rectangle.height < dimension.height) {
                    stringArray = this.m_ctxt.getUserConfig();
                    stringArray.setInt("windowTop", rectangle.y += 20);
                    stringArray.setInt("windowLeft", rectangle.x += 20);
                    stringArray.commit();
                }
                stringArray = new String[]{"-s", this.m_system, "-u", this.m_user, "-j", this.m_jobId, "-svcept", "-p", pgmDescriptor.getPgmPath()};
                this.m_newCtxt = this.m_ctxt.clone(stringArray);
                SwingUtilities.invokeLater(this);
            } else {
                this.m_ctxt.sendRequest(new ReleaseSvcEntryPtRequest());
            }
        } else if (this.m_newCtxt.isInitialized() || this.m_waitTime > 30000) {
            this.m_ctxt.sendRequest(new ReleaseSvcEntryPtRequest());
            this.m_ctxt.retractClock();
            this.cleanUp();
        } else {
            try {
                Thread.sleep(250L);
                this.m_waitTime += 250;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SwingUtilities.invokeLater(this);
        }
    }
}

