/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.JobDescriptor;
import com.ibm.iseries.debug.dialog.BrowseJobDialog;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debugmanager.DebugManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class ListJobPacket
extends DebuggerPacket {
    private ArrayList m_jobs;
    private ISeriesMessage m_msgObj;

    public ListJobPacket() {
        super(1522);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_jobs = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        int n3 = commLink.readInt();
        this.m_jobs = new ArrayList(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            JobDescriptor jobDescriptor = new JobDescriptor();
            jobDescriptor.read(commLink);
            this.m_jobs.add(jobDescriptor);
        }
        Collections.sort(this.m_jobs);
        n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        DebugWindow debugWindow = this.m_ctxt;
        if (debugWindow == null) {
            debugWindow = DebugManager.instance();
        }
        Dialog dialog = debugWindow.getActiveDialog();
        if (this.m_msgObj != null) {
            String string = Toolbox.instance().getMsgText(debugWindow, this.m_msgObj);
            String string2 = Toolbox.instance().getMsgHelp(this.m_msgObj);
            if (dialog != null) {
                ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(dialog, string, string2);
                iSeriesMessageDialog.display();
            } else if (this.m_ctxt != null) {
                ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(debugWindow, string, string2);
                iSeriesMessageDialog.display(debugWindow);
            }
        }
        if (dialog != null && dialog instanceof BrowseJobDialog) {
            ((BrowseJobDialog)dialog).setJobs(this.m_jobs);
        }
        this.cleanUp();
    }
}

