/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Packet;
import com.ibm.iseries.debug.util.Toolbox;
import java.io.IOException;

public abstract class DebuggerPacket
implements Packet {
    public static final int START_DEBUG = 1500;
    public static final int END_DEBUG = 1501;
    public static final int ADD_PGM = 1502;
    public static final int RMV_PGM = 1503;
    public static final int SOURCE_VIEW = 1504;
    public static final int LINE_BREAK = 1505;
    public static final int CONTEXT = 1506;
    public static final int CONSOLE = 1507;
    public static final int LOCALS = 1508;
    public static final int CALL_STACK = 1509;
    public static final int THREADS = 1510;
    public static final int MONITORS = 1511;
    public static final int DSPMODSRC = 1512;
    public static final int MODIFY_VAR = 1513;
    public static final int EVAL_VAR = 1514;
    public static final int MODIFY_THREAD = 1515;
    public static final int PGM_COMPLETED = 1516;
    public static final int WATCH = 1517;
    public static final int AUTO_EVAL = 1518;
    public static final int CLEAR_PGM = 1519;
    public static final int CLEAR_WATCH_ALL = 1520;
    public static final int INFO = 1521;
    public static final int LIST_JOB = 1522;
    public static final int FIND = 1523;
    public static final int MEMORY_ADDR = 1525;
    public static final int REGISTERS = 1526;
    public static final int ASSEMBLER_VIEW = 1527;
    public static final int MEMORY_EXP = 1528;
    public static final int REMOTE_ATTACH = 1529;
    public static final int OPER_PROGRESS = 1530;
    public static final int SET_OPTIONS = 1531;
    public static final int REDIRECT_IO = 1532;
    public static final int TRANSLATE_PID = 1533;
    protected DebugContext m_ctxt;
    protected int m_type;

    public DebuggerPacket(int n) {
        this.m_type = n;
    }

    public int getType() {
        return this.m_type;
    }

    public void cleanUp() {
        this.m_ctxt = null;
    }

    public DebugContext getContext() {
        return this.m_ctxt;
    }

    public void setContext(DebugContext debugContext) {
        this.m_ctxt = debugContext;
    }

    public ActionGroup getActionGroup() {
        return this.m_ctxt.getActionGroup();
    }

    public void displayMessage(ISeriesMessage iSeriesMessage) {
        String string = Toolbox.instance().getMsgText(this.m_ctxt, iSeriesMessage);
        this.m_ctxt.setMessage(string);
        ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(this.m_ctxt, iSeriesMessage);
        iSeriesMessageDialog.display(this.m_ctxt);
    }

    public void displayMessage(ISeriesMessage iSeriesMessage, int n) {
        String string = Toolbox.instance().getMsgText(this.m_ctxt, iSeriesMessage);
        this.m_ctxt.setMessage(string);
        this.m_ctxt.setDebugIcon(n, string);
        ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(this.m_ctxt, iSeriesMessage);
        iSeriesMessageDialog.display(this.m_ctxt);
    }

    public abstract void read(CommLink var1, int var2) throws IOException;
}

