/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class AddPgmPacket
extends DebuggerPacket
implements DebugConstants {
    private static final int FROM_NOT_SURE = -1;
    private static final int FROM_STRDBG_CMD = 0;
    private static final int FROM_GUI = 1;
    private PgmDescriptor[] m_descriptors;
    private int m_initiatedFrom;
    private ISeriesMessage m_msgObj;

    public AddPgmPacket() {
        super(1502);
    }

    public void cleanUp() {
        super.cleanUp();
        for (int i = 0; i < this.m_descriptors.length; ++i) {
            this.m_descriptors[i] = null;
        }
        this.m_descriptors = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        int n2;
        this.m_initiatedFrom = commLink.readInt();
        boolean bl = false;
        int n3 = commLink.readInt();
        this.m_descriptors = new PgmDescriptor[n3];
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.m_descriptors[n2] = new PgmDescriptor();
                this.m_descriptors[n2].read(commLink);
                if (!this.m_descriptors[n2].isUnix()) continue;
                bl = true;
            }
            if (bl && n3 > 1) {
                int n4;
                ArrayList<PgmDescriptor> arrayList = new ArrayList<PgmDescriptor>(n3);
                for (n4 = 0; n4 < n3; ++n4) {
                    arrayList.add(n4, this.m_descriptors[n4]);
                }
                Collections.sort(arrayList);
                for (n4 = 0; n4 < n3; ++n4) {
                    this.m_descriptors[n4] = (PgmDescriptor)arrayList.get(n4);
                }
            }
        }
        if ((n2 = commLink.readInt()) == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            PgmEvent pgmEvent = new PgmEvent(this, 0, this.m_descriptors, this.m_initiatedFrom);
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            pgmManager.fireProgramAddedEvent(pgmEvent);
            pgmEvent.cleanUp();
            if (this.m_initiatedFrom == 1) {
                ContextManager contextManager = (ContextManager)this.m_ctxt.getManager("ctxtmgr");
                contextManager.refreshContext(true);
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        if (this.m_initiatedFrom == 1) {
            this.m_ctxt.retractClock();
        }
        this.cleanUp();
    }
}

