/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.menu;

import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.SubMenu;
import java.beans.PropertyChangeEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class FormatMenu
extends SubMenu {
    private JCheckBoxMenuItem m_hex;

    public FormatMenu(ActionGroup actionGroup, boolean bl) {
        super(MRI.get("DBG_FORMAT_MENU"), bl);
        Settings settings = actionGroup.getContext().getUserConfig();
        this.m_hex = this.addCheckAction(actionGroup, "hex", settings.getBool("varsHex", false));
        this.addSeparator();
        this.add(new CPlusPlusMenu(actionGroup, bl));
    }

    public boolean canCustomizeKeyStrokes() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("hex")) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.m_hex.setSelected(bl);
        }
    }

    private class CPlusPlusMenu
    extends SubMenu {
        private JCheckBoxMenuItem m_inc;
        private JRadioButtonMenuItem m_ebcdic;
        private JRadioButtonMenuItem m_ascii;
        private JRadioButtonMenuItem m_unicode;

        public CPlusPlusMenu(ActionGroup actionGroup, boolean bl) {
            super(MRI.get("DBG_C_CPP_MENU"), bl);
            Settings settings = actionGroup.getContext().getUserConfig();
            boolean bl2 = settings.getBool("varsIncBaseClass", false);
            boolean bl3 = settings.getBool("varsEBCDIC", true);
            boolean bl4 = settings.getBool("varsASCII", false);
            boolean bl5 = settings.getBool("varsUNICODE", false);
            this.m_inc = this.addCheckAction(actionGroup, "incbscls", bl2);
            this.addSeparator();
            this.m_ebcdic = this.addRadioAction(actionGroup, "ebcdic", bl3);
            this.m_ascii = this.addRadioAction(actionGroup, "ascii", bl4);
            this.m_unicode = this.addRadioAction(actionGroup, "unicode", bl5);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_ebcdic);
            buttonGroup.add(this.m_ascii);
            buttonGroup.add(this.m_unicode);
        }

        public boolean canCustomizeKeyStrokes() {
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (string.equals("incBaseClasses")) {
                this.m_inc.setSelected(bl);
            } else if (string.equals("ebcdic")) {
                this.m_ebcdic.setSelected(bl);
            } else if (string.equals("ascii")) {
                this.m_ascii.setSelected(bl);
            } else if (string.equals("unicode")) {
                this.m_unicode.setSelected(bl);
            }
        }
    }
}

