/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.memory.MemoryExpControl;
import com.ibm.iseries.debug.memory.MemoryExpCtrlView;
import com.ibm.iseries.debug.memory.MemoryExpEditListener;
import com.ibm.iseries.debug.memory.MemoryPane;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MemoryExpCtrls
extends JPanel
implements MemoryExpCtrlView,
MemoryExpEditListener,
DebugConstants,
ActionListener {
    public static final int SIZEOF_VAR = -1;
    private static final String BYTES = "bytes";
    private static final String BYTES_PER = "bytesper";
    private static final String MODE = "mode";
    private Settings m_userCfg;
    private ContextManager m_ctxtMgr;
    private MemoryManager m_memMgr;
    private MemoryPane m_memory;
    private MemoryExpControl m_expCtrl;
    private JComboBox m_bytesCtrl;
    private JComboBox m_modeCtrl;
    private JComboBox m_bytesPerCtrl;
    private String m_viewId;
    private int m_lineNum;

    public MemoryExpCtrls() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.m_viewId = "";
    }

    public void init(DebugContext debugContext, MemoryPane memoryPane) {
        this.m_userCfg = debugContext.getUserConfig();
        this.m_ctxtMgr = (ContextManager)debugContext.getManager("ctxtmgr");
        this.m_memMgr = (MemoryManager)debugContext.getManager("memmgr");
        this.m_memory = memoryPane;
        this.add((Component)this.createAddrComponents(debugContext), MRI.isLtoR() ? "West" : "East");
        this.add((Component)this.createFmtComponents(debugContext), MRI.isLtoR() ? "East" : "West");
    }

    public void cleanUp() {
        this.m_expCtrl.cleanUp();
        this.m_userCfg = null;
        this.m_ctxtMgr = null;
        this.m_memMgr = null;
        this.m_memory = null;
        this.m_expCtrl = null;
        this.m_bytesCtrl = null;
        this.m_modeCtrl = null;
        this.m_bytesPerCtrl = null;
        this.m_viewId = null;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getExpression() {
        return this.m_expCtrl.getExpression();
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public int getLineNum() {
        return this.m_lineNum;
    }

    public void setExpression(String string, String string2, int n) {
        this.m_expCtrl.setExpression(string);
        this.m_viewId = string2;
        this.m_lineNum = n;
    }

    public void insertExpression(String string, String string2, int n) {
        this.m_expCtrl.insertExpression(string);
        this.m_viewId = string2;
        this.m_lineNum = n;
    }

    public void removeExpression(String string) {
        this.m_expCtrl.removeExpression(string);
    }

    public void clearExpressionHistory() {
        this.m_expCtrl.clearExpressionHistory();
        this.m_viewId = "";
        this.m_lineNum = -1;
    }

    protected void validateCharacterMode(int n) {
        switch (n) {
            case 0: 
            case 1: {
                int n2;
                while (n2 > 1) {
                    this.m_bytesPerCtrl.insertItemAt(String.valueOf(n2 /= 2), 0);
                }
                break;
            }
            case 2: {
                int n2;
                while (n2 > 2) {
                    this.m_bytesPerCtrl.insertItemAt(String.valueOf(n2 /= 2), 0);
                }
                while (n2 < 2) {
                    this.m_bytesPerCtrl.removeItemAt(0);
                    n2 *= 2;
                }
                break;
            }
            case 3: {
                int n2;
                for (n2 = Integer.parseInt((String)this.m_bytesPerCtrl.getItemAt(0)); n2 < 4; n2 *= 2) {
                    this.m_bytesPerCtrl.removeItemAt(0);
                }
                break;
            }
        }
    }

    public void setCharacterMode(int n) {
        this.validateCharacterMode(n);
        this.m_modeCtrl.removeActionListener(this);
        this.m_modeCtrl.setSelectedIndex(n);
        this.m_modeCtrl.addActionListener(this);
        this.m_userCfg.setInt("memCharMode", n);
    }

    public int getCharacterMode() {
        return this.m_modeCtrl.getSelectedIndex();
    }

    public void setByteCount(int n) {
        this.m_bytesCtrl.removeActionListener(this);
        if (n == -1) {
            this.m_bytesCtrl.setSelectedIndex(0);
        } else {
            this.m_bytesCtrl.setSelectedItem(String.valueOf(n));
        }
        this.m_bytesCtrl.addActionListener(this);
        this.m_userCfg.setInt("memBytes", n);
    }

    public int getByteCount() {
        if (this.m_bytesCtrl.getSelectedIndex() == 0) {
            return -1;
        }
        return Integer.parseInt((String)this.m_bytesCtrl.getSelectedItem());
    }

    protected void validateBytesPerLine(int n) {
        if (n < 2) {
            this.m_modeCtrl.removeItem(MRI.get("DBG_UNICODE"));
            this.m_modeCtrl.removeItem(MRI.get("DBG_UTF32"));
        } else if (n < 4) {
            this.m_modeCtrl.removeItem(MRI.get("DBG_UTF32"));
            if (this.m_modeCtrl.getItemCount() <= 2) {
                this.m_modeCtrl.addItem(MRI.get("DBG_UNICODE"));
            }
        } else {
            if (this.m_modeCtrl.getItemCount() <= 2) {
                this.m_modeCtrl.addItem(MRI.get("DBG_UNICODE"));
            }
            if (this.m_modeCtrl.getItemCount() <= 3) {
                this.m_modeCtrl.addItem(MRI.get("DBG_UTF32"));
            }
        }
    }

    public void setBytesPerLine(int n) {
        this.validateBytesPerLine(n);
        this.m_bytesPerCtrl.removeActionListener(this);
        this.m_bytesPerCtrl.setSelectedItem(String.valueOf(n));
        this.m_bytesPerCtrl.addActionListener(this);
        this.m_userCfg.getInt("memBPL", n);
    }

    public int getBytesPerLine() {
        return Integer.parseInt((String)this.m_bytesPerCtrl.getSelectedItem());
    }

    public void enableExpressionControls(boolean bl) {
        this.m_expCtrl.setEnabled(bl);
        this.m_bytesCtrl.setEnabled(bl);
    }

    private JPanel createAddrComponents(DebugContext debugContext) {
        boolean bl = MRI.isLtoR();
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_EXPRESSION_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_BYTES_LABEL"));
        this.m_expCtrl = new MemoryExpControl();
        this.m_expCtrl.setEditListener(this);
        int n = this.m_userCfg.getInt("memBytes", -1);
        this.m_bytesCtrl = new JComboBox();
        this.m_bytesCtrl.setRenderer(new DummyRenderer());
        this.m_bytesCtrl.addItem(MRI.get("DBG_SIZE_OF"));
        this.m_bytesCtrl.addItem(String.valueOf(32));
        this.m_bytesCtrl.addItem(String.valueOf(64));
        this.m_bytesCtrl.addItem(String.valueOf(128));
        this.m_bytesCtrl.addItem(String.valueOf(256));
        this.m_bytesCtrl.addItem(String.valueOf(512));
        this.m_bytesCtrl.addItem(String.valueOf(1024));
        this.m_bytesCtrl.addItem(String.valueOf(2048));
        this.m_bytesCtrl.addItem(String.valueOf(4096));
        this.m_bytesCtrl.setMaximumRowCount(9);
        Dimension dimension = this.m_bytesCtrl.getPreferredSize();
        dimension.width += 5;
        this.m_bytesCtrl.setPreferredSize(dimension);
        if (n == -1) {
            this.m_bytesCtrl.setSelectedIndex(0);
        } else {
            this.m_bytesCtrl.setSelectedItem(String.valueOf(n));
        }
        this.m_bytesCtrl.setActionCommand(BYTES);
        this.m_bytesCtrl.addActionListener(this);
        Util.setAccessible((Accessible)this.m_expCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_bytesCtrl, jLabel2);
        Util.setOrientation(this.m_expCtrl, jLabel);
        Util.setOrientation(this.m_bytesCtrl, jLabel2);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel3.add(this.m_expCtrl);
        jPanel3.add(this.m_bytesCtrl);
        jPanel.add((Component)jPanel2, bl ? "West" : "East");
        jPanel.add((Component)jPanel3, bl ? "East" : "West");
        return jPanel;
    }

    private JPanel createFmtComponents(DebugContext debugContext) {
        boolean bl = MRI.isLtoR();
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_FORMAT_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_BYTES_PER_LINE_LABEL"));
        int n = this.m_userCfg.getInt("memCharMode", 0);
        int n2 = this.m_userCfg.getInt("memBPL", 16);
        this.m_modeCtrl = new JComboBox();
        this.m_modeCtrl.setRenderer(new DummyRenderer());
        this.m_modeCtrl.addItem(MRI.get("DBG_EBCDIC"));
        this.m_modeCtrl.addItem(MRI.get("DBG_ASCII"));
        if (n2 >= 2) {
            this.m_modeCtrl.addItem(MRI.get("DBG_UNICODE"));
        }
        if (n2 >= 4) {
            this.m_modeCtrl.addItem(MRI.get("DBG_UTF32"));
        }
        Dimension dimension = this.m_modeCtrl.getPreferredSize();
        dimension.width += 5;
        this.m_modeCtrl.setPreferredSize(dimension);
        this.m_modeCtrl.setSelectedIndex(n);
        this.m_modeCtrl.setActionCommand(MODE);
        this.m_modeCtrl.addActionListener(this);
        this.m_bytesPerCtrl = new JComboBox();
        this.m_bytesPerCtrl.setRenderer(new DummyRenderer());
        if (n < 2) {
            this.m_bytesPerCtrl.addItem(String.valueOf(1));
        }
        if (n < 3) {
            this.m_bytesPerCtrl.addItem(String.valueOf(2));
        }
        this.m_bytesPerCtrl.addItem(String.valueOf(4));
        this.m_bytesPerCtrl.addItem(String.valueOf(8));
        this.m_bytesPerCtrl.addItem(String.valueOf(16));
        this.m_bytesPerCtrl.addItem(String.valueOf(32));
        this.m_bytesPerCtrl.setSelectedItem(String.valueOf(n2));
        this.m_bytesPerCtrl.setActionCommand(BYTES_PER);
        this.m_bytesPerCtrl.addActionListener(this);
        Util.setAccessible((Accessible)this.m_modeCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_bytesPerCtrl, jLabel2);
        Util.setOrientation(this.m_modeCtrl, jLabel);
        Util.setOrientation(this.m_bytesPerCtrl, jLabel2);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        if (bl) {
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        } else {
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel3.add(this.m_modeCtrl);
        jPanel3.add(this.m_bytesPerCtrl);
        jPanel.add((Component)jPanel2, bl ? "West" : "East");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private void requestMemory() {
        if (this.m_expCtrl.isEditing()) {
            this.m_expCtrl.acceptEdit();
        }
        String string = this.getExpression();
        int n = this.getByteCount();
        this.m_userCfg.setInt("memBytes", n);
        if (string != null && string.length() > 0) {
            this.m_memory.setEnabled(true);
            this.m_viewId = this.m_ctxtMgr.getContextViewId();
            this.m_lineNum = this.m_ctxtMgr.getContextLineNum();
            this.m_memMgr.requestMemoryRead(string, this.m_viewId, this.m_lineNum, n);
        }
    }

    public void expressionEditInitiated(MemoryExpControl memoryExpControl) {
        this.m_memory.setEnabled(false);
    }

    public void expressionEditCommitted(MemoryExpControl memoryExpControl) {
        this.requestMemory();
    }

    public void expressionEditAborted(MemoryExpControl memoryExpControl) {
        this.m_memory.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(BYTES)) {
            this.requestMemory();
        } else if (string.equals(MODE)) {
            int n = this.getCharacterMode();
            this.validateCharacterMode(n);
            this.m_memory.setCharacterMode(n, true);
            this.m_userCfg.setInt("memCharMode", n);
        } else if (string.equals(BYTES_PER)) {
            int n = this.getBytesPerLine();
            this.validateBytesPerLine(n);
            this.m_memory.setBytesPerLine(n, true);
            this.m_userCfg.setInt("memBPL", n);
        }
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

