/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.PasswordSecurity;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SignonDialog
extends Dialog {
    private static final String SYSTEM = "sys";
    private static final String USER = "usr";
    private static final String PW = "pw";
    private static final String REMEMBER = "rem";
    private static final int DAYS_MAX = 14;
    private static final int DAYS_DEFAULT = 5;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JTextField m_systemCtrl;
    private JTextField m_userCtrl;
    private JPasswordField m_pwCtrl;
    private JCheckBox m_rememberCtrl;
    private JComboBox m_daysCtrl;
    private String m_system;
    private String m_user;
    private String m_pw;
    private boolean m_remember;
    private int m_rememberDays = 5;

    public SignonDialog(JDialog jDialog, String string, String string2, String string3, String string4, String string5) {
        super(jDialog, string, true, string2);
        this.init(string3, string4, string5);
    }

    public SignonDialog(JFrame jFrame, String string, String string2, String string3, String string4, String string5) {
        super(jFrame, string, true, string2);
        this.init(string3, string4, string5);
    }

    private void init(String string, String string2, String string3) {
        this.m_system = Util.firstUpper(string);
        this.m_user = Util.firstUpper(string2);
        this.m_pw = string3;
        this.m_remember = PasswordSecurity.instance().rememberPassword();
        this.m_rememberDays = PasswordSecurity.instance().rememberPasswordDays();
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.addComponents();
        this.addWindowListener(new WndAdapter());
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_systemCtrl = null;
        this.m_userCtrl = null;
        this.m_pwCtrl = null;
        this.m_rememberCtrl = null;
        this.m_daysCtrl = null;
    }

    public void disableSystem() {
        this.m_systemCtrl.setEnabled(false);
    }

    public String getSystem() {
        return this.m_system;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPassword() {
        String string = this.m_pw;
        this.m_pw = "";
        return string;
    }

    public boolean rememberPassword() {
        return this.m_remember;
    }

    public int rememberPasswordDays() {
        return this.m_rememberDays;
    }

    private void addComponents() {
        this.listenForEscape(this.m_panel);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel3 = new JPanel(new FlowLayout(this.m_isLtoR ? 0 : 2));
        jPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        jPanel2.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        jPanel3.setBorder(this.getEmptyBorder(0, 10, 0, 10));
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_SYSTEM_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_USER_LABEL"));
        JLabel jLabel3 = Util.getAccessibleLabel(MRI.get("DBG_PASSWORD_LABEL"));
        JLabel jLabel4 = Util.getAccessibleLabel(MRI.get("DBG_DAYS"));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        this.m_systemCtrl = new JTextField(this.m_system);
        this.m_systemCtrl.setActionCommand(SYSTEM);
        this.m_systemCtrl.addActionListener(this);
        this.m_userCtrl = new JTextField(this.m_user);
        this.m_userCtrl.setActionCommand(USER);
        this.m_userCtrl.addActionListener(this);
        this.m_pwCtrl = new JPasswordField(this.m_pw);
        this.m_pwCtrl.setActionCommand(PW);
        this.m_pwCtrl.addActionListener(this);
        jPanel2.add(this.m_systemCtrl);
        jPanel2.add(this.m_userCtrl);
        jPanel2.add(this.m_pwCtrl);
        String string = MRI.get("DBG_REMEMBER_PASSWORD_LABEL");
        this.m_rememberCtrl = new JCheckBox(string, this.m_remember);
        this.m_rememberCtrl.setActionCommand(REMEMBER);
        this.m_rememberCtrl.addActionListener(this);
        this.m_daysCtrl = new JComboBox();
        this.m_daysCtrl.setRenderer(new DummyRenderer());
        for (int i = 1; i <= 14; ++i) {
            this.m_daysCtrl.addItem(String.valueOf(i));
        }
        this.m_daysCtrl.setEnabled(this.m_remember);
        this.m_daysCtrl.setSelectedIndex(this.m_rememberDays - 1);
        this.m_daysCtrl.setMaximumRowCount(14);
        Util.setAccessible((Accessible)this.m_systemCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_userCtrl, jLabel2);
        Util.setAccessible((Accessible)this.m_pwCtrl, jLabel3);
        Util.setAccessible((Accessible)this.m_daysCtrl, jLabel4);
        Util.setAccessible((Accessible)this.m_rememberCtrl, string);
        Util.setOrientation(jPanel3);
        Util.setOrientation(this.m_systemCtrl, jLabel);
        Util.setOrientation(this.m_userCtrl, jLabel2);
        Util.setOrientation(this.m_pwCtrl, jLabel3);
        Util.setOrientation(this.m_daysCtrl, jLabel4);
        Util.setOrientation(this.m_rememberCtrl);
        jPanel3.add(this.m_rememberCtrl);
        jPanel3.add(this.m_daysCtrl);
        jPanel3.add(jLabel4);
        this.m_basePanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)jPanel2, "Center");
        this.m_basePanel.add((Component)jPanel3, "South");
    }

    private boolean validatePassword() {
        this.postClock();
        try {
            InetAddress.getByName(this.m_system);
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray = new Object[]{Util.firstUpper(this.m_system)};
            String string = MessageFormat.format(MRI.get("DBG_UNKNOWN_HOST_SYSTEM_FMT"), objectArray);
            Util.errorMessage(this, MRI.get("DBG_ERROR"), string);
            this.retractClock();
            return false;
        }
        AS400 aS400 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        try {
            aS400 = new AS400(this.m_system, this.m_user, this.m_pw);
            bl = aS400.validateSignon();
        }
        catch (AS400SecurityException aS400SecurityException) {
            string = aS400SecurityException.getLocalizedMessage();
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            string = extendedIllegalArgumentException.getLocalizedMessage();
        }
        catch (IOException iOException) {
            bl2 = true;
            string = iOException.getLocalizedMessage();
        }
        catch (Throwable throwable) {
            string = throwable.getLocalizedMessage();
        }
        if (!bl) {
            this.getToolkit().beep();
            this.m_pwCtrl.requestFocus();
            if (bl2) {
                if (string == null || string.length() == 0) {
                    Object[] objectArray = new Object[]{Util.firstUpper(this.m_system)};
                    string = MessageFormat.format(MRI.get("DBG_COMMUNICATION_ERROR_FMT"), objectArray);
                }
            } else if (string == null || string.length() == 0) {
                string = MRI.get("DBG_PASSWORD_ERROR");
            }
            Util.errorMessage(this, MRI.get("DBG_ERROR"), string);
        }
        if (aS400 != null) {
            aS400.disconnectAllServices();
        }
        this.retractClock();
        return bl;
    }

    public void doOk() {
        char[] cArray = this.m_pwCtrl.getPassword();
        this.m_system = this.m_systemCtrl.getText();
        this.m_user = this.m_userCtrl.getText();
        this.m_pw = new String(cArray);
        this.m_remember = this.m_rememberCtrl.isSelected();
        this.m_rememberDays = this.m_daysCtrl.getSelectedIndex() + 1;
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
        if (this.m_system.length() > 0 && this.m_user.length() > 0 && this.m_pw.length() > 0) {
            if (this.validatePassword()) {
                PasswordSecurity.instance().remember(this.m_system, this.m_user, this.m_pw, this.m_remember, this.m_rememberDays);
                this.setCanceled(false);
                this.dispose();
            }
        } else if (this.m_system.length() == 0) {
            this.getToolkit().beep();
            this.m_systemCtrl.requestFocus();
        } else if (this.m_user.length() == 0) {
            this.getToolkit().beep();
            this.m_userCtrl.requestFocus();
        } else if (this.m_pw.length() == 0) {
            this.getToolkit().beep();
            this.m_pwCtrl.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals(SYSTEM) || string.equals(USER) || string.equals(PW) || string.equals("doit")) {
            this.doOk();
        } else if (string.equals(REMEMBER)) {
            this.m_daysCtrl.setEnabled(this.m_rememberCtrl.isSelected());
        }
    }

    private class WndAdapter
    extends WindowAdapter {
        private WndAdapter() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (SignonDialog.this.m_system.length() == 0) {
                SignonDialog.this.m_systemCtrl.requestFocus();
            } else if (SignonDialog.this.m_user.length() == 0) {
                SignonDialog.this.m_userCtrl.requestFocus();
            } else {
                SignonDialog.this.m_pwCtrl.requestFocus();
            }
        }
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

