/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.util.DialogTabPanel;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class PreferencesGeneralPage
extends DialogTabPanel
implements ActionListener {
    private Settings m_userCfg;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JCheckBox m_autoOpen;
    private JCheckBox m_autoSave;
    private JComboBox m_recentEnv;
    private JComboBox m_recentPgm;
    private JComboBox m_maxLines;
    private JComboBox m_tabSize;
    private JSlider m_dblClick;
    private JCheckBox m_pgmCmpl;
    private JCheckBox m_flyoverEval;

    public PreferencesGeneralPage(Settings settings) {
        super(MRI.get("DBG_GENERAL"), 1);
        int n;
        this.m_userCfg = settings;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel();
        this.m_basePanel.setLayout(new BoxLayout(this.m_basePanel, 1));
        this.m_panel.setBorder(this.getEmptyBorder(5, 5, 5, 5));
        this.m_panel.add((Component)this.m_basePanel, "North");
        String string = MRI.get("DBG_AUTO_OPEN");
        String string2 = MRI.get("DBG_AUTO_SAVE");
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.m_autoOpen = new JCheckBox(string);
        this.m_autoSave = new JCheckBox(string2);
        jPanel2.setBorder(this.getTitledBorder(MRI.get("DBG_PROGRAM_ENVIRONMENT")));
        jPanel2.add((Component)jPanel, "Center");
        jPanel.setBorder(this.getEmptyBorder(0, 5, 0, 5));
        jPanel.add(this.m_autoOpen);
        jPanel.add(this.m_autoSave);
        this.m_autoOpen.setSelected(this.m_userCfg.getBool("autoOpenEnvironment", true));
        this.m_autoSave.setSelected(this.m_userCfg.getBool("autoSaveEnvironment", true));
        this.m_autoOpen.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        this.m_autoSave.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_RECENT_ENV_LABEL"));
        JPanel jPanel3 = new JPanel();
        this.m_recentEnv = new JComboBox();
        this.m_recentEnv.setRenderer(new DummyRenderer());
        this.m_recentEnv.setMaximumRowCount(10);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.m_isLtoR ? jLabel : this.m_recentEnv);
        jPanel3.add(Box.createRigidArea(new Dimension(20, 0)));
        jPanel3.add(this.m_isLtoR ? this.m_recentEnv : jLabel);
        jPanel.add(jPanel3);
        for (int i = 1; i <= 20; ++i) {
            this.m_recentEnv.addItem(String.valueOf(i));
        }
        this.m_recentEnv.setSelectedIndex(this.m_userCfg.getInt("pgmEnvMax", 8) - 1);
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_RECENT_PGM_LABEL"));
        JPanel jPanel4 = new JPanel();
        this.m_recentPgm = new JComboBox();
        this.m_recentPgm.setRenderer(new DummyRenderer());
        this.m_recentPgm.setMaximumRowCount(10);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(this.m_isLtoR ? jLabel2 : this.m_recentPgm);
        jPanel4.add(Box.createRigidArea(new Dimension(20, 0)));
        jPanel4.add(this.m_isLtoR ? this.m_recentPgm : jLabel2);
        jPanel.add(jPanel4);
        for (int i = 1; i <= 20; ++i) {
            this.m_recentPgm.addItem(String.valueOf(i));
        }
        this.m_recentPgm.setSelectedIndex(this.m_userCfg.getInt("pgmMax", 8) - 1);
        Dimension dimension = jLabel.getPreferredSize();
        Dimension dimension2 = jLabel2.getPreferredSize();
        if (dimension.width > dimension2.width) {
            dimension2.width = dimension.width;
            jLabel2.setPreferredSize(dimension2);
        } else {
            dimension.width = dimension2.width;
            jLabel.setPreferredSize(dimension);
        }
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.setBorder(this.getTitledBorder(MRI.get("DBG_SOURCE_CODE_VIEW")));
        jPanel7.add((Component)jPanel5, this.m_isLtoR ? "West" : "East");
        jPanel7.add((Component)jPanel6, "Center");
        Dimension dimension3 = new Dimension(0, 3);
        JLabel jLabel3 = Util.getAccessibleLabel(MRI.get("DBG_MAX_LINES_LABEL"));
        JLabel jLabel4 = Util.getAccessibleLabel(MRI.get("DBG_SPACES_PER_TAB_LABEL"));
        JLabel jLabel5 = Util.getAccessibleLabel(MRI.get("DBG_DBL_CLICK_LABEL"));
        jLabel3.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        jLabel4.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        jLabel5.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(this.getEmptyBorder(0, 5, 0, 10));
        jPanel5.add(jLabel3);
        jPanel5.add(Box.createRigidArea(dimension3));
        jPanel5.add(jLabel4);
        jPanel5.add(Box.createRigidArea(dimension3));
        jPanel5.add(jLabel5);
        jPanel5.add(Box.createVerticalGlue());
        this.m_maxLines = new JComboBox();
        this.m_maxLines.setMaximumRowCount(10);
        this.m_maxLines.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        for (n = 1000; n <= 10000; n += 1000) {
            this.m_maxLines.addItem(String.valueOf(n));
        }
        this.m_maxLines.setSelectedIndex(this.m_userCfg.getInt("srcMaxLines", 5000) / 1000 - 1);
        this.m_tabSize = new JComboBox();
        this.m_tabSize.setRenderer(new DummyRenderer());
        this.m_tabSize.setMaximumRowCount(10);
        this.m_tabSize.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        for (n = 1; n <= 10; ++n) {
            this.m_tabSize.addItem(String.valueOf(n));
        }
        this.m_tabSize.setSelectedIndex(this.m_userCfg.getInt("srcTabSize", 4) - 1);
        JLabel jLabel6 = Util.getAccessibleLabel(MRI.get("DBG_FAST"));
        JLabel jLabel7 = Util.getAccessibleLabel(MRI.get("DBG_SLOW"));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(1), jLabel7);
        hashtable.put(new Integer(8), jLabel6);
        this.m_dblClick = new JSlider(1, 8, this.mapDblClickTime(-1));
        this.m_dblClick.setPaintTicks(true);
        this.m_dblClick.setMajorTickSpacing(1);
        this.m_dblClick.setSnapToTicks(true);
        this.m_dblClick.setLabelTable(hashtable);
        this.m_dblClick.setPaintLabels(true);
        this.m_dblClick.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        Dimension dimension4 = this.m_dblClick.getPreferredSize();
        if (dimension4.width > 125) {
            dimension4.width = 125;
            this.m_dblClick.setPreferredSize(dimension4);
        }
        dimension4 = jLabel3.getPreferredSize();
        dimension4.height = this.m_maxLines.getPreferredSize().height;
        jLabel3.setPreferredSize(dimension4);
        dimension4 = jLabel4.getPreferredSize();
        dimension4.height = this.m_tabSize.getPreferredSize().height;
        jLabel4.setPreferredSize(dimension4);
        dimension4 = jLabel5.getPreferredSize();
        dimension4.height = this.m_dblClick.getPreferredSize().height;
        jLabel5.setPreferredSize(dimension4);
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(this.getEmptyBorder(0, 10, 0, 5));
        jPanel6.add(this.m_maxLines);
        jPanel6.add(Box.createRigidArea(dimension3));
        jPanel6.add(this.m_tabSize);
        jPanel6.add(Box.createRigidArea(dimension3));
        jPanel6.add(this.m_dblClick);
        jPanel6.add(Box.createVerticalGlue());
        String string3 = MRI.get("DBG2_FLYOVER_EVAL");
        JPanel jPanel8 = new JPanel(new BorderLayout());
        this.m_flyoverEval = new JCheckBox(string3);
        jPanel8.setBorder(this.getEmptyBorder(0, 5, 0, 5));
        jPanel8.add(this.m_flyoverEval);
        this.m_flyoverEval.setSelected(this.m_userCfg.getBool("flyoverEval", true));
        this.m_flyoverEval.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        jPanel7.add((Component)jPanel8, "South");
        JPanel jPanel9 = new JPanel(new BorderLayout());
        this.m_pgmCmpl = new JCheckBox(MRI.get("DBG_PGM_COMPLETION_DIALOG_ENABLED"), this.m_userCfg.getBool("ackPgmCompletion", true));
        this.m_pgmCmpl.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        jPanel9.add((Component)this.m_pgmCmpl, this.m_isLtoR ? "West" : "East");
        String string4 = MRI.get("DBG_RESTORE_DEFAULTS");
        JButton jButton = new JButton(string4);
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(this);
        Util.setAccessible((Accessible)this.m_autoOpen, string);
        Util.setAccessible((Accessible)this.m_autoSave, string2);
        Util.setAccessible((Accessible)this.m_flyoverEval, string3);
        Util.setAccessible((Accessible)this.m_recentEnv, jLabel);
        Util.setAccessible((Accessible)this.m_recentPgm, jLabel2);
        Util.setAccessible((Accessible)this.m_maxLines, jLabel3);
        Util.setAccessible((Accessible)this.m_tabSize, jLabel4);
        Util.setAccessible((Accessible)this.m_dblClick, jLabel5);
        Util.setAccessible((Accessible)this.m_pgmCmpl, this.m_pgmCmpl.getText());
        Util.setAccessible((Accessible)jButton, string4);
        jLabel6.setLabelFor(this.m_dblClick);
        jLabel7.setLabelFor(this.m_dblClick);
        Util.setOrientation(this.m_autoOpen);
        Util.setOrientation(this.m_autoSave);
        Util.setOrientation(this.m_flyoverEval);
        Util.setOrientation(this.m_recentEnv, jLabel);
        Util.setOrientation(this.m_recentPgm, jLabel2);
        Util.setOrientation(this.m_maxLines, jLabel3);
        Util.setOrientation(this.m_tabSize, jLabel4);
        Util.setOrientation(this.m_dblClick, jLabel5);
        Util.setOrientation(jButton);
        Util.setOrientation(jLabel6);
        Util.setOrientation(jLabel7);
        Util.setOrientation(this.m_pgmCmpl);
        this.m_basePanel.add(jPanel2);
        this.m_basePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.m_basePanel.add(jPanel7);
        this.m_basePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.m_basePanel.add(jPanel9);
        this.m_basePanel.add(Box.createRigidArea(new Dimension(0, 40)));
        this.m_basePanel.add(jButton);
        this.m_basePanel.add(Box.createVerticalGlue());
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void cleanUp() {
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_autoOpen = null;
        this.m_autoSave = null;
        this.m_flyoverEval = null;
        this.m_recentEnv = null;
        this.m_recentPgm = null;
        this.m_maxLines = null;
        this.m_tabSize = null;
        this.m_dblClick = null;
        this.m_pgmCmpl = null;
    }

    public boolean doOk() {
        boolean bl = false;
        boolean bl2 = this.m_userCfg.getBool("autoOpenEnvironment", true);
        boolean bl3 = this.m_userCfg.getBool("autoSaveEnvironment", true);
        boolean bl4 = this.m_userCfg.getBool("flyoverEval", true);
        int n = this.m_userCfg.getInt("pgmEnvMax", 8);
        int n2 = this.m_userCfg.getInt("pgmMax", 8);
        int n3 = this.m_userCfg.getInt("srcMaxLines", 5000);
        int n4 = this.m_userCfg.getInt("srcTabSize", 4);
        int n5 = this.mapDblClickTime(-1);
        boolean bl5 = this.m_userCfg.getBool("ackPgmCompletion", true);
        boolean bl6 = this.m_autoOpen.isSelected();
        boolean bl7 = this.m_autoSave.isSelected();
        boolean bl8 = this.m_flyoverEval.isSelected();
        int n6 = this.m_recentEnv.getSelectedIndex() + 1;
        int n7 = this.m_recentPgm.getSelectedIndex() + 1;
        int n8 = (this.m_maxLines.getSelectedIndex() + 1) * 1000;
        int n9 = this.m_tabSize.getSelectedIndex() + 1;
        int n10 = this.m_dblClick.getValue();
        boolean bl9 = this.m_pgmCmpl.isSelected();
        if (bl6 != bl2) {
            if (!bl6) {
                this.m_userCfg.setBool("autoOpenEnvironment", bl6);
            } else {
                this.m_userCfg.remove("autoOpenEnvironment");
            }
            bl = true;
        }
        if (bl7 != bl3) {
            if (!bl7) {
                this.m_userCfg.setBool("autoSaveEnvironment", bl7);
            } else {
                this.m_userCfg.remove("autoSaveEnvironment");
            }
            bl = true;
        }
        if (bl8 != bl4) {
            if (!bl8) {
                this.m_userCfg.setBool("flyoverEval", bl8);
            } else {
                this.m_userCfg.remove("flyoverEval");
            }
            bl = true;
        }
        if (n6 != n) {
            if (n6 != 8) {
                this.m_userCfg.setInt("pgmEnvMax", n6);
            } else {
                this.m_userCfg.remove("pgmEnvMax");
            }
            bl = true;
        }
        if (n7 != n2) {
            if (n7 != 8) {
                this.m_userCfg.setInt("pgmMax", n7);
            } else {
                this.m_userCfg.remove("pgmMax");
            }
            bl = true;
        }
        if (n8 != n3) {
            if (n8 != 5000) {
                this.m_userCfg.setInt("srcMaxLines", n8);
            } else {
                this.m_userCfg.remove("srcMaxLines");
            }
            bl = true;
        }
        if (n9 != n4) {
            if (n9 != 4) {
                this.m_userCfg.setInt("srcTabSize", n9);
            } else {
                this.m_userCfg.remove("srcTabSize");
            }
            bl = true;
        }
        if (n10 != n5) {
            int n11 = 200 + (this.m_dblClick.getMaximum() - n10) * 50;
            if (n11 != 250) {
                this.m_userCfg.setInt("srcDoubleClick", n11);
            } else {
                this.m_userCfg.remove("srcDoubleClick");
            }
            bl = true;
        }
        if (bl9 != bl5) {
            if (!bl9) {
                this.m_userCfg.setBool("ackPgmCompletion", bl9);
            } else {
                this.m_userCfg.remove("ackPgmCompletion");
            }
            bl = true;
        }
        return bl;
    }

    public int mapDblClickTime(int n) {
        if (n < 0) {
            n = this.m_userCfg.getInt("srcDoubleClick", 250);
        }
        int n2 = 6;
        n2 = n >= 550 ? 1 : (n >= 500 ? 2 : (n >= 450 ? 3 : (n >= 400 ? 4 : (n >= 350 ? 5 : (n >= 300 ? 6 : (n >= 250 ? 7 : 8))))));
        return n2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.m_autoOpen.setSelected(true);
        this.m_autoSave.setSelected(true);
        this.m_flyoverEval.setSelected(true);
        this.m_recentEnv.setSelectedIndex(7);
        this.m_recentPgm.setSelectedIndex(7);
        this.m_maxLines.setSelectedIndex(4);
        this.m_tabSize.setSelectedIndex(3);
        this.m_dblClick.setValue(this.mapDblClickTime(250));
        this.m_pgmCmpl.setSelected(true);
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

