/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.JobDescriptor;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.request.ListJobRequest;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class BrowseJobDialog
extends Dialog
implements MouseListener,
ListSelectionListener {
    private static final int COL_COUNT = 3;
    private static final int JOB_NAME_COL = 0;
    private static final int JOB_USER_COL = 1;
    private static final int JOB_NUM_COL = 2;
    private static final String JOB_NAME = "name";
    private static final String JOB_USER = "user";
    private static final String JOB_NUM = "num";
    private static final String SEARCH = "search";
    private DebugWindow m_wnd;
    private SettingsManager m_settingsMgr;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_labelPanel;
    private JPanel m_ctrlPanel;
    private JPanel m_buttonPanel;
    private JPanel m_tablePanel;
    private JComboBox m_jobNameCtrl;
    private JComboBox m_jobNumCtrl;
    private JComboBox m_jobUserCtrl;
    private JButton m_searchButton;
    private JScrollPane m_tableScroll;
    private TblModel m_tableModel;
    private Tbl m_table;
    private JTableHeader m_tableHeader;
    private ArrayList m_jobs;
    private int m_jobIndex;
    private int[] m_columns;
    static /* synthetic */ Class class$java$lang$String;

    public BrowseJobDialog(DebugWindow debugWindow, JDialog jDialog, SettingsManager settingsManager, String string) {
        super(jDialog, MRI.get("DBG_BROWSE_JOB_DIALOG_TITLE"), true, "dbgbrowsejobs");
        this.m_wnd = debugWindow;
        this.m_settingsMgr = settingsManager;
        this.m_columns = new int[3];
        if (this.m_isLtoR) {
            this.m_columns[0] = 0;
            this.m_columns[1] = 1;
            this.m_columns[2] = 2;
        } else {
            this.m_columns[0] = 2;
            this.m_columns[1] = 1;
            this.m_columns[2] = 0;
        }
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_labelPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_ctrlPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_buttonPanel = new JPanel();
        this.m_tablePanel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.m_basePanel.setBorder(this.getTitledBorder(MRI.get("DBG_ENTER_SEARCH_CRITERIA")));
        this.m_labelPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_ctrlPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_buttonPanel.setBorder(this.getEmptyBorder(3, 10, 10, 10));
        this.addComponents(string);
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.m_tablePanel, "Center");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.doSearch();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_wnd = null;
        this.m_settingsMgr = null;
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_labelPanel = null;
        this.m_ctrlPanel = null;
        this.m_buttonPanel = null;
        this.m_tablePanel = null;
        this.m_jobNameCtrl = null;
        this.m_jobNumCtrl = null;
        this.m_jobUserCtrl = null;
        this.m_searchButton = null;
        this.m_tableScroll = null;
        this.m_tableModel = null;
        this.m_table = null;
        this.m_tableHeader = null;
    }

    private void addComponents(String string) {
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_JOB_NAME_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_USER_LABEL"));
        JLabel jLabel3 = Util.getAccessibleLabel(MRI.get("DBG_JOB_NUMBER_LABEL"));
        this.m_labelPanel.add(jLabel);
        this.m_labelPanel.add(jLabel2);
        this.m_labelPanel.add(jLabel3);
        string = Util.firstUpper(string);
        Settings settings = this.m_settingsMgr.getUserConfig();
        String string2 = MRI.get("DBG_ALL");
        String string3 = settings.getString("browseJobName", string2);
        String string4 = settings.getString("browseJobUser", string);
        String string5 = settings.getString("browseJobNum", string2);
        this.m_jobNameCtrl = new JComboBox();
        this.m_jobNameCtrl.setRenderer(new DummyRenderer());
        this.m_jobNameCtrl.setEditable(true);
        this.m_jobNameCtrl.addItem(string2);
        this.m_jobNameCtrl.setSelectedItem(string3);
        this.m_jobNameCtrl.setActionCommand(JOB_NAME);
        this.m_jobNameCtrl.addActionListener(this);
        this.m_jobUserCtrl = new JComboBox();
        this.m_jobUserCtrl.setRenderer(new DummyRenderer());
        this.m_jobUserCtrl.setEditable(true);
        this.m_jobUserCtrl.addItem(string2);
        this.m_jobUserCtrl.addItem(string);
        this.m_jobUserCtrl.setSelectedItem(string4);
        this.m_jobUserCtrl.setActionCommand(JOB_USER);
        this.m_jobUserCtrl.addActionListener(this);
        this.m_jobNumCtrl = new JComboBox();
        this.m_jobNumCtrl.setRenderer(new DummyRenderer());
        this.m_jobNumCtrl.setEditable(true);
        this.m_jobNumCtrl.addItem(string2);
        this.m_jobNumCtrl.setSelectedItem(string5);
        this.m_jobNumCtrl.setActionCommand(JOB_NUM);
        this.m_jobNumCtrl.addActionListener(this);
        this.m_ctrlPanel.add(this.m_jobNameCtrl);
        this.m_ctrlPanel.add(this.m_jobUserCtrl);
        this.m_ctrlPanel.add(this.m_jobNumCtrl);
        String string6 = MRI.get("DBG_SEARCH");
        JButton jButton = new JButton(string6);
        jButton.setActionCommand(SEARCH);
        jButton.addActionListener(this);
        this.m_buttonPanel.add(jButton);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JLabel jLabel4 = new JLabel(" ");
        JLabel jLabel5 = Util.getAccessibleLabel(MRI.get("DBG_JOBS_FOUND_LABEL"));
        jPanel.setOpaque(true);
        jPanel.add(jLabel4);
        jPanel.add(jLabel5);
        this.m_tableModel = new TblModel();
        this.m_table = new Tbl(this.m_tableModel);
        this.m_tableHeader = this.m_table.getTableHeader();
        this.m_tableScroll = new JScrollPane(this.m_table);
        this.m_tablePanel.add((Component)jPanel, "North");
        this.m_tablePanel.add((Component)this.m_tableScroll, "Center");
        this.m_table.setSelectionMode(0);
        this.m_tableScroll.getViewport().setBackground(this.m_table.getBackground());
        this.m_tablePanel.setBackground(this.m_table.getBackground());
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.addMouseListener(this);
        this.m_tableHeader.addMouseListener(this);
        Util.setAccessible((Accessible)this.m_jobNameCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_jobUserCtrl, jLabel2);
        Util.setAccessible((Accessible)this.m_jobNumCtrl, jLabel3);
        Util.setAccessible((Accessible)jButton, string6);
        Util.setOrientation(this.m_jobNameCtrl, jLabel);
        Util.setOrientation(this.m_jobUserCtrl, jLabel2);
        Util.setOrientation(this.m_jobNumCtrl, jLabel3);
        Util.setOrientation(jButton);
        Util.setOrientation(jLabel5);
        Util.setOrientation(this.m_tableScroll);
        Util.setOrientation(this.m_jobNameCtrl.getEditor().getEditorComponent());
        Util.setOrientation(this.m_jobUserCtrl.getEditor().getEditorComponent());
        Util.setOrientation(this.m_jobNumCtrl.getEditor().getEditorComponent());
        this.m_basePanel.add((Component)this.m_labelPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)this.m_ctrlPanel, "Center");
        this.m_basePanel.add((Component)this.m_buttonPanel, this.m_isLtoR ? "East" : "West");
        this.listenForEscape(this.m_panel);
        this.listenForEscape(this.m_table);
    }

    public String getJobName() {
        JobDescriptor jobDescriptor = (JobDescriptor)this.m_jobs.get(this.m_jobIndex);
        return jobDescriptor.getJobName();
    }

    public String getJobUser() {
        JobDescriptor jobDescriptor = (JobDescriptor)this.m_jobs.get(this.m_jobIndex);
        return jobDescriptor.getJobUser();
    }

    public String getJobNumber() {
        JobDescriptor jobDescriptor = (JobDescriptor)this.m_jobs.get(this.m_jobIndex);
        return jobDescriptor.getJobNumber();
    }

    public void setJobs(ArrayList arrayList) {
        this.m_jobs = arrayList;
        this.m_tableModel.fireTableDataChanged();
        this.m_doItButton.setEnabled(this.m_jobs.size() > 0 && this.m_table.getSelectedRowCount() > 0);
        this.retractClock();
    }

    public void doOk() {
        int n = this.m_table.getSelectedRow();
        if (n >= 0) {
            this.m_jobIndex = n;
            String string = ((String)this.m_jobNameCtrl.getSelectedItem()).trim();
            String string2 = ((String)this.m_jobUserCtrl.getSelectedItem()).trim();
            String string3 = ((String)this.m_jobNumCtrl.getSelectedItem()).trim();
            Settings settings = this.m_settingsMgr.getUserConfig();
            settings.setString("browseJobName", string);
            settings.setString("browseJobUser", string2);
            settings.setString("browseJobNum", string3);
            this.setCanceled(false);
            this.dispose();
        }
    }

    private void selectComboBox(JComboBox jComboBox) {
        Component component;
        ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
        jComboBox.requestFocus();
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) != null && component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.selectAll();
        }
    }

    private void doSearch() {
        String string = ((String)this.m_jobNameCtrl.getSelectedItem()).trim();
        String string2 = ((String)this.m_jobUserCtrl.getSelectedItem()).trim();
        String string3 = ((String)this.m_jobNumCtrl.getSelectedItem()).trim();
        String string4 = MRI.get("DBG_ALL").toUpperCase();
        if (string.length() == 0 || string.startsWith("*")) {
            this.selectComboBox(this.m_jobNameCtrl);
            this.getToolkit().beep();
            return;
        }
        if ((string = string.toUpperCase()).equals(string4)) {
            string = "*ALL";
        }
        if (string2.length() == 0 || string2.startsWith("*")) {
            this.selectComboBox(this.m_jobUserCtrl);
            this.getToolkit().beep();
            return;
        }
        if ((string2 = string2.toUpperCase()).equals(string4)) {
            string2 = "*ALL";
        }
        if (string3.length() == 0 || string3.indexOf(42) >= 0) {
            this.selectComboBox(this.m_jobNumCtrl);
            this.getToolkit().beep();
            return;
        }
        if ((string3 = string3.toUpperCase()).equals(string4)) {
            string3 = "*ALL";
        } else if (string3.length() != 6) {
            this.selectComboBox(this.m_jobNumCtrl);
            this.getToolkit().beep();
            return;
        }
        this.postClock();
        ListJobRequest listJobRequest = new ListJobRequest(string, string2, string3);
        boolean bl = this.m_wnd.sendRequest(listJobRequest);
        if (!bl) {
            this.retractClock();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox;
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit")) {
            this.doOk();
        } else if (string.equals(SEARCH)) {
            this.doSearch();
        } else if ((string.equals(JOB_NAME) || string.equals(JOB_USER) || string.equals(JOB_NUM)) && !(jComboBox = (JComboBox)actionEvent.getSource()).isPopupVisible()) {
            this.doSearch();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.m_table) {
            if (mouseEvent.getClickCount() == 2) {
                this.doOk();
            }
        } else if (mouseEvent.getSource() == this.m_tableHeader) {
            int n = this.m_tableHeader.columnAtPoint(mouseEvent.getPoint());
            int n2 = -1;
            switch (this.m_columns[n]) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                }
            }
            if (n2 != JobDescriptor.getSortMode()) {
                JobDescriptor.setSortMode(n2);
                if (this.m_table.getRowCount() > 1) {
                    Collections.sort(this.m_jobs);
                    this.m_table.clearSelection();
                    this.m_tableModel.fireTableDataChanged();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.m_doItButton.setEnabled(this.m_table.getSelectedRowCount() > 0);
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }

    private class TblModel
    extends AbstractTableModel {
        private TblModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return BrowseJobDialog.this.m_jobs != null ? BrowseJobDialog.this.m_jobs.size() : 0;
        }

        public String getColumnName(int n) {
            switch (BrowseJobDialog.this.m_columns[n]) {
                case 0: {
                    return MRI.get("DBG_JOB_NAME");
                }
                case 1: {
                    return MRI.get("DBG_USER");
                }
                case 2: {
                    return MRI.get("DBG_JOB_NUMBER");
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            JobDescriptor jobDescriptor = (JobDescriptor)BrowseJobDialog.this.m_jobs.get(n);
            switch (BrowseJobDialog.this.m_columns[n2]) {
                case 0: {
                    return jobDescriptor.getJobName();
                }
                case 1: {
                    return jobDescriptor.getJobUser();
                }
                case 2: {
                    return jobDescriptor.getJobNumber();
                }
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = BrowseJobDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    protected class Tbl
    extends JTable {
        public Tbl(TblModel tblModel) {
            super(tblModel);
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            int n = 15;
            dimension.height = n * this.getRowHeight();
            return dimension;
        }
    }
}

