/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.BreakpointSwatchIcon;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.ColorUIResource;

public class BreakpointGroupDialog
extends Dialog {
    private static final String NAME = "name";
    private static HashMap s_color;
    private static String[] s_colorName;
    private DebugContext m_ctxt;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_labelPanel;
    private JPanel m_ctrlPanel;
    private JTextField m_nameCtrl;
    private JComboBox m_colorCtrl;
    private String m_title;
    private String m_name;
    private ColorUIResource m_color;
    private boolean m_uniqueName;

    public BreakpointGroupDialog(DebugContext debugContext, String string, String string2, String string3, ColorUIResource colorUIResource, boolean bl) {
        super(debugContext.getJFrame(), string, true, string2);
        this.m_ctxt = debugContext;
        this.m_title = string;
        this.m_name = string3;
        this.m_color = colorUIResource;
        this.m_uniqueName = bl;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_labelPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_ctrlPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.m_labelPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_ctrlPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_basePanel.add((Component)this.m_labelPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)this.m_ctrlPanel, "Center");
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.addComponents();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_ctxt = null;
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_labelPanel = null;
        this.m_ctrlPanel = null;
        this.m_nameCtrl = null;
        this.m_colorCtrl = null;
        this.m_title = null;
    }

    public String getName() {
        return this.m_name;
    }

    public ColorUIResource getColor() {
        return this.m_color;
    }

    private void addComponents() {
        this.listenForEscape(this.m_panel);
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_NAME_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_COLOR_LABEL"));
        this.m_labelPanel.add(jLabel);
        this.m_labelPanel.add(jLabel2);
        this.m_nameCtrl = new JTextField(this.m_name);
        this.m_nameCtrl.setActionCommand(NAME);
        this.m_nameCtrl.addActionListener(this);
        this.m_colorCtrl = new JComboBox();
        this.m_colorCtrl.setRenderer(new ComboRenderer());
        this.m_colorCtrl.setMaximumRowCount(s_colorName.length);
        this.m_ctrlPanel.add(this.m_nameCtrl);
        this.m_ctrlPanel.add(this.m_colorCtrl);
        Util.setAccessible((Accessible)this.m_nameCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_colorCtrl, jLabel2);
        Util.setOrientation(this.m_nameCtrl, jLabel);
        Util.setOrientation(this.m_colorCtrl, jLabel2);
        boolean bl = false;
        for (int i = 0; i < s_colorName.length; ++i) {
            ColorUIResource colorUIResource;
            this.m_colorCtrl.addItem(s_colorName[i]);
            if (this.m_color == null || bl || !this.m_color.equals(colorUIResource = (ColorUIResource)s_color.get(s_colorName[i]))) continue;
            this.m_colorCtrl.setSelectedIndex(i);
            bl = true;
        }
    }

    public void doOk() {
        this.m_name = this.m_nameCtrl.getText();
        this.m_color = (ColorUIResource)s_color.get(this.m_colorCtrl.getSelectedItem());
        if (this.m_name.length() == 0) {
            this.getToolkit().beep();
            this.m_nameCtrl.requestFocus();
            return;
        }
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        if (this.m_uniqueName && breakpointGroupManager.groupExists(this.m_name)) {
            this.getToolkit().beep();
            this.m_nameCtrl.requestFocus();
            Object[] objectArray = new Object[]{this.m_name};
            String string = MessageFormat.format(MRI.get("DBG_GROUP_ALREADY_EXISTS_FMT"), objectArray);
            Util.errorMessage(this, this.m_title, string);
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals(NAME) || string.equals("doit")) {
            this.doOk();
        }
    }

    static {
        s_colorName = new String[13];
        BreakpointGroupDialog.s_colorName[0] = MRI.get("DBG_BLACK");
        BreakpointGroupDialog.s_colorName[1] = MRI.get("DBG_BLUE");
        BreakpointGroupDialog.s_colorName[2] = MRI.get("DBG_CYAN");
        BreakpointGroupDialog.s_colorName[3] = MRI.get("DBG_DARKGRAY");
        BreakpointGroupDialog.s_colorName[4] = MRI.get("DBG_GRAY");
        BreakpointGroupDialog.s_colorName[5] = MRI.get("DBG_GREEN");
        BreakpointGroupDialog.s_colorName[6] = MRI.get("DBG_LIGHTGRAY");
        BreakpointGroupDialog.s_colorName[7] = MRI.get("DBG_MAGENTA");
        BreakpointGroupDialog.s_colorName[8] = MRI.get("DBG_ORANGE");
        BreakpointGroupDialog.s_colorName[9] = MRI.get("DBG_PINK");
        BreakpointGroupDialog.s_colorName[10] = MRI.get("DBG_RED");
        BreakpointGroupDialog.s_colorName[11] = MRI.get("DBG_WHITE");
        BreakpointGroupDialog.s_colorName[12] = MRI.get("DBG_YELLOW");
        s_color = new HashMap();
        s_color.put(s_colorName[0], new ColorUIResource(Color.black));
        s_color.put(s_colorName[1], new ColorUIResource(Color.blue));
        s_color.put(s_colorName[2], new ColorUIResource(Color.cyan));
        s_color.put(s_colorName[3], new ColorUIResource(Color.darkGray));
        s_color.put(s_colorName[4], new ColorUIResource(Color.gray));
        s_color.put(s_colorName[5], new ColorUIResource(Color.green));
        s_color.put(s_colorName[6], new ColorUIResource(Color.lightGray));
        s_color.put(s_colorName[7], new ColorUIResource(Color.magenta));
        s_color.put(s_colorName[8], new ColorUIResource(Color.orange));
        s_color.put(s_colorName[9], new ColorUIResource(Color.pink));
        s_color.put(s_colorName[10], new ColorUIResource(Color.red));
        s_color.put(s_colorName[11], new ColorUIResource(Color.white));
        s_color.put(s_colorName[12], new ColorUIResource(Color.yellow));
    }

    private class ComboRenderer
    extends DefaultListCellRenderer {
        private BreakpointSwatchIcon m_icon = null;

        public ComboRenderer() {
            int n = BreakpointGroupDialog.this.m_colorCtrl.getFontMetrics(BreakpointGroupDialog.this.m_colorCtrl.getFont()).getHeight() - 4;
            this.m_icon = new BreakpointSwatchIcon(n);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.m_icon.setColor((ColorUIResource)s_color.get((String)object));
            }
            this.setIcon(this.m_icon);
            return this;
        }
    }
}

