/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.RequestPacketElement;
import java.io.IOException;

public class VariableDescriptor
implements RequestPacketElement,
Comparable {
    public static final int NOTYPE = 0;
    public static final int CHAR = 1;
    public static final int CHAR16 = 2;
    public static final int BOOL32 = 3;
    public static final int CARD16 = 4;
    public static final int CARD32 = 5;
    public static final int INT16 = 6;
    public static final int INT32 = 7;
    public static final int FLOAT = 8;
    public static final int DOUBLE = 9;
    public static final int PTR = 10;
    public static final int FCNPTR = 11;
    public static final int MCHADR = 12;
    public static final int STRUCT = 13;
    public static final int ARRAY = 14;
    public static final int ENUM = 15;
    public static final int STRING = 16;
    public static final int PACKED = 17;
    public static final int ZONEDTE = 18;
    public static final int ZONEDTS = 19;
    public static final int ZONEDLE = 20;
    public static final int ZONEDLS = 21;
    public static final int BIND16 = 22;
    public static final int BIND32 = 23;
    public static final int BIND64 = 24;
    public static final int TABLE = 25;
    public static final int IND = 26;
    public static final int DATE = 27;
    public static final int TIME = 28;
    public static final int TSTAMP = 29;
    public static final int FIXEDL = 30;
    public static final int STRINGF = 31;
    public static final int STRINGU = 32;
    public static final int STRINGA = 33;
    public static final int INT64 = 34;
    public static final int SCHAR8 = 35;
    public static final int CARD64 = 36;
    public static final int CARD8 = 37;
    public static final int HEX = 100;
    public static final int JAVACLASS = 101;
    public static final String NULL_PTR = "SPP:*NULL";
    public static final String NILL_PTR = "(nil)";
    private String m_viewId;
    private int m_lineNum;
    private String m_name;
    private String m_evalName;
    private int m_type;
    private String m_value;
    private String m_bounds;
    private VariableDescriptor[] m_children;

    public VariableDescriptor() {
    }

    public VariableDescriptor(String string, int n, String string2, String string3, int n2) {
        this.m_viewId = string;
        this.m_lineNum = n;
        this.m_name = string2;
        this.m_evalName = string3;
        this.m_type = n2;
        this.m_value = "";
        this.m_bounds = "";
    }

    public VariableDescriptor(VariableDescriptor variableDescriptor) {
        this.m_viewId = variableDescriptor.m_viewId;
        this.m_lineNum = variableDescriptor.m_lineNum;
        this.m_name = variableDescriptor.m_name;
        this.m_evalName = variableDescriptor.m_evalName;
        this.m_type = variableDescriptor.m_type;
        this.m_value = variableDescriptor.m_value;
        this.m_bounds = variableDescriptor.m_bounds;
    }

    public String toString() {
        if (this.m_name.length() > 32) {
            return this.m_name.substring(0, 33) + "...";
        }
        return this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public int getLineNum() {
        return this.m_lineNum;
    }

    public String getEvalName() {
        return this.m_evalName;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String string) {
        this.m_value = string;
    }

    public String getBounds() {
        return this.m_bounds;
    }

    public void setBounds(String string) {
        this.m_bounds = string;
    }

    public int getLowBound() {
        int n = -1;
        String string = this.m_bounds.trim();
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            String string2 = string.substring(0, n2);
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public int getHiBound() {
        int n = -1;
        String string = this.m_bounds.trim();
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            String string2 = string.substring(n2 + 1);
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public boolean isPtr() {
        return this.m_type == 10;
    }

    public boolean isValidPtr() {
        return this.m_type == 10 && this.m_value.length() > 0 && !this.m_value.equals(NULL_PTR) && !this.m_value.equals(NILL_PTR);
    }

    public boolean isJavaClass() {
        return this.m_type == 101;
    }

    public boolean isArray() {
        return this.m_type == 14;
    }

    public boolean isStruct() {
        return this.m_type == 13;
    }

    public boolean isStringPtr() {
        switch (this.m_type) {
            case 31: 
            case 32: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        return this.m_type == 16;
    }

    public boolean hasChildren() {
        return this.m_children != null;
    }

    public int getChildCount() {
        return this.m_children != null ? this.m_children.length : 0;
    }

    public VariableDescriptor[] getChildren() {
        return this.m_children;
    }

    public VariableDescriptor getChild(int n) {
        return this.m_children[n];
    }

    public void removeChildren() {
        this.m_children = null;
    }

    public void replaceChild(VariableDescriptor variableDescriptor, VariableDescriptor variableDescriptor2) {
        if (this.m_children == null) {
            return;
        }
        for (int i = 0; i < this.m_children.length; ++i) {
            if (this.m_children[i] != variableDescriptor) continue;
            this.m_children[i] = variableDescriptor2;
            break;
        }
    }

    public boolean equals(VariableDescriptor variableDescriptor) {
        if (this.m_type != variableDescriptor.m_type || !this.m_evalName.equals(variableDescriptor.m_evalName) || !this.m_viewId.equals(variableDescriptor.m_viewId) || this.m_lineNum != variableDescriptor.m_lineNum) {
            return false;
        }
        if (this.m_children == null && variableDescriptor.m_children != null || this.m_children != null && variableDescriptor.m_children == null) {
            return false;
        }
        if (this.m_children != null) {
            if (this.m_children.length != variableDescriptor.m_children.length) {
                return false;
            }
            for (int i = 0; i < this.m_children.length; ++i) {
                if (this.m_children[i].equals(variableDescriptor.m_children[i])) continue;
                return false;
            }
        }
        return true;
    }

    public void read(CommLink commLink) throws IOException {
        this.m_viewId = commLink.readString();
        this.m_lineNum = commLink.readInt();
        this.m_name = commLink.readString();
        this.m_evalName = commLink.readString();
        this.m_type = commLink.readInt();
        this.m_value = commLink.readString();
        this.m_bounds = commLink.readString();
        int n = commLink.readInt();
        if (n > 0) {
            this.m_children = new VariableDescriptor[n];
            for (int i = 0; i < n; ++i) {
                this.m_children[i] = new VariableDescriptor();
                this.m_children[i].read(commLink);
            }
        }
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_viewId);
        n += 4;
        n += commLink.writeSize(this.m_name);
        n += commLink.writeSize(this.m_evalName);
        n += 4;
        n += commLink.writeSize(this.m_value);
        n += commLink.writeSize(this.m_bounds);
        n += 4;
        if (this.m_children != null) {
            for (int i = 0; i < this.m_children.length; ++i) {
                n += this.m_children[i].writeSize(commLink);
            }
        }
        return n;
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeString(this.m_viewId);
        commLink.writeInt(this.m_lineNum);
        commLink.writeString(this.m_name);
        commLink.writeString(this.m_evalName);
        commLink.writeInt(this.m_type);
        commLink.writeString(this.m_value);
        commLink.writeString(this.m_bounds);
        if (this.m_children != null) {
            commLink.writeInt(this.m_children.length);
            for (int i = 0; i < this.m_children.length; ++i) {
                this.m_children[i].write(commLink);
            }
        } else {
            commLink.writeInt(0);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof VariableDescriptor) {
            return this.m_name.compareTo(((VariableDescriptor)object).m_name);
        }
        return this.m_name.compareTo(object.toString());
    }
}

