/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.panel.BreakpointsPanel;
import com.ibm.iseries.debug.panel.MonitorsPanel;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugFile;
import com.ibm.iseries.debug.util.DebugPgmEnv;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class PgmEnvironment
implements DebugPgmEnv {
    protected static final double VERSION = 7.10002;
    protected DebugContext m_ctxt;
    protected Settings m_userCfg;
    protected String m_extension;
    protected String m_description;
    protected String m_homeDir;
    protected String m_defaultDir;
    protected String m_defaultFile;
    protected String m_pgmPath = "";
    protected String m_pgmLib = "";
    protected String m_pgmName = "";
    protected int m_pgmType = -1;
    protected File m_file;
    protected DebugFile m_envFile;
    protected EnvChooser m_envChooser;
    protected boolean m_saved;
    protected boolean m_isAutoOpen;

    public PgmEnvironment(DebugContext debugContext, String string, String string2) {
        this.m_ctxt = debugContext;
        this.m_extension = string;
        this.m_description = string2;
        this.m_userCfg = this.m_ctxt.getUserConfig();
        this.m_homeDir = System.getProperty("user.home");
        this.m_defaultDir = this.m_userCfg.getString("pgmEnvDir", this.m_homeDir);
        this.m_defaultFile = this.m_userCfg.getString("pgmEnvFile", this.m_extension);
        this.m_file = new File(this.m_homeDir, this.m_extension);
        this.m_saved = true;
    }

    public void cleanUp() {
        this.m_ctxt = null;
        this.m_description = null;
        this.m_extension = null;
        this.m_userCfg = null;
        this.m_homeDir = null;
        this.m_defaultDir = null;
        this.m_defaultFile = null;
        this.m_pgmPath = null;
        this.m_pgmLib = null;
        this.m_pgmName = null;
        this.m_file = null;
        this.m_envFile = null;
        this.m_envChooser = null;
    }

    public String getExtension() {
        return this.m_extension;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getEnvPgmPath() {
        return this.m_pgmPath;
    }

    public boolean isAutoOpen() {
        return this.m_isAutoOpen;
    }

    public boolean getAutoOpenSetting() {
        return this.m_userCfg.getBool("autoOpenEnvironment", true);
    }

    public boolean getAutoSaveSetting() {
        return this.m_userCfg.getBool("autoSaveEnvironment", true);
    }

    public JFileChooser getEnvChooser() {
        File file;
        if (this.m_envChooser == null) {
            this.m_envChooser = new EnvChooser(this.m_defaultDir);
        }
        if (this.m_defaultFile.length() > 0 && (file = new File(this.m_defaultDir, this.m_defaultFile)).exists() && file.canRead()) {
            this.m_envChooser.setSelectedFile(file);
        }
        return this.m_envChooser;
    }

    public boolean getSaved() {
        return this.m_saved;
    }

    public void setSaved(boolean bl) {
        this.m_saved = bl;
    }

    public void setDirectory(File file) {
        String string;
        if (file.isDirectory() && !this.m_defaultDir.equals(string = file.getAbsolutePath())) {
            this.m_defaultDir = string;
        }
    }

    public void resetDirectory() {
        this.m_defaultDir = this.m_userCfg.getString("pgmEnvDir", this.m_homeDir);
        this.m_defaultFile = this.m_userCfg.getString("pgmEnvFile", this.m_extension);
        this.m_file = new File(this.m_defaultDir, this.m_defaultFile);
        if (!this.m_file.exists() || this.m_file.isDirectory() || !this.m_file.canRead()) {
            this.m_userCfg.remove("pgmEnvDir");
            this.m_userCfg.remove("pgmEnvFile");
            this.m_defaultDir = this.m_homeDir;
            this.m_defaultFile = this.m_extension;
            this.m_file = new File(this.m_homeDir, this.m_extension);
        }
        if (this.m_envChooser != null) {
            this.m_envChooser.setCurrentDirectory(this.m_file);
        }
    }

    protected void setFile(File file) {
        String string;
        if (!file.getName().endsWith(this.m_extension)) {
            string = file.getAbsolutePath() + this.m_extension;
            this.m_file = new File(string);
        } else {
            this.m_file = file;
        }
        string = this.m_file.getParent();
        String string2 = this.m_file.getName();
        if (string != null && !this.m_defaultDir.equals(string)) {
            this.m_defaultDir = string;
        }
        if (!this.m_defaultFile.equals(string2)) {
            this.m_defaultFile = string2;
        }
    }

    public boolean autoOpen(PgmDescriptor pgmDescriptor) {
        return this.autoOpen(pgmDescriptor.getPgmLibrary(), pgmDescriptor.getPgmName(), pgmDescriptor.getPgmType());
    }

    public boolean autoOpen(String string, String string2, int n) {
        this.m_pgmLib = string;
        this.m_pgmName = string2;
        this.m_pgmType = n;
        this.m_pgmPath = PgmDescriptor.getPgmPath(this.m_pgmLib, this.m_pgmName, this.m_pgmType);
        if (!this.getAutoOpenSetting()) {
            return false;
        }
        String string3 = this.m_userCfg.getString("pgmEnvPgm", "");
        int n2 = this.m_userCfg.getInt("pgmEnvPgmType", -1);
        if (this.m_defaultFile.length() == 0 || this.m_pgmType != n2 || !this.m_pgmName.equals(string3)) {
            this.m_defaultFile = "";
            this.m_file = new File(this.m_homeDir, this.m_extension);
        } else {
            this.m_file = new File(this.m_defaultDir, this.m_defaultFile);
        }
        return this.open(true);
    }

    public boolean open(File file) {
        this.setFile(file);
        return this.open(false);
    }

    protected boolean open(boolean bl) {
        String string;
        Object[] objectArray;
        boolean bl2 = !bl;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        this.m_isAutoOpen = bl;
        try {
            if (this.m_file.exists() && this.m_file.canRead()) {
                this.m_envFile = new DebugFile(this.m_file);
                objectArray = this.m_envFile.readString();
                string = this.m_envFile.readString();
                int n = this.m_envFile.readInt();
                boolean bl6 = string.equals(this.m_pgmName) && n == this.m_pgmType;
                boolean bl7 = objectArray.equals(this.m_pgmLib);
                boolean bl8 = false;
                boolean bl9 = false;
                if (!bl6) {
                    if (bl2) {
                        bl8 = true;
                    } else {
                        bl4 = true;
                    }
                }
                if (!bl4 && !bl7) {
                    bl9 = true;
                    if (bl3) {
                        bl8 = true;
                    } else {
                        bl4 = true;
                    }
                }
                if (!bl4) {
                    if (bl8) {
                        Object[] objectArray2 = new Object[]{PgmDescriptor.getPgmPath((String)objectArray, string, n), PgmDescriptor.getPgmPath(this.m_pgmLib, this.m_pgmName, this.m_pgmType)};
                        String string2 = MessageFormat.format(MRI.get("DBG_OPEN_ENV_WARNING_FMT"), objectArray2);
                        int n2 = Util.confirm(this.m_ctxt.getJFrame(), MRI.get("DBG_OPEN"), string2);
                        if (n2 != 0) {
                            bl4 = true;
                        }
                    }
                    if (!bl4) {
                        this.clearEnv(bl);
                        this.openEnv((String)objectArray, string, n, bl9);
                        this.m_userCfg.setString("pgmEnvDir", this.m_defaultDir);
                        this.m_userCfg.setString("pgmEnvFile", this.m_defaultFile);
                        this.m_userCfg.setString("pgmEnvPgm", this.m_pgmName);
                        this.m_userCfg.setString("pgmEnvPgmLib", this.m_pgmLib);
                        this.m_userCfg.setInt("pgmEnvPgmType", this.m_pgmType);
                        this.m_saved = !bl9;
                        bl5 = true;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (this.m_envFile != null) {
            this.m_envFile.close();
            this.m_envFile = null;
        }
        if (bl5) {
            objectArray = new Object[]{this.m_file.getAbsolutePath()};
            string = MessageFormat.format(MRI.get("DBG_OPEN_ENV_SUCCESS_FMT"), objectArray);
            this.m_ctxt.setMessage(string);
            BreakpointsPanel breakpointsPanel = (BreakpointsPanel)this.m_ctxt.getPanel("breakpoints");
            breakpointsPanel.disableMessages();
            SettingsManager settingsManager = (SettingsManager)this.m_ctxt.getManager("settmgr");
            settingsManager.insertRecentEnv(this.m_file.getAbsolutePath(), this.m_extension);
        } else if (!bl4) {
            objectArray = this.m_file.getAbsolutePath();
            if (!objectArray.equals(string = this.m_homeDir + File.separator + this.m_extension)) {
                Object[] objectArray3 = new Object[]{objectArray};
                String string3 = MessageFormat.format(MRI.get("DBG_OPEN_ENV_ERROR_FMT"), objectArray3);
                this.m_ctxt.setMessage(string3);
                Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), string3);
            }
            this.resetDirectory();
        }
        return bl5;
    }

    protected void clearEnv(boolean bl) {
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        if (!bl) {
            DebugDesktop debugDesktop = this.m_ctxt.getDesktop();
            BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            MonitorsPanel monitorsPanel = (MonitorsPanel)this.m_ctxt.getPanel("monitors");
            breakpointManager.removeAll();
            pgmManager.removeAll();
            debugDesktop.clear();
            monitorsPanel.clear(false);
        }
        breakpointGroupManager.clear();
    }

    protected void openEnv(String string, String string2, int n, boolean bl) throws IOException {
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        MonitorsPanel monitorsPanel = (MonitorsPanel)this.m_ctxt.getPanel("monitors");
        String string3 = bl ? string : "";
        String string4 = bl ? this.m_pgmLib : "";
        pgmManager.openEnvironment(this.m_envFile, string3, string4);
        breakpointGroupManager.openEnvironment(this.m_envFile, string3, string4);
        monitorsPanel.openEnvironment(this.m_envFile, string3, string4);
    }

    public boolean autoSave() {
        boolean bl = true;
        if (!this.m_saved) {
            if (!this.getAutoSaveSetting()) {
                String string = this.m_file.getAbsolutePath();
                if (string.endsWith(File.separator + this.m_extension)) {
                    return bl;
                }
                Object[] objectArray = new Object[]{this.m_file.getAbsolutePath()};
                String string2 = MessageFormat.format(MRI.get("DBG_SAVE_CURRENT_ENV_FMT"), objectArray);
                int n = Util.confirm(this.m_ctxt.getJFrame(), MRI.get("DBG_SAVE"), string2);
                if (n == 0) {
                    bl = this.save();
                }
            } else {
                bl = this.save();
            }
        }
        return bl;
    }

    public boolean save(File file) {
        this.setFile(file);
        this.setSaved(false);
        boolean bl = this.save();
        if (bl) {
            SettingsManager settingsManager = (SettingsManager)this.m_ctxt.getManager("settmgr");
            settingsManager.insertRecentEnv(this.m_file.getAbsolutePath(), this.m_extension);
        }
        return bl;
    }

    public boolean save() {
        boolean bl = false;
        if (!this.m_saved) {
            try {
                this.m_envFile = new DebugFile(this.m_file, 7.10002);
                this.m_envFile.writeString(this.m_pgmLib);
                this.m_envFile.writeString(this.m_pgmName);
                this.m_envFile.writeInt(this.m_pgmType);
                this.saveEnv();
                this.m_userCfg.setString("pgmEnvDir", this.m_defaultDir);
                this.m_userCfg.setString("pgmEnvFile", this.m_defaultFile);
                this.m_userCfg.setString("pgmEnvPgm", this.m_pgmName);
                this.m_userCfg.setString("pgmEnvPgmLib", this.m_pgmLib);
                this.m_userCfg.setInt("pgmEnvPgmType", this.m_pgmType);
                bl = true;
                this.m_saved = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (this.m_envFile != null) {
                this.m_envFile.close();
                this.m_envFile = null;
            }
        } else {
            bl = true;
        }
        Object[] objectArray = new Object[]{this.m_file.getAbsolutePath()};
        if (bl) {
            String string = MessageFormat.format(MRI.get("DBG_SAVE_ENV_SUCCESS_FMT"), objectArray);
            this.m_ctxt.setMessage(string);
        } else {
            String string = MessageFormat.format(MRI.get("DBG_SAVE_ENV_ERROR_FMT"), objectArray);
            this.m_ctxt.setMessage(string);
            Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), string);
            this.resetDirectory();
        }
        return bl;
    }

    protected void saveEnv() throws IOException {
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        MonitorsPanel monitorsPanel = (MonitorsPanel)this.m_ctxt.getPanel("monitors");
        pgmManager.saveEnvironment(this.m_envFile);
        breakpointGroupManager.saveEnvironment(this.m_envFile);
        monitorsPanel.saveEnvironment(this.m_envFile);
    }

    protected class EnvFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(PgmEnvironment.this.m_extension) && !string.equals(PgmEnvironment.this.m_extension);
        }

        public String getDescription() {
            return PgmEnvironment.this.m_description;
        }
    }

    public class EnvChooser
    extends JFileChooser {
        public EnvChooser() {
            this.setFileFilter(new EnvFilter());
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }

        public EnvChooser(String string) {
            super(string);
            this.setFileFilter(new EnvFilter());
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
    }
}

