/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.BreakpointDescriptor;
import java.util.ArrayList;
import java.util.Collections;

public class Breakpoints {
    protected static final int TABLE_SIZE = 10;
    protected BreakpointDescriptor[] m_table = new BreakpointDescriptor[this.m_tableSize];
    protected int m_tableSize = 10;
    protected int m_count = 0;
    protected int m_limit = (int)((double)this.m_tableSize * 0.75);

    public void cleanUp() {
        for (int i = 0; i < this.m_tableSize; ++i) {
            BreakpointDescriptor breakpointDescriptor = this.m_table[i];
            while (breakpointDescriptor != null) {
                BreakpointDescriptor breakpointDescriptor2 = breakpointDescriptor.next();
                breakpointDescriptor.setNext(null);
                breakpointDescriptor = breakpointDescriptor2;
            }
            this.m_table[i] = null;
        }
        this.m_table = null;
    }

    public int getCount() {
        return this.m_count;
    }

    int getCount(int n) {
        if (this.m_count == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < this.m_tableSize; ++i) {
            for (BreakpointDescriptor breakpointDescriptor = this.m_table[i]; breakpointDescriptor != null; breakpointDescriptor = breakpointDescriptor.next()) {
                if (breakpointDescriptor.getGroupId() != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    boolean containsGroup(int n) {
        if (this.m_count == 0) {
            return false;
        }
        boolean bl = false;
        block0: for (int i = 0; !bl && i < this.m_tableSize; ++i) {
            for (BreakpointDescriptor breakpointDescriptor = this.m_table[i]; breakpointDescriptor != null; breakpointDescriptor = breakpointDescriptor.next()) {
                if (breakpointDescriptor.getGroupId() != n) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public boolean breakpointExists(int n) {
        return this.getDescriptor(n) != null;
    }

    public BreakpointDescriptor getDescriptor(int n) {
        if (this.m_count == 0) {
            return null;
        }
        BreakpointDescriptor breakpointDescriptor = null;
        int n2 = this.hash(n, this.m_table.length);
        for (BreakpointDescriptor breakpointDescriptor2 = this.m_table[n2]; breakpointDescriptor2 != null; breakpointDescriptor2 = breakpointDescriptor2.next()) {
            if (breakpointDescriptor2.getLineNum() != n) continue;
            if (breakpointDescriptor2.getGroupId() < 0) break;
            breakpointDescriptor = breakpointDescriptor2;
            break;
        }
        return breakpointDescriptor;
    }

    public void getDescriptors(ArrayList arrayList) {
        if (this.m_count > 0) {
            ArrayList<BreakpointDescriptor> arrayList2 = new ArrayList<BreakpointDescriptor>(this.m_count);
            for (int i = 0; i < this.m_tableSize; ++i) {
                for (BreakpointDescriptor breakpointDescriptor = this.m_table[i]; breakpointDescriptor != null; breakpointDescriptor = breakpointDescriptor.next()) {
                    arrayList2.add(breakpointDescriptor);
                }
            }
            Collections.sort(arrayList2);
            arrayList.addAll(arrayList2);
            arrayList2.clear();
        }
    }

    public ArrayList getDescriptors() {
        ArrayList arrayList = new ArrayList();
        this.getDescriptors(arrayList);
        return arrayList;
    }

    public void getDescriptors(ArrayList arrayList, int n) {
        if (this.m_count > 0) {
            ArrayList<BreakpointDescriptor> arrayList2 = new ArrayList<BreakpointDescriptor>(this.m_count);
            for (int i = 0; i < this.m_tableSize; ++i) {
                for (BreakpointDescriptor breakpointDescriptor = this.m_table[i]; breakpointDescriptor != null; breakpointDescriptor = breakpointDescriptor.next()) {
                    if (breakpointDescriptor.getGroupId() != n) continue;
                    arrayList2.add(breakpointDescriptor);
                }
            }
            Collections.sort(arrayList2);
            arrayList.addAll(arrayList2);
            arrayList2.clear();
        }
    }

    public ArrayList getDescriptors(int n) {
        ArrayList arrayList = new ArrayList();
        this.getDescriptors(arrayList, n);
        return arrayList;
    }

    public void put(BreakpointDescriptor breakpointDescriptor) {
        int n = this.hash(breakpointDescriptor.getLineNum(), this.m_table.length);
        for (BreakpointDescriptor breakpointDescriptor2 = this.m_table[n]; breakpointDescriptor2 != null; breakpointDescriptor2 = breakpointDescriptor2.next()) {
            if (breakpointDescriptor2.getLineNum() != breakpointDescriptor.getLineNum()) continue;
            breakpointDescriptor2.copy(breakpointDescriptor);
            return;
        }
        if (this.m_count >= this.m_limit) {
            this.rehash();
            n = this.hash(breakpointDescriptor.getLineNum(), this.m_table.length);
        }
        breakpointDescriptor.setNext(this.m_table[n]);
        this.m_table[n] = breakpointDescriptor;
        ++this.m_count;
    }

    public void remove(int n) {
        int n2 = this.hash(n, this.m_table.length);
        BreakpointDescriptor breakpointDescriptor = null;
        for (BreakpointDescriptor breakpointDescriptor2 = this.m_table[n2]; breakpointDescriptor2 != null; breakpointDescriptor2 = breakpointDescriptor2.next()) {
            if (breakpointDescriptor2.getLineNum() == n) {
                if (breakpointDescriptor != null) {
                    breakpointDescriptor.setNext(breakpointDescriptor2.next());
                } else {
                    this.m_table[n2] = breakpointDescriptor2.next();
                }
                --this.m_count;
                break;
            }
            breakpointDescriptor = breakpointDescriptor2;
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.m_table.length; ++i) {
            this.m_table[i] = null;
        }
        this.m_count = 0;
    }

    protected void rehash() {
        int n = this.m_table.length;
        BreakpointDescriptor[] breakpointDescriptorArray = this.m_table;
        this.m_tableSize = this.m_tableSize * 2 + 1;
        this.m_table = new BreakpointDescriptor[this.m_tableSize];
        this.m_limit = (int)((double)this.m_tableSize * 0.75);
        for (int i = 0; i < n; ++i) {
            BreakpointDescriptor breakpointDescriptor = null;
            BreakpointDescriptor breakpointDescriptor2 = breakpointDescriptorArray[i];
            while (breakpointDescriptor2 != null) {
                breakpointDescriptor = breakpointDescriptor2.next();
                int n2 = this.hash(breakpointDescriptor2.getLineNum(), this.m_tableSize);
                breakpointDescriptor2.setNext(this.m_table[n2]);
                this.m_table[n2] = breakpointDescriptor2;
                breakpointDescriptor2 = breakpointDescriptor;
            }
            breakpointDescriptorArray[i] = null;
        }
    }

    protected int hash(int n, int n2) {
        double d = (double)n * 0.6180339887;
        return (int)((double)n2 * (d - Math.floor(d)));
    }
}

