/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.notifications.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageCache {
    private static HashMap<String, Image> IMAGE_MAP = new HashMap();

    public static Image getImage(String fileName) {
        Image image = IMAGE_MAP.get(fileName);
        if (image == null) {
            image = ImageCache.createImage(fileName);
            IMAGE_MAP.put(fileName, image);
        }
        return image;
    }

    private static Image createImage(String fileName) {
        ClassLoader classLoader = ImageCache.class.getClassLoader();
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null && (is = classLoader.getResourceAsStream(fileName)) == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null) {
            return null;
        }
        Image img = new Image((Device)Display.getDefault(), is);
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return img;
    }

    public static void dispose() {
        Iterator<Image> e = IMAGE_MAP.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }
}

