/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.notifications.cache;

import java.util.ArrayList;
import java.util.List;
import miworkplace.notifications.cache.OneFont;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontCache {
    private static List<OneFont> _existing = new ArrayList<OneFont>();

    public static void disposeAll() {
        for (OneFont of : _existing) {
            if (of.getFont() == null || of.getFont().isDisposed()) continue;
            of.getFont().dispose();
        }
        _existing.clear();
    }

    public static Font getFont(FontData fd) {
        try {
            OneFont of2;
            boolean disposed = false;
            OneFont toRemove = null;
            for (OneFont of2 : _existing) {
                if (!of2.matches(fd)) continue;
                if (of2.getFont().isDisposed()) {
                    disposed = true;
                    toRemove = of2;
                    break;
                }
                return of2.getFont();
            }
            if (disposed) {
                _existing.remove(toRemove);
            }
            of2 = new OneFont(fd);
            _existing.add(of2);
            return of2.getFont();
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public static int getCount() {
        return _existing.size();
    }

    public static Font getFont(Font font) {
        block3: {
            try {
                if (font != null && !font.isDisposed()) break block3;
                return null;
            }
            catch (Exception err) {
                err.printStackTrace();
                return null;
            }
        }
        FontData fd = font.getFontData()[0];
        return FontCache.getFont(fd);
    }

    public static Font getFont(String fontName, int height, int style) {
        try {
            OneFont of2;
            boolean disposed = false;
            OneFont toRemove = null;
            for (OneFont of2 : _existing) {
                if (!of2.getName().equals(fontName) || of2.getHeight() != height || of2.getStyle() != style) continue;
                if (of2.getFont().isDisposed()) {
                    disposed = true;
                    toRemove = of2;
                    break;
                }
                return of2.getFont();
            }
            if (disposed) {
                _existing.remove(toRemove);
            }
            of2 = new OneFont(fontName, height, style);
            _existing.add(of2);
            return of2.getFont();
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }
}

