/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import miworkplace.notifications.cache.ColorCache;
import miworkplace.notifications.cache.FontCache;
import miworkplace.notifications.cache.ImageCache;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class Notifier {
    private static final int NOTIFICATION_WIDTH = 352;
    private static final int NOTIFICATION_HEIGHT = 102;
    private static Placement placement = Placement.SCREEN_BOTTOM;
    private static final int DISPLAY_TIME = 5000;
    private static final int FADE_TIMER = 50;
    private static final int FADE_IN_STEP = 30;
    private static final int FADE_OUT_STEP = 8;
    private static final int FINAL_ALPHA = 225;
    private static Color _titleFgColor;
    private static Color _fgColor;
    private static Color _bgFgGradient;
    private static Color _bgBgGradient;
    private static Color _borderColor;
    private static List<Shell> _activeShells;
    private static Image _oldImage;
    private static Shell _shell;

    static {
        _fgColor = _titleFgColor = ColorCache.getColor(40, 73, 97);
        _bgFgGradient = ColorCache.getColor(226, 239, 249);
        _bgBgGradient = ColorCache.getColor(177, 211, 243);
        _borderColor = ColorCache.getColor(40, 73, 97);
        _activeShells = new ArrayList<Shell>();
    }

    public static void info(String title, String message) {
        Notifier.notify(title, message, Type.INFO, true);
    }

    public static void error(String title, String message) {
        Notifier.notify(title, message, Type.ERROR, true);
    }

    public static void warn(String title, String message) {
        Notifier.notify(title, message, Type.WARN, true);
    }

    public static void notify(String title, String message) {
        Notifier.notify(title, message, Type.INFO, true);
    }

    public static void notify(String title, String message, Type type, boolean fadeOut) {
        if (Display.getCurrent() == null) {
            new Exception().printStackTrace();
            Display.getDefault().asyncExec(() -> {
                Shell shell = Display.getDefault().getActiveShell();
                if (shell == null) {
                    shell = Display.getDefault().getShells()[1];
                }
                Notifier.notify(shell, title, message, type, fadeOut, 5000);
            });
        } else {
            Shell shell = Display.getCurrent().getActiveShell();
            if (shell == null) {
                shell = Display.getCurrent().getShells()[1];
            }
            Notifier.notify(shell, title, message, type, fadeOut, 5000);
        }
    }

    public static void notify(Shell parentShell, String title, String message, Type type, boolean fadeOut, int displayTime) {
        Notifier.setColors(type, parentShell);
        _shell = new Shell(parentShell, 524296);
        _shell.setLayout((Layout)new FillLayout());
        _shell.setForeground(_fgColor);
        _shell.setBackgroundMode(1);
        _shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                _activeShells.remove(_shell);
            }
        });
        Composite inner = new Composite((Composite)_shell, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginLeft = 5;
        gl.marginTop = 0;
        gl.marginRight = 5;
        gl.marginBottom = 5;
        CloseListener closeListener = new CloseListener(_shell);
        inner.addListener(4, (Listener)closeListener);
        inner.setLayout((Layout)gl);
        _shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Rectangle rect = _shell.getClientArea();
                    Image newImage = new Image((Device)Display.getDefault(), Math.max(1, rect.width), rect.height);
                    GC gc = new GC((Drawable)newImage);
                    gc.setForeground(_bgFgGradient);
                    gc.setBackground(_bgBgGradient);
                    gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                    gc.setLineWidth(2);
                    gc.setForeground(_borderColor);
                    gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                    gc.dispose();
                    _shell.setBackgroundImage(newImage);
                    if (_oldImage != null) {
                        _oldImage.dispose();
                    }
                    _oldImage = newImage;
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        });
        GC gc = new GC((Drawable)_shell);
        String[] lines = message.split("\n");
        Point longest = null;
        int typicalHeight = gc.stringExtent((String)"X").y;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Point extent = gc.stringExtent(line);
            if (longest == null) {
                longest = extent;
            } else if (extent.x > longest.x) {
                longest = extent;
            }
            ++n2;
        }
        gc.dispose();
        int minHeight = typicalHeight * lines.length;
        CLabel imgLabel = new CLabel(inner, 0);
        imgLabel.setLayoutData((Object)new GridData(34));
        imgLabel.setImage(type.getImage());
        imgLabel.addListener(3, (Listener)closeListener);
        CLabel titleLabel = new CLabel(inner, 0);
        titleLabel.setLayoutData((Object)new GridData(772));
        titleLabel.setText(title);
        titleLabel.setForeground(_titleFgColor);
        titleLabel.addListener(3, (Listener)closeListener);
        Font f = titleLabel.getFont();
        FontData fd = f.getFontData()[0];
        fd.setStyle(1);
        fd.height = 11.0f;
        titleLabel.setFont(FontCache.getFont(fd));
        Label text = new Label(inner, 64);
        text.addListener(3, (Listener)closeListener);
        Font tf = text.getFont();
        FontData tfd = tf.getFontData()[0];
        tfd.setStyle(1);
        tfd.height = 8.0f;
        text.setFont(FontCache.getFont(tfd));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        text.setForeground(_fgColor);
        text.setText(message);
        minHeight = 100;
        _shell.setSize(350, minHeight);
        if (Display.getDefault().getActiveShell() == null || Display.getDefault().getActiveShell().getMonitor() == null) {
            return;
        }
        Point startingPoint = Notifier.computeStartingPoint();
        if (!_activeShells.isEmpty()) {
            ArrayList<Shell> modifiable = new ArrayList<Shell>(_activeShells);
            Collections.reverse(modifiable);
            for (Shell shell : modifiable) {
                if (shell.isDisposed()) continue;
                Point curLoc = shell.getLocation();
                shell.setLocation(curLoc.x, curLoc.y - 100);
                if (curLoc.y - 100 >= 0) continue;
                _activeShells.remove(shell);
                shell.dispose();
            }
        }
        _shell.setLocation(startingPoint.x, startingPoint.y);
        _shell.setAlpha(0);
        _shell.setVisible(true);
        _activeShells.add(_shell);
        Notifier.fadeIn(_shell, fadeOut, displayTime);
    }

    private static void setColors(Type pType, Shell pParentShell) {
        int blue = pParentShell.getBackground().getBlue();
        if (blue > 100) {
            _fgColor = _titleFgColor = ColorCache.getColor(40, 40, 40);
            _bgFgGradient = ColorCache.getColor(226, 239, 249);
            _bgBgGradient = ColorCache.getColor(186, 189, 180);
            _borderColor = ColorCache.getColor(40, 40, 40);
        } else {
            _fgColor = _titleFgColor = ColorCache.getColor(200, 200, 200);
            _bgFgGradient = ColorCache.getColor(0, 0, 0);
            _bgBgGradient = ColorCache.getColor(100, 100, 100);
            _borderColor = ColorCache.getColor(140, 50, 50);
        }
        if (pType == Type.SUCCESS || pType == Type.CONNECTED) {
            _borderColor = pParentShell.getDisplay().getSystemColor(5);
        } else if (pType == Type.ERROR || pType == Type.CONNECTION_FAILED || pType == Type.CONNECTION_TERMINATED || pType == Type.DELETE || pType == Type.TRANSACTION_FAIL) {
            _borderColor = pParentShell.getDisplay().getSystemColor(4);
        } else if (pType == Type.INFO) {
            _borderColor = pParentShell.getDisplay().getSystemColor(6);
        } else if (pType == Type.HINT) {
            _borderColor = pParentShell.getDisplay().getSystemColor(9);
        } else if (pType == Type.WARN || pType == Type.DISCONNECTED) {
            _borderColor = pParentShell.getDisplay().getSystemColor(3);
        }
    }

    private static Point computeStartingPoint() {
        int startX = 0;
        int startY = 0;
        switch (placement) {
            case WINDOW_CENTER: {
                Point location = Display.getDefault().getActiveShell().getLocation();
                Rectangle area = Display.getDefault().getActiveShell().getBounds();
                startX = location.x + area.width / 2 - 176;
                startY = location.y + area.height / 2 - 51;
                break;
            }
            case WINDOW_BOTTOM: {
                Point location = Display.getDefault().getActiveShell().getLocation();
                Rectangle area = Display.getDefault().getActiveShell().getBounds();
                startX = location.x + area.width - 352;
                startY = location.y + area.height - 102;
                break;
            }
            case SCREEN_CENTER: {
                Rectangle area = Display.getDefault().getActiveShell().getMonitor().getBounds();
                startX = area.width / 2 - 176;
                startY = area.height / 2 - 51;
                break;
            }
            case SCREEN_BOTTOM: {
                Rectangle area = Display.getDefault().getActiveShell().getMonitor().getClientArea();
                startX = area.x + area.width - 352;
                startY = area.y + area.height - 102;
            }
        }
        return new Point(startX, startY);
    }

    private static void fadeIn(final Shell _shell, final boolean fadeOut, final int displayTime) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    int cur = _shell.getAlpha();
                    if ((cur += 30) > 225) {
                        _shell.setAlpha(225);
                        Notifier.startTimer(_shell, fadeOut, displayTime);
                        return;
                    }
                    _shell.setAlpha(cur);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(50, run);
    }

    private static void startTimer(final Shell _shell, final boolean fadeOut, int displayTime) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    if (fadeOut) {
                        Notifier.fadeOut(_shell);
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(displayTime, run);
    }

    private static void fadeOut(final Shell _shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    int cur = _shell.getAlpha();
                    if ((cur -= 8) <= 0) {
                        _shell.setAlpha(0);
                        if (_oldImage != null) {
                            _oldImage.dispose();
                        }
                        _shell.dispose();
                        _activeShells.remove(_shell);
                        return;
                    }
                    _shell.setAlpha(cur);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(50, run);
    }

    public static Placement getPlacement() {
        return placement;
    }

    public static void setPlacement(Placement placement) {
        Notifier.placement = placement;
    }

    static class CloseListener
    implements Listener {
        private final Shell shell;

        public CloseListener(Shell shell) {
            this.shell = shell;
        }

        public void handleEvent(Event event) {
            this.shell.dispose();
        }
    }

    public static enum Placement {
        WINDOW_CENTER,
        SCREEN_CENTER,
        WINDOW_BOTTOM,
        SCREEN_BOTTOM;

    }

    public static enum Type {
        ERROR(ImageCache.getImage("error.png")),
        DELETE(ImageCache.getImage("delete.png")),
        WARN(ImageCache.getImage("warn.png")),
        SUCCESS(ImageCache.getImage("ok.png")),
        INFO(ImageCache.getImage("info.png")),
        LIBRARY(ImageCache.getImage("library.png")),
        HINT(ImageCache.getImage("hint.png")),
        PRINTED(ImageCache.getImage("printer.png")),
        CONNECTION_TERMINATED(ImageCache.getImage("terminated.png")),
        CONNECTION_FAILED(ImageCache.getImage("connecting.png")),
        CONNECTED(ImageCache.getImage("connected.png")),
        DISCONNECTED(ImageCache.getImage("disconnected.png")),
        TRANSACTION_OK(ImageCache.getImage("ok.png")),
        TRANSACTION_FAIL(ImageCache.getImage("error.png"));

        private Image _image;

        private Type(Image img) {
            this._image = img;
        }

        public Image getImage() {
            return this._image;
        }
    }
}

